/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.util;

import de.seetec.v5.shared.util.FileEncrypter;
import de.seetec.v5.shared.util.ZipProxy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.zip.ZipException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SevenZipProxy
implements ZipProxy,
FileEncrypter {
    private final Logger logger = LogManager.getRootLogger();
    private final Path pathToExecutable;
    private boolean verbose = true;
    private int levelOfCompression;

    public SevenZipProxy() {
        this.pathToExecutable = FileSystems.getDefault().getPath(".", new String[0]);
    }

    public SevenZipProxy(Path pathToExecutable, boolean verbose) throws ZipException {
        this.pathToExecutable = pathToExecutable;
        if (this.pathToExecutable == null) {
            throw new ZipException("Mandatory argument null");
        }
        this.verbose = verbose;
    }

    @Override
    public final void zip(String input, String destinationFile, String password) throws ZipException {
        this.levelOfCompression = 0;
        this.execute(input, destinationFile, password);
    }

    @Override
    public void encrypt(String input, String destinationFile, String password) throws ZipException {
        this.levelOfCompression = 0;
        this.execute(input, destinationFile, password);
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="All input parameters are verified.")
    private void execute(String input, String destinationFile, String password) throws ZipException {
        if (input == null) {
            throw new ZipException("Mandatory argument null");
        }
        if (destinationFile == null) {
            throw new ZipException("Mandatory argument null");
        }
        if (password == null || password.isEmpty()) {
            throw new ZipException("Mandatory argument null");
        }
        this.checkForInvalidCharacters(password);
        try {
            String processName = this.pathToExecutable.resolve("7za.exe").toAbsolutePath().toString();
            String arguments = String.format("a -p%1$s -mhe \"%2$s\" \"%3$s\" -mx=%4$s", password, destinationFile, input, this.levelOfCompression);
            String command = processName + " " + arguments;
            Process process = Runtime.getRuntime().exec(command);
            try (BufferedReader inputBufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = inputBufferedReader.readLine()) != null) {
                    if (!this.verbose) continue;
                    this.logger.info(line);
                }
            }
            this.checkReturnValue(process);
        }
        catch (IOException ioException) {
            throw new ZipException(ioException.getMessage());
        }
    }

    private void checkForInvalidCharacters(String password) throws ZipException {
        if (password.contains("\"")) {
            throw new ZipException("Password contains non-supported characters");
        }
    }

    private void checkReturnValue(Process process) throws ZipException {
        if (process.exitValue() != 0) {
            throw new ZipException("7Zip returned error code: " + process.exitValue());
        }
    }
}

