/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.util;

import de.seetec.v5.shared.util.CpuLoadData;
import de.seetec.v5.shared.util.NamedThreadFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CpuLoadStats
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger((String)CpuLoadStats.class.getName());
    private final long defaultTime = 10L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("CpuLoadStats"));
    protected List<CpuLoadData> slidingWindow = Collections.synchronizedList(new ArrayList());
    private final int numberOfDataPoints = 8640;

    public int init() {
        boolean isFunctionalityProvided = false;
        try {
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() < time + TimeUnit.SECONDS.toMillis(3L)) {
                if (this.getCpuLoad().getSystemCpuLoad() != -1.0) {
                    isFunctionalityProvided = true;
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.debug("Error while sleeping.");
                }
            }
            if (isFunctionalityProvided) {
                this.scheduler.scheduleWithFixedDelay(this, 0L, 10L, TimeUnit.SECONDS);
                return 0;
            }
            LOGGER.info("Used VM does not provide functionality.");
            return -20000;
        }
        catch (Exception e) {
            LOGGER.warn("Exception while initializing CPU load daemon: " + e.getMessage());
            return -20000;
        }
    }

    @Override
    public void run() {
        try {
            if (this.slidingWindow.size() == 8640) {
                this.slidingWindow.remove(0);
            }
            this.slidingWindow.add(this.getCpuLoad());
        }
        catch (Throwable t) {
            LOGGER.error("Error while running: " + t.getMessage(), t);
            this.scheduler.scheduleWithFixedDelay(this, 0L, 10L, TimeUnit.SECONDS);
        }
    }

    protected CpuLoadData getCpuLoad() {
        CpuLoadData result = new CpuLoadData();
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            result.setCpuNumber(operatingSystemMXBean.getAvailableProcessors());
            for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
                method.setAccessible(true);
                if (!Modifier.isPublic(method.getModifiers())) continue;
                if (method.getName().equalsIgnoreCase("getProcessCpuLoad")) {
                    result.setProcessCpuLoad((Double)method.invoke((Object)operatingSystemMXBean, new Object[0]));
                    continue;
                }
                if (!method.getName().equalsIgnoreCase("getSystemCpuLoad")) continue;
                result.setSystemCpuLoad((Double)method.invoke((Object)operatingSystemMXBean, new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private int[][] calculateStatistics() {
        CpuLoadData[] collectedData = new CpuLoadData[]{};
        collectedData = this.slidingWindow.toArray(collectedData);
        int[][] result = new int[2][10];
        for (CpuLoadData singleStat : collectedData) {
            int slot = singleStat.getSystemCpuLoad() == -1.0 ? 0 : (int)(singleStat.getSystemCpuLoad() * 10.0);
            slot = slot >= 10 ? 9 : slot;
            int numberInSlot = result[LOAD_TYPE.SYSTEM.getRowIndex()][slot];
            result[LOAD_TYPE.SYSTEM.getRowIndex()][slot] = ++numberInSlot;
            slot = singleStat.getProcessCpuLoad() == -1.0 ? 0 : (int)(singleStat.getProcessCpuLoad() * 10.0);
            slot = slot >= 10 ? 9 : slot;
            numberInSlot = result[LOAD_TYPE.PROCESS.getRowIndex()][slot];
            result[LOAD_TYPE.PROCESS.getRowIndex()][slot] = ++numberInSlot;
        }
        return result;
    }

    public CpuLoadData getCurrentLoad() {
        return this.getCpuLoad();
    }

    public double getAverageSystemLoad() {
        return this.getAverage(LOAD_TYPE.SYSTEM);
    }

    public String getAverageSystemLoadAsString() {
        return this.getAverageAsString(this.getAverageSystemLoad());
    }

    public int[] getEquipartitionSystemLoad() {
        return this.calculateStatistics()[LOAD_TYPE.SYSTEM.getRowIndex()];
    }

    public String getEquipartitionSystemLoadAsString() {
        return this.getEquipartitionSystemLoadAsString(null);
    }

    public String getEquipartitionSystemLoadAsString(String indent) {
        return this.getEquipartitionAsString(this.getEquipartitionSystemLoad(), indent);
    }

    public double getAverageProcessLoad() {
        return this.getAverage(LOAD_TYPE.PROCESS);
    }

    public String getAverageProcessLoadAsString() {
        return this.getAverageAsString(this.getAverageProcessLoad());
    }

    public int[] getEquipartitionProcessLoad() {
        return this.calculateStatistics()[LOAD_TYPE.PROCESS.getRowIndex()];
    }

    public String getEquipartitionProcessLoadAsString() {
        return this.getEquipartitionProcessLoadAsString(null);
    }

    public String getEquipartitionProcessLoadAsString(String indent) {
        return this.getEquipartitionAsString(this.getEquipartitionProcessLoad(), indent);
    }

    private String getAverageAsString(double average) {
        return average == -1.0 ? "" : String.format("%2d%%", (int)(average * 100.0));
    }

    private double getAverage(LOAD_TYPE type) {
        CpuLoadData[] collectedData = new CpuLoadData[]{};
        if ((collectedData = this.slidingWindow.toArray(collectedData)).length == 0) {
            return -1.0;
        }
        double cumulatedLoad = 0.0;
        for (CpuLoadData singleStat : collectedData) {
            if (type == LOAD_TYPE.SYSTEM) {
                cumulatedLoad += singleStat.getSystemCpuLoad();
                continue;
            }
            if (type != LOAD_TYPE.PROCESS) continue;
            cumulatedLoad += singleStat.getProcessCpuLoad() == -1.0 ? 0.0 : singleStat.getProcessCpuLoad();
        }
        return cumulatedLoad / (double)collectedData.length;
    }

    private String getEquipartitionAsString(int[] stat, String indent) {
        int allCollectedItems = 0;
        for (int i = 0; i < stat.length; ++i) {
            allCollectedItems += stat[i];
        }
        StringBuilder builder = new StringBuilder();
        if (allCollectedItems > 0) {
            for (int i = 0; i < stat.length; ++i) {
                builder.append(indent != null ? indent : "");
                builder.append(String.format("%3d%%-%3d%%: ", i * 10, i * 10 + 10));
                builder.append(String.format("%3d%% of time.", stat[i] * 100 / allCollectedItems));
                builder.append("\r\n");
            }
        }
        return builder.toString();
    }

    public int shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        return 0;
    }

    protected static enum LOAD_TYPE {
        SYSTEM(0),
        PROCESS(1);

        private final int rowIndex;

        private LOAD_TYPE(int index) {
            this.rowIndex = index;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }
}

