/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.tree;

import de.seetec.v5.shared.tree.TreeNode;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

public class Tree<T>
implements Serializable {
    private static final long serialVersionUID = 3369341432478642090L;
    private TreeNode<T> root;
    private Map<String, TreeNode<T>> nodes = new Hashtable<String, TreeNode<T>>();

    public Tree() {
    }

    public Tree(TreeNode<T> root) {
        this.setRoot(root);
        this.updateStructure(root);
    }

    private void updateStructure(TreeNode<T> root) {
        if (root != null) {
            for (TreeNode<T> node : root.getChildren()) {
                this.nodes.put("" + node.getKey(), node);
                this.updateStructure(node);
            }
        }
    }

    public TreeNode<T> getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode<T> root) {
        this.root = root;
        this.nodes.put("" + root.getKey(), root);
    }

    public Map<String, TreeNode<T>> getNodes() {
        return this.nodes;
    }

    public int getSize() {
        return this.nodes.size();
    }

    public int insertIntoTree(T node, long key, long parentID) {
        if (node != null) {
            TreeNode<T> n = new TreeNode<T>(node, key);
            if (parentID == Long.MIN_VALUE) {
                this.setRoot(n);
                return 0;
            }
            TreeNode<T> parent = this.nodes.get("" + parentID);
            if (parent != null) {
                parent.setChild(n);
                this.nodes.put("" + key, n);
                return 0;
            }
            return 0;
        }
        return -20000;
    }
}

