/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.token;

import de.seetec.v5.shared.token.TokenKey;
import de.seetec.v5.shared.token.TokenValueProvider;
import de.seetec.v5.shared.util.SeeTecException;
import java.security.Key;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class TokenValueProviderImpl
implements TokenValueProvider {
    static final long JWT_TOKEN_EXPIRATION_TIME = TimeUnit.MINUTES.toMillis(5L);
    static final String USER_ID_KEY = "userId";
    static final String SECURE_ID = "secureId";
    static final String INSTALLATION_ID_KEY = "installationId";
    static final String AD_GROUPS = "activeDirectoryGroupIds";
    static final String VMS_USERNAME = "userName";
    static final String VMS_HOSTNAME = "hostName";
    private static final Logger LOGGER = LogManager.getLogger(TokenValueProviderImpl.class);
    protected final Key key;
    protected final String algorithmToUse = "HS512";
    protected final JwtConsumer jwtConsumer;
    protected String installationId;

    public TokenValueProviderImpl(TokenKey tokenKey, String installationId) {
        this.key = tokenKey.getKey();
        this.installationId = installationId;
        AlgorithmConstraints jwsAlgConstraints = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"HS512"});
        this.jwtConsumer = new JwtConsumerBuilder().setMaxFutureValidityInMinutes(300).setVerificationKey(this.key).setJwsAlgorithmConstraints(jwsAlgConstraints).setRelaxVerificationKeyValidation().build();
    }

    @Override
    public Long getUserIdFromToken(String token) throws SeeTecException {
        JwtClaims jwtClaims = this.getTokenClaims(token);
        try {
            this.checkInstallationId(jwtClaims);
            Long userId = (Long)jwtClaims.getClaimValue(USER_ID_KEY, Long.class);
            if (userId == null) {
                LOGGER.error("The token sent has no UserId");
                throw new SeeTecException(-50501, "The token sent has no UserId");
            }
            return userId;
        }
        catch (MalformedClaimException ex) {
            LOGGER.error("The token sent has Malformed Claims");
            throw new SeeTecException(-50501, ex.getMessage(), ex);
        }
    }

    @Override
    public String getUserNameFromToken(String token) throws SeeTecException {
        JwtClaims jwtClaims = this.getTokenClaims(token);
        try {
            this.checkInstallationId(jwtClaims);
            String userName = (String)jwtClaims.getClaimValue(VMS_USERNAME, String.class);
            if (userName == null) {
                LOGGER.error("The token sent has no UserName");
                throw new SeeTecException(-50501, "The token sent has no UserName");
            }
            return userName;
        }
        catch (MalformedClaimException ex) {
            LOGGER.error("The token sent has Malformed Claims");
            throw new SeeTecException(-50501, ex.getMessage(), ex);
        }
    }

    @Override
    public String getHostNameFromToken(String token) throws SeeTecException {
        JwtClaims jwtClaims = this.getTokenClaims(token);
        try {
            this.checkInstallationId(jwtClaims);
            String hostName = (String)jwtClaims.getClaimValue(VMS_HOSTNAME, String.class);
            if (hostName == null) {
                LOGGER.error("The token sent has no HostName");
                throw new SeeTecException(-50501, "The token sent has no HostName");
            }
            return hostName;
        }
        catch (MalformedClaimException ex) {
            LOGGER.error("The token sent has Malformed Claims");
            throw new SeeTecException(-50501, ex.getMessage(), ex);
        }
    }

    @Override
    public String getSecureIdFromToken(String token) throws SeeTecException {
        JwtClaims jwtClaims = this.getTokenClaims(token);
        try {
            this.checkInstallationId(jwtClaims);
            return (String)jwtClaims.getClaimValue(SECURE_ID, String.class);
        }
        catch (MalformedClaimException ex) {
            LOGGER.error("The token sent has Malformed Claims");
            throw new SeeTecException(-50501, ex.getMessage(), ex);
        }
    }

    @Override
    public List<Long> getActiveDirectoryGroupsFromToken(String token) throws SeeTecException {
        JwtClaims jwtClaims = this.getTokenClaims(token);
        try {
            this.checkInstallationId(jwtClaims);
            List activeDirectoryGroupIds = jwtClaims.getStringListClaimValue(AD_GROUPS);
            List<Long> longAdGroups = activeDirectoryGroupIds.stream().map(group -> Long.parseLong(group)).collect(Collectors.toList());
            return longAdGroups;
        }
        catch (MalformedClaimException ex) {
            LOGGER.error("The token sent has Malformed Claims");
            throw new SeeTecException(-50501, ex.getMessage(), ex);
        }
    }

    private void checkInstallationId(JwtClaims jwtClaims) throws SeeTecException, MalformedClaimException {
        String tokenInstallationId = (String)jwtClaims.getClaimValue(INSTALLATION_ID_KEY, String.class);
        if (!tokenInstallationId.equals(this.installationId)) {
            LOGGER.error("The installation id in the token is invalid.");
            throw new SeeTecException(-50501, "Invalid installation id in token: " + tokenInstallationId);
        }
    }

    public NumericDate getExpirationDateFromToken(String token) throws SeeTecException {
        try {
            return this.getTokenClaims(token).getExpirationTime();
        }
        catch (MalformedClaimException ex) {
            throw new SeeTecException(-50501, "The token sent has malformed claims", ex);
        }
    }

    private JwtClaims getTokenClaims(String token) throws SeeTecException {
        try {
            return this.jwtConsumer.processToClaims(token);
        }
        catch (InvalidJwtException ex) {
            if (ex.hasExpired()) {
                LOGGER.error("The token sent has expired");
                throw new SeeTecException(-50502, ((ErrorCodeValidator.Error)ex.getErrorDetails().get(0)).getErrorMessage(), ex);
            }
            LOGGER.error("The token sent was invalid");
            throw new SeeTecException(-50501, ((ErrorCodeValidator.Error)ex.getErrorDetails().get(0)).getErrorMessage(), ex);
        }
    }

    @Override
    public void validateToken(String token) throws SeeTecException {
        this.getTokenClaims(token);
    }
}

