/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.proxy.ssl;

import de.seetec.v5.shared.interaction.KeyDataObject;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.SSLProtocol;
import de.seetec.v5.shared.net.srpc.ent.PingMethodWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcDataType;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.shared.SRPCProxy;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;

public class SSLSRPCProxy
extends SRPCProxy {
    private static final String CLASSNAME = "de.seetec.v5.shared.proxy.ssl.SSLSRPCProxy";
    private Socket socket = null;

    public SSLSRPCProxy() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public int init(SrpcRequestHandlerFactoryIntf srpcHandler, String host, int nPort, long coreID) {
        if (host == null) {
            return -20002;
        }
        try {
            this.socket = NetworkHelper.createSSLconnection(host, nPort, true, SSLProtocol.TLS12, null);
        }
        catch (Exception e) {
            this.logger.error("Error when connecting: " + host + ":" + nPort + ". Message: " + e.getMessage());
            return -20000;
        }
        return super.init(srpcHandler, this.socket, coreID);
    }

    @Override
    public int shutdown() {
        if (this.isShutdown(CLASSNAME)) {
            return 0;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException ioe) {
                this.logger.error("Error closing socket. " + ioe.getMessage());
            }
        }
        return super.shutdown();
    }

    @Override
    public boolean isReady() {
        if (this.isShutdown(CLASSNAME)) {
            return false;
        }
        return super.isReady();
    }

    @Override
    protected SrpcMessage sendRequest(SrpcMessage req, long timeout) throws SeeTecException {
        req.setEncryption((byte)0);
        return super.sendRequest(req, timeout);
    }

    public Entity Ping(long timeout) throws SeeTecException {
        SrpcMessage response = this.sendRequest(PingMethodWrapper.createRequest(), timeout);
        return PingMethodWrapper.parseResponse(response.getPayload());
    }

    public String GetSalt(long timeout) throws SeeTecException {
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_SALT, null), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return rsp.getPayload().getAsString();
    }

    public KeyDataObject GetEncryptionKey(String user, String pass, String pass2, long nTimeout) throws SeeTecException {
        GObject params = GObject.createList();
        params.addChild(user);
        params.addChild(pass);
        params.addChild(pass2);
        params.addChild(GObject.createNull(SrpcDataType.STRING));
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.SSL_FUNCTION_GET_ENCRYPTION_KEY, params), nTimeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return KeyDataObject.parseResponse(rsp.getPayload());
    }
}

