/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.proxy.shared;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.ShutdownCallback;
import de.seetec.v5.shared.networking.srpc.SrpcClientIntf;
import de.seetec.v5.shared.networking.srpc.SrpcFactory;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.proxy.shared.SrpcParams;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SRPCProxy
extends Basic {
    private static final String CLASS_NAME = "de.seetec.v5.shared.proxy.shared.SRPCProxy";
    protected Logger logger = null;
    protected SrpcClientIntf newSrpc = null;
    private SrpcParams reconnectionParams;
    protected volatile CountDownLatch reconnectionLatch = null;
    private volatile AtomicBoolean reconnectionInProgress = new AtomicBoolean(false);

    protected void checkResponseForNull(SrpcMessage response) throws SeeTecException {
        if (null == response) {
            throw new SeeTecException(-20000, "Response was null!");
        }
    }

    protected void checkNonNullResponseForError(SrpcMessage rsp) throws SeeTecException {
        if (rsp.getError() != 0) {
            throw new SeeTecException(rsp.getError(), "");
        }
    }

    protected SrpcMessage sendRequest(SrpcMessage req, long timeout) throws SeeTecException {
        try {
            return this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            throw new SeeTecException(-20000, ex.getMessage());
        }
    }

    public SRPCProxy() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(SrpcRequestHandlerFactoryIntf srpcHandler, String sHost, int nPort, long nEntityID) {
        Socket socket;
        try {
            long ts = System.currentTimeMillis();
            socket = new Socket(sHost, nPort);
            long nDuration = System.currentTimeMillis() - ts;
            if (nDuration >= 1000L) {
                this.logger.info("... " + socket + " created within [" + Basic.longToFormattedString(nDuration) + " ms]!");
            }
        }
        catch (Exception ex) {
            this.logger.error("Cannot create socket to [" + sHost + ":" + nPort + "]. Reason: " + ex.getMessage());
            return -20006;
        }
        return this.init(srpcHandler, socket, nEntityID);
    }

    public int init(SrpcRequestHandlerFactoryIntf srpcHandler, Socket socket, long nEntityID) {
        this.reconnectionParams = new SrpcParams(srpcHandler, socket.getInetAddress().getHostAddress(), socket.getPort(), nEntityID);
        try {
            long ts = System.currentTimeMillis();
            this.newSrpc = SrpcFactory.getSrpc(socket, srpcHandler, nEntityID, new ShutdownCallbackImpl(), true);
            long nDuration = System.currentTimeMillis() - ts;
            if (nDuration >= 1000L) {
                this.logger.info(String.format("... got %s within [%,d ms]!", this.newSrpc, nDuration));
            }
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage());
            return -20210;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -20210;
        }
        return 0;
    }

    protected boolean isReconnecting() {
        return this.reconnectionInProgress.get();
    }

    private void reconnect() {
        if (this.reconnectionInProgress.compareAndSet(false, true)) {
            this.logger.info("Reconnecting to " + this.reconnectionParams);
            this.reconnectionLatch = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SRPCProxy.this.newSrpc == null && !SRPCProxy.this.isShutdown(SRPCProxy.CLASS_NAME)) {
                        ShutdownCallbackImpl shutdownCallback = new ShutdownCallbackImpl();
                        try {
                            SRPCProxy.this.newSrpc = SrpcFactory.getSrpc(new Socket(SRPCProxy.this.reconnectionParams.getHost(), SRPCProxy.this.reconnectionParams.getPort()), SRPCProxy.this.reconnectionParams.getHandler(), SRPCProxy.this.reconnectionParams.getEntityID(), shutdownCallback, true);
                        }
                        catch (Throwable t) {
                            SRPCProxy.this.logger.error("Error while reconnecting to " + (SRPCProxy.this.reconnectionParams != null ? SRPCProxy.this.reconnectionParams : "n/a") + ": " + t.getMessage());
                        }
                    }
                    SRPCProxy.this.reconnectionInProgress.set(false);
                    SRPCProxy.this.reconnectionLatch.countDown();
                    SRPCProxy.this.reconnectionLatch = null;
                }
            }, "ReconnectionThread").start();
        }
    }

    public boolean isReady() {
        if (this.isShutdown(CLASS_NAME)) {
            return false;
        }
        if (this.newSrpc == null) {
            return false;
        }
        if (this.newSrpc.isShutdown()) {
            return false;
        }
        return this.newSrpc.isReady();
    }

    protected final void ensureSrpc(long timeout) throws SeeTecException {
        if (!this.isReady()) {
            if (!this.isReconnecting() && !this.isShutdown(CLASS_NAME)) {
                this.newSrpc = null;
                this.reconnect();
            }
            if (this.reconnectionLatch != null) {
                try {
                    this.reconnectionLatch.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.isReady()) {
                this.logger.warn(String.format("Reconnecting [%s] FAILED!", this.reconnectionParams));
                throw new SeeTecException(-20219, String.format("Srpc [%s] not ready!", this.newSrpc));
            }
        }
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (null != this.newSrpc) {
            this.newSrpc.shutdown();
            this.newSrpc = null;
        }
        return 0;
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Socket=[" + (this.reconnectionParams != null ? this.reconnectionParams : "null") + "]";
    }

    private class ShutdownCallbackImpl
    implements ShutdownCallback {
        private ShutdownCallbackImpl() {
        }

        @Override
        public void onShutdown() {
            SRPCProxy.this.newSrpc = null;
        }
    }
}

