/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.crypto.Crypto;
import de.seetec.v5.shared.networking.srpc.EncryptionContext;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SRPCType;
import de.seetec.v5.shared.networking.srpc.SrpcDecompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SrpcMessage {
    private static final int HUGE_DATA_THRESHOLD_IN_BYTES = 0x8000000;
    private static Logger logger = LogManager.getLogger(SrpcMessage.class);
    private static GObject nullResponse = GObject.create("Fire&Forget NULL Response.");
    private static final byte[] MAGIC = new byte[]{-96, -80, -64, -48};
    private static final byte[] VERSION3 = new byte[]{3, 0, 0};
    private static final int INT_MAGIC = ByteBuffer.wrap(MAGIC).getInt();
    private static final int INT_SSL_MAGIC = ByteBuffer.wrap(SSLConstantsIntf.SSL_SRPC_TCP_HEADER).getInt();
    private static EncryptionContext encryptionContext = new EncryptionContext();
    private static final Lock ENCRYPTION_CONTEXT_LOCK = new ReentrantLock(false);
    private byte encryption = 1;
    private byte compression = 0;
    private String token;
    private int type = 0;
    private UUID messageId = UUID.randomUUID();
    private Methods myMethod;
    private int error = 0;
    private GObject payload = null;
    private boolean fafFlag = false;
    private byte[] version = new byte[]{3, 0, 0};

    private SrpcMessage(int type, Methods method, GObject argList, String token) {
        this.type = type;
        this.myMethod = method;
        this.payload = argList;
        this.token = token;
    }

    private SrpcMessage(int type, Methods method, GObject argList, byte compression, byte encryption, String token) {
        this(type, method, argList, token);
        this.encryption = encryption;
        this.compression = compression;
    }

    private SrpcMessage(int type, UUID uuid, int error, int hash, GObject argList, byte compression, byte encryption, String token) {
        this(type, Methods.valueOf(hash), argList, compression, encryption, token);
        this.messageId = uuid;
        this.error = error;
    }

    public static SrpcMessage nullResponse(SrpcMessage req) {
        return SrpcMessage.createResponse(req, nullResponse);
    }

    public static SrpcMessage createRequest(Methods method, GObject argList) {
        return new SrpcMessage(0, method, argList, null);
    }

    public static SrpcMessage createRequest(Methods method, GObject argList, String token) {
        return new SrpcMessage(0, method, argList, token);
    }

    public static SrpcMessage createResponse(SrpcMessage request, GObject argList) {
        SrpcMessage response = new SrpcMessage(1, request.myMethod, argList, request.compression, request.encryption, null);
        response.setId(request.getId());
        response.setVersion(request.getVersion());
        return response;
    }

    public static SrpcMessage createResponse(UUID aMessageId, Methods method, GObject argList) {
        SrpcMessage response = new SrpcMessage(1, method, argList, null);
        response.setId(aMessageId);
        return response;
    }

    public boolean isFireAndForget() {
        return this.fafFlag;
    }

    public void setFireAndForget(boolean isFireAndForget) {
        this.fafFlag = isFireAndForget;
    }

    public boolean isEncrypted() {
        return this.encryption != 0;
    }

    public boolean isCompressed() {
        return this.compression != 0;
    }

    public void setEncryption(byte encryptionMethod) {
        this.encryption = encryptionMethod;
    }

    public void setCompression(byte compression) {
        this.compression = compression;
    }

    public byte getEncryption() {
        return this.encryption;
    }

    public byte getCompression() {
        return this.compression;
    }

    public String getMethodName() {
        return this.myMethod.methodName();
    }

    public Methods getMethod() {
        return this.myMethod;
    }

    public int getHash() {
        return this.myMethod.methodHash();
    }

    public int getHashMd5() {
        return this.myMethod.methodHashMd5();
    }

    public UUID getId() {
        return this.messageId;
    }

    public String getToken() {
        return this.token;
    }

    private void setId(UUID id) {
        this.messageId = id;
    }

    public int getType() {
        return this.type;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public byte[] serialize() throws IOException {
        if (logger.isDebugEnabled() && this.payload != null) {
            logger.debug(String.format("+++ Payload size [%s bytes] for [%s]", this.payload.size(), this.getMethodName()));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeMessageHeader(baos);
        try {
            this.writeMessageParams(baos);
        }
        catch (OutOfMemoryError oom) {
            logger.fatal(String.format("Could not serialize %s bytes of parameters for [%s (%s)]: %s", this.payload.size(), this.getMethodName(), this.messageId, oom.getMessage()));
            baos.reset();
        }
        return baos.toByteArray();
    }

    public static SrpcMessage deserialize(InputStream inputStream, AtomicLong consumedBytes) throws IOException, InterruptedException {
        byte[] buffer;
        consumedBytes.set(0L);
        byte[] magicbuffer = new byte[4];
        int bytesRead = SrpcMessage.readToBuffer(magicbuffer, inputStream);
        if (bytesRead <= 0) {
            return null;
        }
        consumedBytes.addAndGet(bytesRead);
        long startDeserialize = System.nanoTime();
        ByteBuffer bb = ByteBuffer.wrap(magicbuffer);
        int magic = bb.getInt();
        byte[] transmissionHeader = new byte[9];
        if (magic == INT_SSL_MAGIC) {
            buffer = new byte[60];
            bytesRead = SrpcMessage.readToBuffer(buffer, inputStream);
            if (bytesRead <= 0) {
                return null;
            }
            consumedBytes.addAndGet(bytesRead);
            bytesRead = SrpcMessage.readToBuffer(magicbuffer, inputStream);
            if (bytesRead <= 0) {
                return null;
            }
            consumedBytes.addAndGet(bytesRead);
            bb = ByteBuffer.wrap(magicbuffer);
            magic = bb.getInt();
        }
        if (magic == INT_MAGIC) {
            SrpcMessage srpcMessage;
            bytesRead = SrpcMessage.readToBuffer(transmissionHeader, inputStream);
            if (bytesRead <= 0) {
                return null;
            }
            consumedBytes.addAndGet(bytesRead);
            bb = ByteBuffer.wrap(transmissionHeader);
            byte majorVersion = bb.get();
            byte minorVersion = bb.get();
            byte revisVersion = bb.get();
            byte[] version = new byte[]{majorVersion, minorVersion, revisVersion};
            byte encrypted = bb.get();
            byte compression = bb.get();
            int rawSrpcMessageSize = bb.getInt();
            buffer = new byte[rawSrpcMessageSize];
            long rawSrpcMessageReadStart = System.nanoTime();
            int rawSprcMessageBytesRead = SrpcMessage.readToBuffer(buffer, inputStream);
            if (rawSprcMessageBytesRead <= 0) {
                return null;
            }
            consumedBytes.addAndGet(rawSprcMessageBytesRead);
            if (logger.isDebugEnabled() && rawSrpcMessageSize > 0x100000) {
                logger.debug(String.format("Read [%,d bytes] in [%s ms]", rawSrpcMessageSize, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - rawSrpcMessageReadStart)));
            }
            if (encrypted > 0) {
                buffer = SrpcMessage.decrypt(buffer, encrypted);
            }
            boolean isHugeData = buffer.length > 0x8000000;
            try (SrpcDecompressor decompressor = new SrpcDecompressor();
                 InputStream decompressStream = decompressor.getDecompressedStream(buffer, compression > 0, isHugeData);){
                int tokenSize;
                if (isHugeData) {
                    System.gc();
                }
                int headerSize = Arrays.equals(version, VERSION3) ? 29 : 25;
                byte[] header = new byte[headerSize];
                decompressStream.read(header);
                bb = ByteBuffer.wrap(header);
                byte type = bb.get();
                long msb = bb.getLong();
                long lsb = bb.getLong();
                int error = bb.getInt();
                int hash = bb.getInt();
                String token = null;
                if (Arrays.equals(version, VERSION3) && (tokenSize = bb.getInt()) > 0) {
                    byte[] tokenBuffer = new byte[tokenSize];
                    decompressStream.read(tokenBuffer);
                    token = new String(tokenBuffer, StandardCharsets.UTF_8);
                }
                byte[] payloadSizeBuffer = new byte[4];
                decompressStream.read(payloadSizeBuffer);
                int size = Basic.byteArrayToInt4(payloadSizeBuffer);
                UUID uuid = new UUID(msb, lsb);
                GObject paramsGObject = null;
                if (size > 0) {
                    paramsGObject = GObject.fromBytes(decompressStream);
                }
                if (isHugeData) {
                    System.gc();
                }
                srpcMessage = new SrpcMessage(type, uuid, error, hash, paramsGObject, compression, encrypted, token);
                srpcMessage.setVersion(version);
            }
            long deserializeTimeNeeded = System.nanoTime() - startDeserialize;
            if (deserializeTimeNeeded > TimeUnit.SECONDS.toNanos(2L)) {
                logger.warn("Deserialization took " + TimeUnit.NANOSECONDS.toSeconds(deserializeTimeNeeded) + " secs: [" + srpcMessage + "] - Bytes consumed: [" + consumedBytes.get() + "]");
            }
            if (logger.isDebugEnabled() && srpcMessage.getPayload() != null) {
                logger.info(String.format("+++ Payload size [%s bytes] for [%s]", srpcMessage.getPayload().size(), srpcMessage.getMethodName()));
            }
            return srpcMessage;
        }
        logger.warn(String.format("%s -> Wrong magic! (%s) -> NEXT", inputStream.toString().substring(inputStream.toString().indexOf("@")), Integer.toHexString(magic)));
        logger.warn("Closing input stream to avoid wrong offset in upcoming SRPC messages.");
        inputStream.close();
        return null;
    }

    private void writeMessageHeader(ByteArrayOutputStream baos) throws IOException {
        ByteArrayOutputStream out = baos;
        out.write(MAGIC);
        out.write(this.version);
        if (!encryptionContext.isEnabled() && this.isEncrypted()) {
            if (!encryptionContext.refresh()) {
                this.setEncryption((byte)0);
            }
        } else {
            SrpcMessage.checkForRefresh(encryptionContext);
        }
        ((OutputStream)out).write(this.encryption);
        ((OutputStream)out).write(this.compression);
    }

    private void writeMessageParams(ByteArrayOutputStream baos) throws IOException {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        temp.write((byte)this.type);
        temp.write(ByteBuffer.allocate(8).putLong(this.messageId.getMostSignificantBits()).array());
        temp.write(ByteBuffer.allocate(8).putLong(this.messageId.getLeastSignificantBits()).array());
        temp.write(ByteBuffer.allocate(4).putInt(this.error).array());
        if (this.version[0] == 2) {
            temp.write(ByteBuffer.allocate(4).putInt(this.getHashMd5()).array());
        } else {
            temp.write(ByteBuffer.allocate(4).putInt(this.getHash()).array());
            temp.write(ByteBuffer.allocate(4).putInt(this.getToken() == null ? 0 : this.getToken().length()).array());
            if (this.getToken() != null && !this.getToken().isEmpty()) {
                temp.write(ByteBuffer.allocate(this.getToken().length()).put(this.getToken().getBytes(StandardCharsets.UTF_8)).array());
            }
        }
        if (null != this.getPayload()) {
            temp.write(ByteBuffer.allocate(4).putInt(this.getPayload().size()).array());
        } else {
            temp.write(ByteBuffer.allocate(4).putInt(0).array());
        }
        if (null != this.getPayload()) {
            this.getPayload().serialize(temp);
        }
        byte[] buffer = temp.toByteArray();
        if (this.isCompressed()) {
            buffer = this.compress(buffer);
        }
        if (this.isEncrypted()) {
            buffer = this.encrypt(buffer);
        }
        baos.write(ByteBuffer.allocate(4).putInt(buffer.length).array());
        baos.write(buffer);
    }

    private static int readToBuffer(byte[] buffer, InputStream inputStream) throws IOException, InterruptedException {
        if (null == buffer || null == inputStream) {
            throw new IllegalArgumentException(String.format("Argument was null: %s %s", buffer == null ? "buffer" : "", inputStream == null ? "stream" : ""));
        }
        int numberOfInputStreamReads = 0;
        long timeOfFirstRead = -1L;
        int numberOfBytesToReadLeft = buffer.length;
        do {
            int len;
            if ((len = inputStream.read(buffer, buffer.length - numberOfBytesToReadLeft, numberOfBytesToReadLeft)) < 0) {
                throw new IOException("Stream has been closed by peer.");
            }
            numberOfBytesToReadLeft -= len;
            if (numberOfInputStreamReads <= 0) {
                timeOfFirstRead = System.nanoTime();
            }
            ++numberOfInputStreamReads;
        } while (numberOfBytesToReadLeft > 0 && !Thread.currentThread().isInterrupted());
        long duration = (System.nanoTime() - timeOfFirstRead) / 1000000L;
        if (duration > 1000L) {
            logger.info("~~~ #reads=[" + numberOfInputStreamReads + "] buffer.length=[" + buffer.length + "] / soll=[" + numberOfBytesToReadLeft + "] lasts for [" + duration + " ms]");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while reading. (" + numberOfBytesToReadLeft + " bytes to go.)");
        }
        return buffer.length - numberOfBytesToReadLeft;
    }

    public GObject getPayload() {
        return this.payload;
    }

    protected void setPayload(GObject payload) {
        this.payload = payload;
    }

    private byte[] compress(byte[] uncompressed) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            zos.putNextEntry(new ZipEntry("SrpcMessage"));
            zos.write(uncompressed);
        }
        return baos.toByteArray();
    }

    private byte[] encrypt(byte[] clearText) {
        if (!encryptionContext.isEnabled()) {
            if (!encryptionContext.refresh()) {
                this.setEncryption((byte)0);
                return clearText;
            }
        } else {
            SrpcMessage.checkForRefresh(encryptionContext);
        }
        byte[] encrypted = null;
        try {
            encrypted = SrpcMessage.getEnCipher(this.encryption).doFinal(clearText);
        }
        catch (Throwable ex) {
            logger.error((Object)ex, ex);
        }
        return encrypted;
    }

    private static void checkForRefresh(EncryptionContext encryptionContext) {
        ENCRYPTION_CONTEXT_LOCK.lock();
        try {
            if (encryptionContext.getKey() != null && Crypto.getKeyData() != null && Crypto.getKeyData().getKey() != null && !Arrays.equals(encryptionContext.getKey(), Arrays.copyOfRange(Crypto.getKeyData().getKey(), 16, 32))) {
                encryptionContext.refresh();
            }
        }
        finally {
            ENCRYPTION_CONTEXT_LOCK.unlock();
        }
    }

    private static byte[] decrypt(byte[] ciphered, byte method) {
        if (!encryptionContext.isEnabled()) {
            if (!encryptionContext.refresh()) {
                return ciphered;
            }
        } else {
            SrpcMessage.checkForRefresh(encryptionContext);
        }
        if (ciphered.length % 16 > 0) {
            logger.error(String.format("Illegal Cipherlength: [%s] - EncryptionMethod [%s]", ciphered.length, method));
        }
        byte[] original = null;
        try {
            original = SrpcMessage.getDeCipher(method).doFinal(ciphered);
        }
        catch (IllegalBlockSizeException ex) {
            encryptionContext.refresh();
            if (logger.isDebugEnabled()) {
                logger.error((Object)ex, (Throwable)ex);
            }
            original = ciphered;
        }
        catch (BadPaddingException ex) {
            encryptionContext.refresh();
            logger.error((Object)ex, (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.error((Object)ex, ex);
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cipher getCipher(int mode, byte method) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        String algorhythm;
        IvParameterSpec ivParameterSpec = null;
        SecretKeySpec secretKeySpec = null;
        ENCRYPTION_CONTEXT_LOCK.lock();
        try {
            ivParameterSpec = new IvParameterSpec(encryptionContext.getIV());
            secretKeySpec = new SecretKeySpec(encryptionContext.getKey(), "AES");
        }
        finally {
            ENCRYPTION_CONTEXT_LOCK.unlock();
        }
        switch (method) {
            case 1: {
                algorhythm = "AES/CBC/PKCS5Padding";
                break;
            }
            default: {
                algorhythm = "AES/CBC/PKCS5Padding";
            }
        }
        Cipher cipher = Cipher.getInstance(algorhythm);
        cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    private static Cipher getDeCipher(byte method) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return SrpcMessage.getCipher(2, method);
    }

    private static Cipher getEnCipher(byte method) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return SrpcMessage.getCipher(1, method);
    }

    public String toString() {
        StringBuilder myString = new StringBuilder("SrpcMessage [");
        myString.append(SRPCType.toString(this.type)).append("] [");
        myString.append(this.getMethodName()).append("] ");
        myString.append("enc[").append(this.encryption).append("] ");
        myString.append("zip[").append(this.compression).append("] ");
        myString.append("err[").append(this.error).append("] ");
        myString.append("id[").append(this.messageId).append("] ");
        myString.append("payload[").append(String.format("%s", this.payload == null ? "none" : this.payload)).append("] ");
        return myString.toString();
    }

    public void setVersion(byte[] version) {
        this.version = version;
    }

    public byte[] getVersion() {
        return this.version;
    }
}

