/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpcDecompressor
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(SrpcDecompressor.class);
    private File tmpFile;

    public InputStream getDecompressedStream(byte[] buffer, boolean isCompressed, boolean isHugeCompressedData) throws IOException {
        if (isCompressed) {
            return this.decompress(buffer, isHugeCompressedData);
        }
        return new ByteArrayInputStream(buffer);
    }

    private InputStream decompress(byte[] compressed, boolean isHugeCompressedData) throws IOException {
        InputStream inputStream;
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(compressed));
        zis.getNextEntry();
        if (isHugeCompressedData) {
            this.tmpFile = File.createTempFile("cayugaSRPC_", ".bin");
            try (FileOutputStream outputStream = new FileOutputStream(this.tmpFile);){
                this.copyAndFlushStream(zis, outputStream);
                LOGGER.info("Wrote uncompressed SRPC message to " + this.tmpFile.getAbsolutePath());
            }
            inputStream = new FileInputStream(this.tmpFile);
        } else {
            this.tmpFile = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                this.copyAndFlushStream(zis, outputStream);
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            }
        }
        return inputStream;
    }

    private void copyAndFlushStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.flush();
    }

    @Override
    public void close() {
        if (this.tmpFile != null && this.tmpFile.exists() && !this.tmpFile.delete()) {
            LOGGER.warn("Can't delete temporary file for uncompressed SRPC message: " + this.tmpFile.getAbsolutePath());
        }
    }
}

