/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.crypto.Crypto;
import de.seetec.v5.shared.interaction.KeyDataObject;
import java.util.Arrays;

public class EncryptionContext {
    private byte[] iv;
    private byte[] key;
    private volatile boolean enabled = this.refresh();

    public final boolean refresh() {
        KeyDataObject kdo = Crypto.getKeyData();
        this.enabled = kdo.isEnabled();
        byte[] ivkey = kdo.getKey();
        if (null == ivkey) {
            this.enabled = false;
        } else {
            this.iv = Arrays.copyOf(ivkey, 16);
            this.key = Arrays.copyOfRange(ivkey, 16, 32);
        }
        return this.enabled;
    }

    public final byte[] getIV() {
        return this.iv;
    }

    public final byte[] getKey() {
        return this.key;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }
}

