/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc.general;

import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;

public class ReqTriggerAction
extends RequestWrapper {
    private final Long nServiceID;
    private final Long nActionID;
    private final Long nAlarmScriptID;
    private final Long nAlarmInstanceID;
    private final Long nAlarmTimerange;
    private final byte[] genericData;
    private final Long ptzPriority;
    private final Long ptzPriorityTimeout;

    public ReqTriggerAction(Long nServiceID, Long nActionID, Long nAlarmScriptID, Long nAlarmInstanceID, Long nAlarmTimerange, byte[] genericData, Long ptzPriority, Long ptzPriorityTimeout) {
        this.nServiceID = nServiceID;
        this.nActionID = nActionID;
        this.nAlarmScriptID = nAlarmScriptID;
        this.nAlarmInstanceID = nAlarmInstanceID;
        this.nAlarmTimerange = nAlarmTimerange;
        this.genericData = genericData;
        this.ptzPriority = ptzPriority;
        this.ptzPriorityTimeout = ptzPriorityTimeout;
    }

    @Override
    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.nServiceID);
        goResponse.addChild(this.nActionID);
        goResponse.addChild(this.nAlarmScriptID);
        goResponse.addChild(this.nAlarmInstanceID);
        goResponse.addChild(this.nAlarmTimerange);
        goResponse.addChild(this.genericData);
        goResponse.addChild(this.ptzPriority);
        goResponse.addChild(this.ptzPriorityTimeout);
        return goResponse;
    }

    public static ReqTriggerAction parseGObject(GObject goRequest) {
        int nPos = -1;
        Long nServiceID = goRequest.getChildAt(++nPos).getAsLong();
        Long nActionID = goRequest.getChildAt(++nPos).getAsLong();
        Long nAlarmScriptID = goRequest.getChildAt(++nPos).getAsLong();
        Long nAlarmInstanceID = goRequest.getChildAt(++nPos).getAsLong();
        Long nAlarmTimerange = goRequest.getChildAt(++nPos).getAsLong();
        byte[] data = null;
        try {
            data = goRequest.getChildAt(++nPos).getAsArrayOfByte();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Long ptzPriority = null;
        try {
            ptzPriority = goRequest.getChildAt(++nPos).getAsLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Long ptzPriorityTimeout = null;
        try {
            ptzPriorityTimeout = goRequest.getChildAt(++nPos).getAsLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ReqTriggerAction(nServiceID, nActionID, nAlarmScriptID, nAlarmInstanceID, nAlarmTimerange, data, ptzPriority, ptzPriorityTimeout);
    }

    public Long getServiceID() {
        return this.nServiceID;
    }

    public Long getActionID() {
        return this.nActionID;
    }

    public Long getAlarmScriptID() {
        return this.nAlarmScriptID;
    }

    public Long getAlarmInstanceID() {
        return this.nAlarmInstanceID;
    }

    public Long getAlarmTimerange() {
        return this.nAlarmTimerange;
    }

    public byte[] getGenericData() {
        return this.genericData;
    }

    public Long getPTZPriority() {
        return this.ptzPriority;
    }

    public Long getPTZPriorityTimeout() {
        return this.ptzPriorityTimeout;
    }

    public String toString() {
        String sThis = Methods.ENT_FUNCTION_TRIGGER_ACTION.methodName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", ServiceID=[" + this.nServiceID + "], ActionID=[" + this.nActionID + "], AlarmScriptID=[" + this.nAlarmScriptID + "], AlarmInstanceID=[" + this.nAlarmInstanceID + "], AlarmTimerange=[" + this.nAlarmTimerange + "], GenericData=[" + (this.genericData != null ? "not null" : "null") + "]]";
    }
}

