/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

public enum HTTPStatusCode {
    HTTP_CONTINUE(100),
    HTTP_SWITCHING_PROTOCOLS(101),
    HTTP_PROCESSING(102),
    HTTP_OK(200),
    HTTP_CREATED(201),
    HTTP_ACCEPTED(202),
    HTTP_NON_AUTHORITATIVE_INFORMATION(203),
    HTTP_NO_CONTENT(204),
    HTTP_RESET_CONTENT(205),
    HTTP_PARTIAL_CONTENT(206),
    HTTP_MULTI_STATUS(207),
    HTTP_ALREADY_REPORTED(208),
    HTTP_IM_USED(226),
    HTTP_MULTIPLE_CHOICES(300),
    HTTP_MOVED_PERMANENTLY(301),
    HTTP_FOUND(302),
    HTTP_SEE_OTHER(303),
    HTTP_NOT_MODIFIED(304),
    HTTP_USE_PROXY(305),
    HTTP_TEMPORARY_REDIRECT(307),
    HTTP_PERMANENT_REDIRECT(308),
    HTTP_BAD_REQUEST(400),
    HTTP_UNAUTHORIZED(401),
    HTTP_PAYMENT_REQUIRED(402),
    HTTP_FORBIDDEN(403),
    HTTP_NOT_FOUND(404),
    HTTP_METHOD_NOT_ALLOWED(405),
    HTTP_NOT_ACCEPTABLE(406),
    HTTP_PROXY_AUTHENTICATION_REQUIRED(407),
    HTTP_REQUEST_TIME_OUT(408),
    HTTP_CONFLICT(409),
    HTTP_GONE(410),
    HTTP_LENGTH_REQUIRED(411),
    HTTP_PRECONDITION_FAILED(412),
    HTTP_REQUEST_ENTITY_TOO_LARGE(413),
    HTTP_REQUEST_URL_TOO_LONG(414),
    HTTP_UNSUPPORTED_MEDIA_TYPE(415),
    HTTP_REQUESTED_RANGE_NOT_SATISFIABLE(416),
    HTTP_EXPECTATION_FAILED(417),
    HTTP_POLICY_NOT_FULFILLED(420),
    HTTP_UNPROCESSABLE_ENTITY(422),
    HTTP_LOCKED(423),
    HTTP_FAILED_DEPENDENCY(424),
    HTTP_UPGRADE_REQUIRED(426),
    HTTP_TOO_MANY_REQUESTS(429),
    HTTP_ACCOUNT_BLOCKED(490),
    HTTP_INTERNAL_SERVER_ERROR(500),
    HTTP_NOT_IMPLEMENTED(501),
    HTTP_BAD_GATEWAY(502),
    HTTP_SERVICE_UNAVAILABLE(503),
    HTTP_GATEWAY_TIME_OUT(504),
    HTTP_HTTP_VERSION_NOT_SUPPORTED(505),
    HTTP_VARIANT_ALSO_NEGOTIATES(506),
    HTTP_INSUFFICIENT_STORAGE(507),
    HTTP_BANDWIDTH_LIMIT_EXCEEDED(509),
    HTTP_NOT_EXTENDED(510);

    private int statusCode;

    private HTTPStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static HTTPStatusCode valueOf(int givenStatusCode) {
        HTTPStatusCode statusCode = null;
        for (HTTPStatusCode t : HTTPStatusCode.values()) {
            if (givenStatusCode != t.statusCode) continue;
            statusCode = t;
            break;
        }
        return statusCode;
    }

    public String toString() {
        return "HTTP Statuscode: " + this.getStatusCode() + ", Name: " + this.name();
    }
}

