/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.logging;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.DefaultSystemPropertyProvider;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemPropertyProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.configuration.eventing.EventNotificationDetail;
import de.seetec.v5.shared.configuration.eventing.Eventing;
import de.seetec.v5.shared.logging.FloodingMgr;
import de.seetec.v5.shared.util.SeeTecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.dblock.log4jna.nt.Win32EventLogAppender;

public class WindowsLoggingMgr {
    private final boolean isWindows;
    private final Logger logger;
    private final FloodingMgr floodingMgr;
    private final SystemTimeProvider systemTimeProvider;
    private Logger loggerSystemLog = null;
    private String source = null;
    private Eventing eventing = null;

    public WindowsLoggingMgr() throws SeeTecException {
        this(new DefaultSystemPropertyProvider(), new DefaultSystemTimeProvider());
    }

    protected WindowsLoggingMgr(SystemPropertyProvider systemPropertyProvider, SystemTimeProvider systemTimeProvider) throws SeeTecException {
        if (systemPropertyProvider == null || (this.systemTimeProvider = systemTimeProvider) == null) {
            throw new SeeTecException(-20002, "Argument to start WindowsLoggingMgr is null");
        }
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.floodingMgr = new FloodingMgr(systemTimeProvider);
        String os = systemPropertyProvider.getProperty("os.name");
        this.isWindows = os != null && os.startsWith("Windows");
    }

    public void init(String source, byte[] configuration) throws SeeTecException {
        this.source = source;
        if (this.source == null || configuration == null) {
            throw new SeeTecException(-20002, "Argument for initializing WindowsLoggingMgr is null.");
        }
        this.initialize(configuration);
    }

    private void initialize(byte[] configuration) throws SeeTecException {
        try {
            this.eventing = Basic.unmarshalXML(Eventing.class, configuration, true);
            if (this.isWindows) {
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                if (loggerContext.getConfiguration().getLoggerConfig("ntevent") == null) {
                    throw new SeeTecException(-20041, "No NTSystemLog logger specified in log4j config file.");
                }
                String appenderMessageFile = System.getenv("WINDIR") + "\\system32\\NTEventLogAppender.dll";
                PatternLayout layout = PatternLayout.newBuilder().withPattern("%m%n").build();
                Win32EventLogAppender appender = Win32EventLogAppender.createAppender((String)"Win32EventLog", null, (String)this.source, null, (String)appenderMessageFile, (String)appenderMessageFile, (Layout)layout, null);
                appender.start();
                this.loggerSystemLog = loggerContext.getLogger("ntevent");
                ((org.apache.logging.log4j.core.Logger)this.loggerSystemLog).addAppender((Appender)appender);
            } else {
                this.logger.info("Non-Windows system detected. NTSystemLogger not available.");
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError noClassDefFoundError) {
            throw new SeeTecException(-20043, "File 'NTEventLogAppender.dll' not found in system path.");
        }
        catch (Throwable t) {
            throw new SeeTecException(-20000, "Error while initialization: " + t.getMessage() + ".");
        }
    }

    private long getDeadtime(long eventType) {
        for (EventNotificationDetail detail : this.eventing.getEventNotification().getEventNotifications().getEventNotificationDetail()) {
            if (detail.getEventType() != eventType) continue;
            return detail.getDeadTime();
        }
        this.logger.warn("No event property found for type " + eventType + ". Using 0.");
        return 0L;
    }

    public int sendLog(int errorCode, long etyid, long eventType, Level level, String message) {
        return this.sendLog(errorCode, etyid, eventType, level, message, true);
    }

    public int sendLog(int errorCode, long etyid, long eventType, Level level, String message, boolean checkFlooding) {
        if (level == null || message == null) {
            return -20002;
        }
        try {
            this.checkLevel(level);
            int floodingStatus = 0;
            long deadtime = this.getDeadtime(eventType);
            if (checkFlooding && (floodingStatus = this.floodingMgr.checkFlooding(errorCode, etyid, deadtime)) != 0) {
                this.logger.info("No windows event log will be written. FLOOD PROTECTION for Entity/Error: " + etyid + "/" + errorCode + ". DeadTime: " + deadtime);
                return floodingStatus;
            }
            String outputMessage = (this.eventing.getNotificationPrefix() == null ? "" : this.eventing.getNotificationPrefix()) + " / [" + new SimpleDateFormat("HH:mm:ss").format(new Date(this.systemTimeProvider.currentTimeMillis())) + "]:" + message;
            if (this.loggerSystemLog != null && level != Level.OFF) {
                this.loggerSystemLog.log(level, outputMessage);
            }
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Error while sending log: " + t.getMessage(), t);
            return -20000;
        }
    }

    public String toString() {
        return "WindowsLoggingMgr";
    }

    public void shutdown() {
        this.floodingMgr.clear();
    }

    private void checkLevel(Level level) throws SeeTecException {
        if (level == Level.ALL || level == Level.DEBUG || level == Level.TRACE) {
            throw new SeeTecException(-20002, "Invalid level specified.");
        }
    }
}

