/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.interaction;

import de.seetec.v5.shared.interaction.DataObject;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.nio.charset.StandardCharsets;

public class KeyDataObject
extends DataObject {
    private static final long serialVersionUID = -2715413730717454647L;
    private boolean isEnabled = false;
    private String method = null;
    private byte[] key = null;
    private byte[] singleSignOnToken;

    public KeyDataObject(boolean isEnabled, String method, byte[] key) {
        this(method, key);
        this.isEnabled = isEnabled;
    }

    public KeyDataObject(String method, byte[] key, byte[] singleSignOnToken) {
        this(method, key);
        this.singleSignOnToken = singleSignOnToken;
    }

    public KeyDataObject(String method, byte[] key) {
        this.method = method;
        this.key = key;
    }

    public static KeyDataObject parseResponse(GObject goResponse) {
        String method = goResponse.getChildAt(0).getAsString();
        byte[] key = goResponse.getChildAt(1).getAsArrayOfByte();
        String cayugaToken = new String(goResponse.getChildAt(2).getAsArrayOfByte(), StandardCharsets.UTF_8);
        KeyDataObject keyDataObject = new KeyDataObject(method, key, null);
        keyDataObject.setToken(cayugaToken);
        return keyDataObject;
    }

    public byte[] getKey() {
        return this.key;
    }

    public String getEncryptionMethod() {
        return this.method;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public byte[] getSingleSignOnToken() {
        return this.singleSignOnToken;
    }
}

