/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.interaction;

import de.seetec.v5.shared.interaction.TreeNodeDataObject;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.SrpcDataType;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.sql.ResultSet;
import java.util.Arrays;

public class EntityDataObject
extends TreeNodeDataObject {
    private static final long serialVersionUID = 7219362840446066865L;
    private String name = null;
    private long type = Long.MIN_VALUE;
    private long mediaId = Long.MIN_VALUE;
    private byte[] configuration = null;
    private String description = null;
    private boolean active = true;
    private int status = Integer.MIN_VALUE;
    private boolean extent = false;
    private transient Socket socket = null;
    private long serverTime = Long.MIN_VALUE;
    private long physicalParent = Long.MIN_VALUE;
    private long physicalOrder = Long.MIN_VALUE;
    private long logicalParent = Long.MIN_VALUE;
    private long logicalOrder = Long.MIN_VALUE;
    private boolean firedByBulkCommand = false;

    public EntityDataObject() {
    }

    public EntityDataObject(int code) {
        super(code);
    }

    public EntityDataObject(long id, String name, long type) {
        super(id);
        this.name = name;
        this.type = type;
    }

    public EntityDataObject(long id, String name, long type, long serverTime, boolean extent) {
        this(id, name, type);
        this.serverTime = serverTime;
        this.extent = extent;
    }

    public EntityDataObject(long id, int status) {
        super(id);
        this.status = status;
    }

    public EntityDataObject(long id) {
        super(id);
    }

    public EntityDataObject(long id, String name, long type, long mediaId, boolean active, byte[] configuration, Socket socket) {
        super(id);
        this.name = name;
        this.type = type;
        this.mediaId = mediaId;
        this.active = active;
        this.configuration = configuration;
        this.socket = socket;
    }

    public EntityDataObject(long id, String name, long type, long mediaId, boolean active, byte[] configuration, String description, Socket socket, long physicalParent, long physicalOrder, long logicalParent, long logicalOrder) {
        this(id, name, type, mediaId, active, configuration, socket);
        this.description = description;
        this.physicalParent = physicalParent;
        this.physicalOrder = physicalOrder;
        this.logicalParent = logicalParent;
        this.logicalOrder = logicalOrder;
    }

    public static EntityDataObject parseResultSet(ResultSet resultSet, boolean isExtentRequested, boolean isReadWithoutDescription) throws SeeTecException {
        try {
            EntityDataObject result = new EntityDataObject(resultSet.getLong(1), resultSet.getString(2), resultSet.getLong(3));
            long tmpMediaId = resultSet.getLong(4);
            result.setMediaID(resultSet.wasNull() ? Long.MIN_VALUE : tmpMediaId);
            result.setActive(resultSet.getBoolean(5));
            result.setStatus(resultSet.getInt(6));
            if (isExtentRequested) {
                result.setConfiguration(resultSet.getBytes(7));
            }
            long tmp = resultSet.getLong(8);
            if (!resultSet.wasNull()) {
                result.setPhysicalParent(tmp);
            }
            tmp = resultSet.getLong(9);
            if (!resultSet.wasNull()) {
                result.setPhysicalOrder(tmp);
            }
            tmp = resultSet.getLong(10);
            if (!resultSet.wasNull()) {
                result.setLogicalParent(tmp);
            }
            tmp = resultSet.getLong(11);
            if (!resultSet.wasNull()) {
                result.setLogicalOrder(tmp);
            }
            if (!isReadWithoutDescription) {
                result.setDescription(resultSet.getString(12));
            }
            return result;
        }
        catch (Exception exception) {
            throw new SeeTecException(-20000, "ResultSet has not expected content.");
        }
    }

    public GObject createGObject() {
        GObject singleEntity = GObject.createList();
        singleEntity.addChild(this.getID());
        singleEntity.addChild(this.getName());
        singleEntity.addChild(this.getType());
        singleEntity.addChild(this.evaluateLongValue(this.getMediaID()));
        singleEntity.addChild(this.getActive());
        singleEntity.addChild(this.getStatus());
        singleEntity.addChild(this.getConfiguration());
        singleEntity.addChild(this.evaluateLongValue(this.getPhysicalParent()));
        singleEntity.addChild(this.evaluateLongValue(this.getPhysicalOrder()));
        singleEntity.addChild(this.evaluateLongValue(this.getLogicalParent()));
        singleEntity.addChild(this.evaluateLongValue(this.getLogicalOrder()));
        singleEntity.addChild(this.getDescription());
        return singleEntity;
    }

    public GObject createGObjectWithoutTreeInformation() {
        GObject singleEntity = GObject.createList();
        singleEntity.addChild(this.getID());
        singleEntity.addChild(this.getName());
        singleEntity.addChild(this.getType());
        singleEntity.addChild(this.evaluateLongValue(this.getMediaID()));
        singleEntity.addChild(this.getActive());
        singleEntity.addChild(this.getStatus());
        singleEntity.addChild(this.getConfiguration());
        singleEntity.addChild(this.getDescription());
        return singleEntity;
    }

    public GObject createGObjectWithoutStatusInformation() {
        GObject singleEntity = GObject.createList();
        singleEntity.addChild(this.getID());
        singleEntity.addChild(this.getName());
        singleEntity.addChild(this.getType());
        singleEntity.addChild(this.evaluateLongValue(this.getMediaID()));
        singleEntity.addChild(this.getActive());
        singleEntity.addChild(this.getConfiguration());
        singleEntity.addChild(this.evaluateLongValue(this.getPhysicalParent()));
        singleEntity.addChild(this.evaluateLongValue(this.getPhysicalOrder()));
        singleEntity.addChild(this.evaluateLongValue(this.getLogicalParent()));
        singleEntity.addChild(this.evaluateLongValue(this.getLogicalOrder()));
        singleEntity.addChild(this.getDescription());
        return singleEntity;
    }

    private GObject evaluateLongValue(long value) {
        return value != Long.MIN_VALUE ? GObject.create(value) : GObject.createNull(SrpcDataType.INT8);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(long type) {
        this.type = type;
    }

    public long getType() {
        return this.type;
    }

    public void setMediaID(long mediaId) {
        this.mediaId = mediaId;
    }

    public long getMediaID() {
        return this.mediaId;
    }

    public void setConfiguration(byte[] configuration) {
        this.configuration = configuration;
    }

    public byte[] getConfiguration() {
        return this.configuration;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean getExtent() {
        return this.extent;
    }

    public void setExtent(boolean extent) {
        this.extent = extent;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public long getServerTime() {
        return this.serverTime;
    }

    public long getPhysicalParent() {
        return this.physicalParent;
    }

    public void setPhysicalParent(long physicalParent) {
        this.physicalParent = physicalParent;
    }

    public long getPhysicalOrder() {
        return this.physicalOrder;
    }

    public void setPhysicalOrder(long physicalOrder) {
        this.physicalOrder = physicalOrder;
    }

    public long getLogicalParent() {
        return this.logicalParent;
    }

    public void setLogicalParent(long logicalParent) {
        this.logicalParent = logicalParent;
    }

    public long getLogicalOrder() {
        return this.logicalOrder;
    }

    public void setLogicalOrder(long logicalOrder) {
        this.logicalOrder = logicalOrder;
    }

    public boolean isLicenseRelevantChange(EntityDataObject previousVersion) throws IllegalArgumentException {
        if (previousVersion == null || previousVersion.getID() != this.getID()) {
            throw new IllegalArgumentException();
        }
        return previousVersion.getType() != this.getType() || !previousVersion.getActive() && this.getActive() || !Arrays.equals(previousVersion.getConfiguration(), this.getConfiguration());
    }

    public boolean isFiredByBulkCommand() {
        return this.firedByBulkCommand;
    }

    public void setFiredByBulkCommand(boolean firedByBulkCommand) {
        this.firedByBulkCommand = firedByBulkCommand;
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare != null && objectToCompare instanceof EntityDataObject) {
            return this.hashCode() == objectToCompare.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 61 * hash + (int)(this.type ^ this.type >>> 32);
        hash = 61 * hash + (int)(this.mediaId ^ this.mediaId >>> 32);
        hash = 61 * hash + Arrays.hashCode(this.configuration);
        hash = 61 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 61 * hash + (this.active ? 1 : 0);
        hash = 61 * hash + this.status;
        hash = 61 * hash + (this.extent ? 1 : 0);
        hash = 61 * hash + (this.socket != null ? this.socket.hashCode() : 0);
        hash = 61 * hash + (int)(this.serverTime ^ this.serverTime >>> 32);
        hash = 61 * hash + (int)(this.physicalParent ^ this.physicalParent >>> 32);
        hash = 61 * hash + (int)(this.physicalOrder ^ this.physicalOrder >>> 32);
        hash = 61 * hash + (int)(this.logicalParent ^ this.logicalParent >>> 32);
        hash = 61 * hash + (int)(this.logicalOrder ^ this.logicalOrder >>> 32);
        hash = 61 * hash + (this.token != null ? this.token.hashCode() : 0);
        return hash;
    }

    public void serializeEntityToFile(String baseDir) throws IOException {
        if (baseDir != null) {
            FileOutputStream file = new FileOutputStream(baseDir + "\\" + this.getName() + ".ser");
            BufferedOutputStream buffer = new BufferedOutputStream(file);
            try (ObjectOutputStream output = new ObjectOutputStream(buffer);){
                output.writeObject(this);
            }
        }
    }

    public String toStringShortest() {
        return String.format("ID: %s, Name: %s", this.getID(), this.name);
    }

    public String toStringShort() {
        return String.format("%s, Type: %s", this.toStringShortest(), this.type);
    }

    @Override
    public String toString() {
        return String.format("ID: %s, Name: %s, Type: %s, MID: %s, Active: %s, PhysicalParent/-Order: %s/%s, LogicalParent/-Order: %s/%s, DataObject: %s", this.getID(), this.name, this.type, this.mediaId, this.active, this.physicalParent, this.physicalOrder, this.logicalParent, this.logicalOrder, super.toString());
    }
}

