/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

public enum EventType {
    ENT_EVENTTYPE_CORE_STARTED(100L, true, "Core started"),
    ENT_EVENTTYPE_MAIN_UNREACHABLE(101L, "Main unreachable"),
    ENT_EVENTTYPE_ENTITY_CHANGED(102L, "Entity changed"),
    ENT_EVENTTYPE_SUB_UNREACHABLE(103L, "Sub unreachable"),
    ENT_EVENTTYPE_SUB_REACHABLE_AGAIN(104L, "Sub reachable again"),
    ENT_EVENTTYPE_ENTITY_DELETED(105L, "Entity deleted"),
    ENT_EVENTTYPE_ENTITY_DEREGISTERED(106L, true, "Entity deregistered"),
    ENT_EVENTTYPE_ENTITY_SET(107L, true, "Entity set"),
    ENT_EVENTTYPE_ENTITY_REGISTERED(108L, true, "Entity registered"),
    ENT_EVENTTYPE_STATUS_CHANGED(109L, true, "Status changed"),
    ENT_EVENTTYPE_BLOB_ADDED(110L, true, "Blob added"),
    ENT_EVENTTYPE_BLOB_REMOVED(111L, true, "Blob removed"),
    ENT_EVENTTYPE_DEFINITIONS_CHANGED(112L, true, "Definitions changed"),
    ENT_EVENTTYPE_BULK_OPERATION_EXECUTED(113L, true, "Bulk operation executed"),
    ENT_EVENTTYPE_REARRANGE_CHILDREN(114L, true, "Children rearranged"),
    ENT_EVENTTYPE_START_AD_SYNC(115L, true, "Start Active Directory Sync"),
    ENT_EVENTTYPE_BACKUP_FOLDER_UNUSABLE(116L, true, "Given backup folder cannot be used"),
    ENT_EVENTTYPE_DBLOAD_WARNING(120L, "DBLoad warning"),
    ENT_EVENTTYPE_DBLOAD_EMERGENCY_SHUTDOWN(121L, "DB emergency shutdown"),
    ENT_EVENTTYPE_CANNOT_WRITE_SUMMARY_FILE(122L, "Cannot write summary file"),
    ENT_EVENTTYPE_CANNOT_WRITE_ALARM_FILE(123L, "Cannot write alarm file"),
    ENT_EVENTTYPE_CYCLIC_BACKUP_FAILED(130L, "Backup failed"),
    ENT_EVENTTYPE_RE_INVALID_STATUS(140L, "RE invalid status"),
    ENT_EVENTTYPE_LICENCE_CHANGE_SUCCESSFUL(151L, "License change successfull"),
    ENT_EVENTTYPE_LICENCE_CHANGE_UNSUCCESSFUL(152L, "License change unsuccessfull"),
    ENT_EVENTTYPE_SEND_TEST_TRAP(153L, true, "SendTestTrap"),
    ENT_EVENTTYPE_SEND_TEST_MAIL(154L, true, "SendTestMail"),
    ENT_EVENTTYPE_START_PATROL(160L, true, "Start patrol"),
    ENT_EVENTTYPE_STOP_PATROL(161L, true, "Stop patrol"),
    ENT_EVENTTYPE_ENTITY_SHARING_CREATED(162L, "Entity sharing created"),
    ENT_EVENTTYPE_ENTITY_SHARING_EDITED(163L, "Entity sharing edited"),
    ENT_EVENTTYPE_ENTITY_SHARING_DELETED(164L, "Entity sharing deleted"),
    ENT_EVENTTYPE_ENTITY_SHARING_CHANGED(165L, true, "Entity sharing changed"),
    ENT_EVENTTYPE_ENTITY_RESTRICTION_CHANGED(166L, true, "Entity restriction changed"),
    ENT_EVENTTYPE_ENTITY_RESTRICTION_CREATED(167L, "Entity restriction created"),
    ENT_EVENTTYPE_ENTITY_RESTRICTION_EDITED(168L, "Entity restriction edited"),
    ENT_EVENTTYPE_ENTITY_RESTRICTION_DELETED(169L, "Entity restriction deleted"),
    ENT_EVENTTYPE_VIDEOSOURCE_DELETED(170L, "Video source deleted"),
    ENT_EVENTTYPE_VIDEOSOURCE_CONFIGURED(171L, "Video source configured"),
    ENT_EVENTTYPE_EVENT_STORAGE_CHANGED(172L, "Event storage changed"),
    ENT_EVENTTYPE_EVENT_STORAGE_DELETED(173L, "Event storage deleted"),
    ENT_EVENTTYPE_REPORT_MODE_ENTITY_ADDED(174L, "ReportMode entity added"),
    ENT_EVENTTYPE_REPORT_MODE_ENTITY_CONFIGURED(175L, "ReportMode entity configured"),
    ENT_EVENTTYPE_REPORT_MODE_ENTITY_DELETED(176L, "ReportMode entity deleted"),
    ENT_EVENTTYPE_SYNC_FINISHED(180L, true, "Sync finished"),
    ENT_EVENTTYPE_LPR_MASTER_DATA_CHANGED(192L, true, "Master data changed"),
    ENT_EVENTTYPE_LPR_RECOGNITION_EVENT(193L, true, "LPR recognition"),
    ENT_EVENTTYPE_PERSONAL_LAYER_CHANGED(196L, true, "Personal layer changed"),
    AUTH_EVENTTYPE_PASSWORD_CHANGED(209L, true, "Password changed"),
    USER_CONFIGURED(216L, "User configured"),
    GROUP_CONFIGURED(217L, "Group configured"),
    LOGISTIC_EVENTTYPE_MODULE_ERROR(301L, true, "Logistics module error"),
    LOGISTIC_EVENTTYPE_CONNECTOR_ERROR(302L, true, "Logistics connector error"),
    LOGISTIC_EVENTTYPE_CONNECTION_ERROR(303L, true, "Logistics connection error"),
    ALARM_EVENTTYPE_ALARMSCENARIO_TRIGGERED(401L, "AS triggered"),
    ALARM_EVENTTYPE_ALARMSCENARIO_RETRIGGERED(402L, true, "AS retriggered"),
    ALARM_EVENTTYPE_ALARMSCENARIO_STOPPED(403L, true, "AS stopped"),
    EVENTTYPE_TRIGGER(50L, true, "Trigger"),
    EVENTTYPE_3RD_PARTY_TRIGGER(51L, true, "3rd Trigger"),
    EVENTTYPE_3RD_PARTY_STOP_TRIGGER(52L, true, "3rd StopTrigger"),
    EVENTTYPE_TRIGGER_LPR(53L, true, "LPR Trigger"),
    EVENTTYPE_TRIGGER_PREB(54L, true, "PREB Trigger"),
    CLIENT_EVENTTYPE_ALARMSCENARIO_CONFIRMED(601L, "AS confirmed"),
    CLIENT_EVENTTYPE_ALARMSCENARIO_REJECTED(602L, "AS rejected"),
    CLIENT_EVENTTYPE_ALARMSCENARIO_DEFERRED(603L, "AS deferred"),
    CLIENT_EVENTTYPE_ALARMSCENARIO_CLASSIFIED(604L, "AS classified"),
    CLIENT_EVENTTYPE_BUTTON_PRESSED(605L, "Button pressed"),
    CLIENT_EVENTTYPE_MODE_CHANGED(606L, "Mode changed"),
    CLIENT_EVENTTYPE_PATROL_STARTED(607L, "Patrol started"),
    CLIENT_EVENTTYPE_PATROL_PAUSED(608L, "Patrol paused"),
    CLIENT_EVENTTYPE_PATROL_STOPPED(609L, "Patrol stopped"),
    CLIENT_EVENTTYPE_LOGGED_ON(610L, "Logged on"),
    CLIENT_EVENTTYPE_LOGGED_OFF(611L, "Logged off"),
    CLIENT_EVENTTYPE_ALARM_LOCAL_CONFIRMED(612L, true, "Client-internal"),
    CLIENT_EVENTTYPE_ALARM_RECORDING(613L, "Alarm rec start/stop by user"),
    CLIENT_EVENTTYPE_USER_EXPORT_SINGLE_IMAGE(614L, "User export single image"),
    CLIENT_EVENTTYPE_USER_EXPORT_SEQUENCE(615L, "User export seq"),
    CLIENT_EVENTTYPE_COMMENT(616L, "Comment"),
    CLIENT_EVENTTYPE_LPR_CHANGED(617L, true, "User changed master data"),
    CLIENT_EVENTTYPE_PATROL_CONTROL_POINT(618L, "Patrol control point"),
    CLIENT_IMAGES_DELETED(619L, "User deleted image seq"),
    CLIENT_COUNTING_TEMPLATE_CHANGED(620L, true, "User changed counting template"),
    FAILED_LOGIN_ATTEMPT(622L, "Login failed"),
    USER_DEACTIVATED_AFTER_FAILED_LOGIN_ATTEMPT(623L, "User deactivated after too many failed login attempts"),
    SINGLE_EVENT_DELETED(624L, "Single event deleted"),
    MDB_EVENTTYPE_RECORDING_START(701L, true, "Rec start"),
    MDB_EVENTTYPE_RECORDING_STOP(702L, true, "Rec stop"),
    MDB_EVENTTYPE_ALARM_RECORDING_START(703L, true, "Alarm rec start"),
    MDB_EVENTTYPE_ALARM_RECORDING_STOP(704L, true, "Alarm rec stop"),
    MDB_EVENTTYPE_STORAGE_OVERFLOW(705L, "Storage overflow"),
    MDB_EVENTTYPE_CANNOT_MOUNT_ZONE(706L, "Cannot mount zone"),
    MDB_EVENTTYPE_NO_MORE_ZONE_SPACE(707L, "No more zone space"),
    MDB_EVENTTYPE_CANNOT_START_MDS(708L, "Cannot start MDS"),
    MDB_EVENTTYPE_WRITE_ACCESS_DELAYED(709L, true, "Write access delayed"),
    MDB_EVENTTYPE_ARCHIVE_START(710L, "Archive start"),
    MDB_EVENTTYPE_ARCHIVE_STOP(711L, "Archive stop"),
    MDB_EVENTTYPE_AUTOMATED_EXPORT(712L, "Auto export"),
    MDB_EVENTTYPE_ZONE_ALMOST_FULL(713L, true, "Zone almost full"),
    MDB_EVENTTYPE_EDGE_STORAGE_RECORDING_FETCHED(714L, "Edge storage rec fetched"),
    MDB_EVENTTYPE_LAST_FULL_FRAME_IS_TOO_OLD(715L, true, "Last full frame too old"),
    MDB_EVENTTYPE_LIVE_START(716L, true, "Live start"),
    MDB_EVENTTYPE_LIVE_STOP(717L, true, "Live stop"),
    MDB_EVENTTYPE_ARCHIVE_OPERATION(718L, "Archive operation"),
    MDB_EVENTTYPE_STATISTICS_LIMITED_STATUS(719L, "Threshold exceeded"),
    MDB_EVENTTYPE_STATISTICS_ERROR_STATUS(720L, "Device statistics unavailable"),
    MDB_EVENTTYPE_BACKUP_STARTED(721L, "MDB video backup started"),
    MDB_EVENTTYPE_BACKUP_INTERRUPTED(722L, "MDB video backup interrupted"),
    MDB_EVENTTYPE_BACKUP_COMPLETED(723L, "MDB video backup completed"),
    GENERAL_EVENTTYPE_SERVERTIME_CHANGED(803L, "Server time changed"),
    GENERAL_EVENTTYPE_LOGGING(806L, "Logging"),
    GENERAL_EVENTTYPE_LOGGING_TOOK_ACTION(808L, "Logging took action"),
    GENERAL_EVENTTYPE_DONGLE_MISSING(809L, "Dongle missing"),
    GENERAL_EVENTTYPE_HIGH_LEVEL_MAIL(810L, true, "Mail"),
    GENERAL_EVENTTYPE_VCA_BAD_SIGNAL(811L, "VCA bad signal"),
    GENERAL_EVENTTYPE_VCA_VIEW_UNKNOWN(812L, "VCA view unknown"),
    GENERAL_EVENTTYPE_VCA_VIEW_RESTORED(813L, "VCA view restored"),
    GENERAL_EVENTTYPE_VCA_VIDEO_LOST(814L, "VCA video loss"),
    GENERAL_EVENTTYPE_VCA_VIDEO_GAIN(815L, "VCA video gain"),
    GENERAL_EVENTTYPE_VA_3RDParty_COMMUNICATION_LOST(816L, "VA 3rdParty Communication loss"),
    GENERAL_EVENTTYPE_VA_3RDParty_COMMUNICATION_GAIN(817L, "VA 3rdParty Communication gain"),
    GENERAL_EVENTTYPE_VA_BODY_WORN_OFFLOAD_UNSUCCESSFUL(818L, "Body worn offload unsuccessful"),
    GENERAL_EVENTTYPE_VA_BODY_WORN_CERTIFICATE_EXPIRATION(819L, "Body worn certificate expiration"),
    GENERAL_EVENTTYPE_OPC_TO(820L, true, "to OPC"),
    GENERAL_EVENTTYPE_OPC_FROM(821L, true, "from OPC"),
    GENERAL_EVENTTYPE_SEND_SMNP(822L, true, "SNMP"),
    CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM_SOLVED(823L, "Device connectivity problem resolved"),
    CM_EVENTTYPE_CANNOT_START_CM(901L, "Cannot start DM"),
    CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM(902L, "Device connectivity problem"),
    CM_EVENTTYPE_RE_STARTED_LEGACY(904L, true, "RE started"),
    CM_EVENTTYPE_VIDEO_LOSS(905L, "Video loss"),
    CM_EVENTTYPE_TAMPERING(906L, "Tampering"),
    CM_EVENTTYPE_CAMERA_RECORDING_STATISTICS(907L, "Camera recording statistics"),
    CM_EVENTTYPE_AVEXPORT_JOB_FAILED(910L, true, "AV export failed"),
    CM_EVENTTYPE_AVEXPORT_JOB_OLD(911L, true, "AV export old"),
    CM_EVENTTYPE_AVEXPORT_JOB_OLDER(912L, true, "AV export older"),
    CM_EVENTTYPE_STREAM_DISABLED(913L, "Stream disabled"),
    CM_EVENTTYPE_STREAM_ENABLED(914L, "Stream enabled"),
    GENERAL_EVENTTYPE_RE_START(915L, "RE start"),
    GENERAL_EVENTTYPE_RE_STOP(916L, "RE stop"),
    GENERAL_EVENTTYPE_RE_IN_FAILOVER(917L, "RE is Failover"),
    GENERAL_EVENTTYPE_RE_OUT_OF_FAILOVER(918L, "RE is out of Failover"),
    EVENT_INTERFACE_ITEM_EVENT(920L, "SEI Item Event"),
    CM_EVENTTYPE_EDGESTORAGE_IMPORT_SUCCESSFUL(921L, "Edgestorage import successful"),
    CM_EVENTTYPE_EDGESTORAGE_IMPORT_INTERRUPTED(922L, "Edgestorage import interrupted"),
    CM_EVENTTYPE_FIRMWARE_UPGRADE_SUCCESSFUL(923L, "Firmware upgrade successful"),
    CM_EVENTTYPE_FIRMWARE_UPGRADE_UNSUCCESSFUL(924L, "Firmware upgrade unsuccessful"),
    CM_EVENTTYPE_VIDEO_FILE_READER_IMPORT_UNSUCCESSFUL(925L, "Video File Reader import unsuccessful");

    private long type;
    private boolean transientEvent;
    private String description;

    private EventType(long type, String desc) {
        this(type, false, desc);
    }

    private EventType(long type, boolean transientEvent) {
        this(type, transientEvent, null);
    }

    private EventType(long type, boolean transientEvent, String desc) {
        this.type = type;
        this.transientEvent = transientEvent;
        this.description = desc;
    }

    public boolean isTransient() {
        return this.transientEvent;
    }

    public long getType() {
        return this.type;
    }

    public String getDescription() {
        if (this.description == null) {
            return String.valueOf(this.getType());
        }
        return this.description;
    }

    public static boolean isExisting(long givenType) {
        for (EventType t : EventType.values()) {
            if (givenType != t.type) continue;
            return true;
        }
        return false;
    }

    public static boolean isExisting(EventType givenType) {
        for (EventType t : EventType.values()) {
            if (givenType != t) continue;
            return true;
        }
        return false;
    }

    public static EventType valueOf(Long givenType) {
        EventType type = null;
        if (givenType == null) {
            return type;
        }
        for (EventType t : EventType.values()) {
            if (givenType != t.type) continue;
            type = t;
            break;
        }
        return type;
    }

    public String toString() {
        return "EventType: " + this.getType() + " (" + (this.isTransient() ? "transient" : "persistent") + ")";
    }
}

