/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.ComponentVersionNumberProvider;
import de.seetec.v5.shared.util.SeeTecException;

public class ComponentVersionNumberProviderImpl
implements ComponentVersionNumberProvider {
    private final String version;

    protected ComponentVersionNumberProviderImpl(String version) {
        this.version = version;
    }

    @Override
    public String getRawVersion() {
        return this.version;
    }

    @Override
    public String getRawVersionWithoutPatch() {
        if (this.version == null) {
            return null;
        }
        return this.version.split("_")[0];
    }

    @Override
    public byte[] getVersionTupel() throws SeeTecException {
        return this.getTupel(this.getRawVersion());
    }

    @Override
    public byte[] getVersionWithoutPatchTupel() throws SeeTecException {
        return this.getTupel(this.getRawVersionWithoutPatch());
    }

    public byte[] getTupel(String version) throws SeeTecException {
        if (version == null) {
            throw new SeeTecException(-20002, "Version number is null");
        }
        String[] tupel = version.split("\\.");
        if (tupel.length == 3) {
            try {
                if (tupel[2].contains("_")) {
                    String[] patchLevel = tupel[2].split("_");
                    return new byte[]{Byte.parseByte(tupel[0]), Byte.parseByte(tupel[1]), Byte.parseByte(patchLevel[0]), Byte.parseByte(patchLevel[1])};
                }
                return new byte[]{Byte.parseByte(tupel[0]), Byte.parseByte(tupel[1]), Byte.parseByte(tupel[2])};
            }
            catch (NumberFormatException e) {
                throw new SeeTecException(-20002, "Version number contains characters");
            }
        }
        throw new SeeTecException(-20002, "Version number not parseable");
    }

    @Override
    public String getReleaseVersion() {
        String[] tupel;
        String result = "n/a";
        if (this.version != null && (tupel = this.version.split("\\.")).length == 3) {
            try {
                Integer.parseInt(tupel[1]);
                String patchString = "";
                if (tupel[2].contains("_")) {
                    String[] patchLevel = tupel[2].split("_");
                    Integer.parseInt(patchLevel[1]);
                    patchString = " (Patch " + patchLevel[1] + ")";
                }
                return tupel[0] + "." + tupel[1] + patchString;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

