/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.AxisGenericEventTriggerNameParser;
import de.seetec.v5.shared.util.SeeTecException;

public class AxisGenericEventTriggerNameParserImpl
implements AxisGenericEventTriggerNameParser {
    @Override
    public int getVideoSourceNumber(String name) throws SeeTecException {
        try {
            String[] nameParts = name.split("\\|");
            if (name.toLowerCase().startsWith("cameraapplicationplatform/")) {
                return this.getSourceNumberFromAcapTrigger(nameParts);
            }
            if (name.toLowerCase().startsWith("device/tampering")) {
                return Integer.parseInt(nameParts[1].replace("channel:", ""));
            }
            if (name.toLowerCase().startsWith("ruleengine/vmd3")) {
                String[] namePartSegments = nameParts[0].split("/");
                return Integer.parseInt(namePartSegments[2].replace("vmd3_video_", ""));
            }
            if (name.toLowerCase().startsWith("ruleengine/motionregiondetector")) {
                return Integer.parseInt(nameParts[2].replace("VideoSource:", "")) + 1;
            }
            if (name.toLowerCase().startsWith("videosource/tampering") || name.toLowerCase().startsWith("videoencoder/connections")) {
                return Integer.parseInt(nameParts[1].replace("channel:", ""));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SeeTecException(-20000, "Could not extract video source number from trigger name " + name);
    }

    private int getSourceNumberFromAcapTrigger(String[] nameParts) throws SeeTecException {
        String[] namePartSegments = nameParts[0].split("/");
        if (namePartSegments.length > 2) {
            String numberAndProfile = namePartSegments[2].replace("Camera", "").replace("Device", "");
            String number = "";
            if (namePartSegments[2].toLowerCase().contains("device")) {
                number = numberAndProfile.substring(0, numberAndProfile.indexOf("Scenario"));
            } else if (namePartSegments[2].toLowerCase().contains("camera")) {
                number = numberAndProfile.substring(0, numberAndProfile.indexOf("Profile"));
            }
            return Integer.parseInt(number);
        }
        throw new SeeTecException(-20000, "Could not extract number from trigger name " + nameParts[0]);
    }
}

