/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.timerange;

import de.seetec.v5.re.shared.srpc.TrackType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class TimeRangeInfo
implements Comparable<TimeRangeInfo> {
    private long timestamp;
    private int length = Integer.MIN_VALUE;
    private byte track = 0;
    private boolean isFailover = false;

    public TimeRangeInfo(long timestamp, int length, byte track, boolean isFailover) {
        this.timestamp = timestamp;
        this.length = length;
        this.track = track;
        this.isFailover = isFailover;
    }

    public TimeRangeInfo(TimeRangeInfo timeRangeInfo) {
        this.timestamp = timeRangeInfo.getTimestamp();
        this.length = timeRangeInfo.getLength();
        this.track = timeRangeInfo.getTrack();
        this.isFailover = timeRangeInfo.isFailover();
    }

    public TimeRangeInfo(byte[] timeRangeInfo) throws SeeTecException {
        if (timeRangeInfo.length == 10) {
            this.timestamp = Basic.byteArrayToInt8((byte[])Arrays.copyOfRange(timeRangeInfo, 0, 5));
            this.length = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(timeRangeInfo, 5, 9));
            this.track = timeRangeInfo[9];
        }
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static final boolean isValidLength(long length) {
        return length >= 0L && length <= Integer.MAX_VALUE;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setIsFailover(boolean isFailover) {
        this.isFailover = isFailover;
    }

    public boolean isFailover() {
        return this.isFailover;
    }

    public byte getTrack() {
        return this.track;
    }

    public boolean isAlarmTrack() {
        return this.track == 0;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        byteArrayOutputStream.write(Basic.int8ToByteArray((long)this.getTimestamp(), (int)5));
        byteArrayOutputStream.write(Basic.int4ToByteArray((int)this.getLength()));
        byteArrayOutputStream.write(this.track);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean containsTimestamp(long timestamp) {
        boolean result = this.getTimestamp() <= timestamp && this.getTimestamp() + (long)this.getLength() >= timestamp;
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeRangeInfo)) {
            return false;
        }
        TimeRangeInfo timeRangeInfo = (TimeRangeInfo)object;
        return timeRangeInfo.getTimestamp() == this.timestamp && timeRangeInfo.getLength() == this.length && timeRangeInfo.getTrack() == this.track && timeRangeInfo.isFailover() == this.isFailover;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
        hash = 97 * hash + this.length;
        hash = 97 * hash + this.track;
        hash = 97 * hash + (this.isFailover ? 1 : 0);
        return hash;
    }

    @Override
    public int compareTo(TimeRangeInfo timeRangeInfo) {
        return Long.signum(this.getTimestamp() - timeRangeInfo.getTimestamp());
    }

    public String toString() {
        return "Start: " + this.timestamp + ". Length: " + TimeHelper.getReadableTimerange((long)this.length) + ". Track: " + (Object)((Object)TrackType.getByType(this.track)) + ". isFailover: " + this.isFailover;
    }
}

