/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import java.util.Date;
import java.util.List;

public class RspReadMultipleFrames
extends RequestWrapper {
    Integer resultCode = null;
    Long firstTimestamp = null;
    Long lastTimestamp = null;
    ContentFrame[] contentFrames = null;

    public RspReadMultipleFrames(Integer resultCode) {
        this(resultCode, null, null, null);
    }

    public RspReadMultipleFrames(Integer resultCode, Long firstTimestamp, Long lastTimestamp, ContentFrame[] contentFrames) {
        this.resultCode = resultCode;
        this.firstTimestamp = firstTimestamp;
        this.lastTimestamp = lastTimestamp;
        this.contentFrames = contentFrames;
    }

    public static RspReadMultipleFrames parseGObject(GObject goResponse) {
        Long firstTimestamp = null;
        Long lastTimestamp = null;
        ContentFrame[] contentFrames = new ContentFrame[]{};
        List lParameter = goResponse.getChildren();
        Integer nResultCode = ((GObject)lParameter.get(0)).getAsInt();
        if (lParameter.size() > 1) {
            firstTimestamp = ((GObject)lParameter.get(1)).getAsLong();
        }
        if (lParameter.size() > 2) {
            lastTimestamp = ((GObject)lParameter.get(2)).getAsLong();
        }
        if (lParameter.size() > 3) {
            List lContentFrames = ((GObject)lParameter.get(3)).getChildren();
            contentFrames = new ContentFrame[lContentFrames.size()];
            for (int i = 0; i < lContentFrames.size(); ++i) {
                List lContentFrame = ((GObject)lContentFrames.get(i)).getChildren();
                Integer mediatype = ((GObject)lContentFrame.get(0)).getAsInt();
                Integer attributes = ((GObject)lContentFrame.get(1)).getAsInt();
                Long startTimestamp = ((GObject)lContentFrame.get(2)).getAsLong();
                Long endTimestamp = ((GObject)lContentFrame.get(3)).getAsLong();
                byte[] data = ((GObject)lContentFrame.get(4)).getAsArrayOfByte();
                contentFrames[i] = new ContentFrame(mediatype, attributes, startTimestamp, endTimestamp, data);
            }
        }
        return new RspReadMultipleFrames(nResultCode, firstTimestamp, lastTimestamp, contentFrames);
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.resultCode);
        if (this.getFirstTimestamp() != null) {
            GObject goContentFrames = GObject.createList();
            goResponse.addChild(this.getFirstTimestamp());
            goResponse.addChild(this.getLastTimestamp());
            goResponse.addChild(goContentFrames);
            for (int i = 0; this.contentFrames != null && i < this.contentFrames.length; ++i) {
                this.contentFrames[i].addContentFramesToGObject(goContentFrames);
            }
        }
        return goResponse;
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public Long getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public Long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public ContentFrame[] getContentFrames() {
        return this.contentFrames;
    }

    public String toString() {
        String timerange = "";
        if (this.contentFrames != null && this.contentFrames.length > 0) {
            Long fts = this.contentFrames[0].getStartTimestamp();
            Long lts = this.contentFrames[this.contentFrames.length - 1].getEndTimestamp();
            timerange = ", Timerange=[" + Basic.longToFormattedString((Long)fts) + "/[" + new Date(fts) + "]-[" + Basic.longToFormattedString((Long)lts) + "/[" + new Date(lts) + "]";
        }
        if (this.firstTimestamp != null && this.lastTimestamp != null) {
            return "[" + Methods.RE_SRPC_REQ_READMULTIPLEFRAMES.methodName() + ", ResultCode=[" + this.resultCode + "], FirstTimestamp=[" + new Date(this.firstTimestamp) + "], LastTimestamp=[" + new Date(this.lastTimestamp) + "], #ContentFrames=[" + Basic.longToFormattedString((long)(this.contentFrames != null ? (long)this.contentFrames.length : 0L)) + "]" + timerange + "]";
        }
        return "[" + Methods.RE_SRPC_REQ_READMULTIPLEFRAMES.methodName() + ", ResultCode=[" + this.resultCode + "], #ContentFrames=[" + Basic.longToFormattedString((long)(this.contentFrames != null ? (long)this.contentFrames.length : 0L)) + "]" + timerange + "]";
    }
}

