/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.re.shared.ImportInformation;
import de.seetec.v5.re.shared.SequenceInfo;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;

public class RspGetImportInfo {
    private final List<ImportInformation> importInformation;

    public RspGetImportInfo(List<ImportInformation> importInformation) throws SeeTecException {
        this.importInformation = importInformation;
        if (this.importInformation == null) {
            throw new SeeTecException(-20002, "Parameter null");
        }
    }

    public static RspGetImportInfo parseGObject(GObject goRequest) throws SeeTecException {
        ArrayList<ImportInformation> importInformation = new ArrayList<ImportInformation>();
        List contentList = goRequest.getChildren();
        for (GObject goList : contentList) {
            for (GObject list : goList.getChildren()) {
                SequenceInfoTransfer sequenceInfo = new SequenceInfoTransfer(list.getChildAt(0).tryGetAsLong(), list.getChildAt(1).tryGetAsString(), list.getChildAt(2).tryGetAsLong(), list.getChildAt(3).tryGetAsLong(), list.getChildAt(4).tryGetAsString(), list.getChildAt(5).tryGetAsString());
                importInformation.add(new ImportInformation(sequenceInfo, list.getChildAt(6).getAsString(), list.getChildAt(7).getAsString()));
            }
        }
        return new RspGetImportInfo(importInformation);
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        GObject goContentList = GObject.createList();
        this.importInformation.forEach(information -> {
            GObject goContent = GObject.createList();
            goContentList.addChild(goContent);
            goContent.addChild(Long.valueOf(information.getContentID()));
            goContent.addChild(information.getContentAlias());
            goContent.addChild(Long.valueOf(information.getVideoSourceType()));
            goContent.addChild(Long.valueOf(information.getVideoServerType()));
            goContent.addChild(information.getSequenceHash());
            goContent.addChild(information.getSequencePath());
            goContent.addChild(information.getVideoSourceConfiguration());
            goContent.addChild(information.getVideoServerConfiguration());
        });
        goResponse.addChild(goContentList);
        return goResponse;
    }

    public List<ImportInformation> getImportInformation() {
        return this.importInformation;
    }

    private static class SequenceInfoTransfer
    implements SequenceInfo {
        private final long contentID;
        private final String contentAlias;
        private final long videoSourceType;
        private final long videoServerType;
        private final String sequenceHash;
        private final String sequencePath;

        SequenceInfoTransfer(long contentID, String contentAlias, long videoSourceType, long videoServerType, String sequenceHash, String sequencePath) {
            this.contentID = contentID;
            this.contentAlias = contentAlias;
            this.videoSourceType = videoSourceType;
            this.videoServerType = videoServerType;
            this.sequenceHash = sequenceHash;
            this.sequencePath = sequencePath;
        }

        @Override
        public String getContentAlias() {
            return this.contentAlias;
        }

        @Override
        public long getContentID() {
            return this.contentID;
        }

        @Override
        public String getSequenceCipher() {
            return null;
        }

        @Override
        public String getSequenceHash() {
            return this.sequenceHash;
        }

        @Override
        public boolean checkPassword(String password) {
            return true;
        }

        @Override
        public long getSequenceID() {
            return -1L;
        }

        @Override
        public String getSequencePath() {
            return this.sequencePath;
        }

        @Override
        public long getVideoServerType() {
            return this.videoServerType;
        }

        @Override
        public long getVideoSourceType() {
            return this.videoSourceType;
        }

        @Override
        public void setContentID(long contentID) {
        }
    }
}

