/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcDataType;
import java.util.Date;
import java.util.List;

public class ReqStartExport {
    private final long contentID;
    private final boolean standardTrack;
    private final boolean alarmTrack;
    private final String password;
    private long fromTimestamp;
    private long toTimestamp;
    private long splitSize;
    private String path;
    private final boolean includePrivacyMasks;
    private final String additionalPath;
    private final Long asyncServersideExport;
    private final byte[] additionalData;

    public ReqStartExport(Long contentID, boolean standardTrack, boolean alarmTrack, String password, long fromTimestamp, long toTimestamp, long splitSize, String path, boolean includePrivacyMasks, String additionalPath, Long asyncServersideExport, byte[] additionalData) {
        this.contentID = contentID;
        this.standardTrack = standardTrack;
        this.alarmTrack = alarmTrack;
        this.password = password;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
        this.splitSize = splitSize;
        if (this.splitSize < 0x100000L) {
            this.splitSize = 0L;
        }
        this.path = path;
        this.includePrivacyMasks = includePrivacyMasks;
        this.additionalPath = additionalPath;
        this.asyncServersideExport = asyncServersideExport;
        this.additionalData = (byte[])(additionalData != null ? (byte[])additionalData.clone() : null);
    }

    public static ReqStartExport parseGObject(GObject goRequest) {
        int index = -1;
        List children = goRequest.getChildren();
        long contentID = ((GObject)children.get(++index)).getAsLong();
        boolean standardTrack = ((GObject)children.get(++index)).getAsBoolean();
        boolean alarmTrack = ((GObject)children.get(++index)).getAsBoolean();
        String password = ((GObject)children.get(++index)).getAsString();
        long from = ((GObject)children.get(++index)).getAsLong();
        long to = ((GObject)children.get(++index)).getAsLong();
        long splitSize = ((GObject)children.get(++index)).getAsLong();
        String path = ((GObject)children.get(++index)).getAsString();
        boolean includePrivacyMasks = true;
        if (children.size() > index + 1 && ((GObject)children.get(index + 1)).isType(SrpcDataType.BOOLEAN)) {
            includePrivacyMasks = ((GObject)children.get(++index)).getAsBoolean();
        }
        String additionalPath = "";
        if (children.size() > index + 1 && ((GObject)children.get(index + 1)).isType(SrpcDataType.STRING)) {
            additionalPath = ((GObject)children.get(++index)).getAsString();
        }
        Long asyncServersideExport = null;
        if (children.size() > index + 1 && ((GObject)children.get(index + 1)).isType(SrpcDataType.INT8)) {
            asyncServersideExport = ((GObject)children.get(++index)).getAsLong();
        }
        byte[] additionalData = null;
        if (children.size() > index + 1) {
            additionalData = ((GObject)children.get(++index)).getAsArrayOfByte();
        }
        return new ReqStartExport(contentID, standardTrack, alarmTrack, password, from, to, splitSize, path, includePrivacyMasks, additionalPath, asyncServersideExport, additionalData);
    }

    public GObject createGObject() {
        GObject go = GObject.createList();
        go.addChild(Long.valueOf(this.contentID));
        go.addChild(Boolean.valueOf(this.standardTrack));
        go.addChild(Boolean.valueOf(this.alarmTrack));
        go.addChild(this.password);
        go.addChild(Long.valueOf(this.fromTimestamp));
        go.addChild(Long.valueOf(this.toTimestamp));
        go.addChild(Long.valueOf(this.splitSize));
        go.addChild(this.path);
        go.addChild(Boolean.valueOf(this.includePrivacyMasks));
        if (this.additionalPath != null) {
            go.addChild(this.additionalPath);
        } else {
            go.addChild("");
        }
        if (this.asyncServersideExport != null) {
            go.addChild(this.asyncServersideExport);
        }
        if (this.additionalData != null) {
            go.addChild(this.additionalData);
        }
        return go;
    }

    public long getContentID() {
        return this.contentID;
    }

    public boolean getStandardTrack() {
        return this.standardTrack;
    }

    public boolean getAlarmTrack() {
        return this.alarmTrack;
    }

    public String getPassword() {
        return this.password;
    }

    public long getFrom() {
        return this.fromTimestamp;
    }

    public void setFrom(long from) {
        this.fromTimestamp = from;
    }

    public long getTo() {
        return this.toTimestamp;
    }

    public void setTo(long to) {
        this.toTimestamp = to;
    }

    public long getSplitSize() {
        return this.splitSize;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isServerSideExport() {
        return this.path != null && !this.path.trim().isEmpty();
    }

    public boolean getIncludePrivacyMasks() {
        return this.includePrivacyMasks;
    }

    public String getAdditionalPath() {
        return this.additionalPath;
    }

    public Long getAsyncServersideExport() {
        return this.asyncServersideExport;
    }

    public byte[] getAdditionalData() {
        return this.additionalData;
    }

    public String toString() {
        String from;
        String to = from = "__undefined__";
        String additionalDataLength = "__undefined__";
        if (this.fromTimestamp > 0L) {
            from = new Date(this.fromTimestamp).toString();
        }
        if (this.toTimestamp > 0L) {
            to = new Date(this.toTimestamp).toString();
        }
        if (this.additionalData != null) {
            additionalDataLength = Basic.longToFormattedString((long)this.additionalData.length) + " B";
        }
        return "[" + Methods.MD_REQ_STARTEXPORT.methodName() + ", ContentID=[" + this.contentID + "], StandardTrack=[" + this.standardTrack + "], AlarmTrack=[" + this.alarmTrack + "], From=[" + from + "], To=[" + to + "], SplitSize=[" + Basic.longToFormattedString((long)(this.splitSize >> 20)) + " MB], Path=[" + this.path + "], IncludePrivacyMaks=[" + this.includePrivacyMasks + "], AdditionalPath=[" + this.additionalPath + "], AsyncServersideExport=[" + this.getAsyncServersideExport() + "], AdditionalData=[" + additionalDataLength + "]]";
    }
}

