/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ReqReadMultipleFrames
extends RequestWrapper {
    private final Integer[] mediatypes;
    private final Integer track;
    private final Long tsFrom;
    private final Long tsTill;
    private final Long maxVolume;
    private Integer transactionId = null;
    private Long milliFps = null;
    private final Long playbackSpeed = 1L;

    public ReqReadMultipleFrames(Integer[] mediatypes, Integer track, Long tsFrom, Long tsTill, Long maxVolume, Integer transactionId, Long milliFps) {
        this.mediatypes = mediatypes != null ? mediatypes : new Integer[]{};
        this.track = track;
        this.tsFrom = tsFrom;
        this.tsTill = tsTill;
        this.maxVolume = maxVolume;
        this.transactionId = transactionId;
        this.milliFps = milliFps;
    }

    public GObject createGObject() {
        GObject goRequest = GObject.createList();
        GObject goMediatypes = GObject.createList();
        for (Integer mediatype : this.mediatypes) {
            goMediatypes.addChild(mediatype);
        }
        goRequest.addChild(goMediatypes);
        goRequest.addChild(this.track);
        goRequest.addChild(this.tsFrom);
        goRequest.addChild(this.tsTill);
        goRequest.addChild(this.maxVolume);
        goRequest.addChild(this.transactionId);
        goRequest.addChild(this.milliFps);
        goRequest.addChild(this.playbackSpeed);
        return goRequest;
    }

    public static RequestWrapper parseGObject(GObject goRequest) {
        List lParameters = goRequest.getChildren();
        List mediatypesObjects = ((GObject)lParameters.get(0)).getChildren();
        Integer track = ((GObject)lParameters.get(1)).getAsInt();
        Long tsFrom = ((GObject)lParameters.get(2)).getAsLong();
        Long tsTill = ((GObject)lParameters.get(3)).getAsLong();
        Long maxVolume = ((GObject)lParameters.get(4)).getAsLong();
        Integer transactionID = ((GObject)lParameters.get(5)).tryGetAsInt();
        Long milliFps = -1L;
        if (lParameters.size() > 6) {
            milliFps = ((GObject)lParameters.get(6)).tryGetAsLong();
        }
        Integer[] mediatypes = new Integer[mediatypesObjects.size()];
        for (int i = 0; i < mediatypes.length; ++i) {
            mediatypes[i] = ((GObject)mediatypesObjects.get(i)).getAsInt();
        }
        return new ReqReadMultipleFrames(mediatypes, track, tsFrom, tsTill, maxVolume, transactionID, milliFps);
    }

    public Integer[] getMediatypes() {
        return this.mediatypes;
    }

    public Integer getTrack() {
        return this.track;
    }

    public Long getFrom() {
        return this.tsFrom;
    }

    public Long getTill() {
        return this.tsTill;
    }

    public Long getMaxVolume() {
        return this.maxVolume;
    }

    public Integer getTransactionId() {
        return this.transactionId;
    }

    public Long getMilliFps() {
        return this.milliFps;
    }

    public void setMilliFps(long fps) {
        this.milliFps = fps;
    }

    public String toString() {
        String sMediatypes = "";
        if (this.mediatypes != null && this.mediatypes.length != 0) {
            sMediatypes = Arrays.toString((Object[])this.mediatypes);
        }
        String sTrack = "undefined";
        if (this.track != null) {
            sTrack = Basic.longToFormattedString((Integer)this.track);
        }
        String sFrom = "undefined";
        if (this.tsFrom != null) {
            sFrom = Basic.longToFormattedString((Long)this.tsFrom) + "]/[" + new Date(this.tsFrom);
        }
        String sTill = "undefined";
        if (this.tsTill != null) {
            sTill = Basic.longToFormattedString((Long)this.tsTill) + "]/[" + new Date(this.tsTill);
        }
        String sTransactionId = "undefined";
        if (this.transactionId != null) {
            sTransactionId = Basic.longToFormattedString((Integer)this.transactionId);
        }
        String sMilliFps = "undefined";
        if (this.milliFps != null) {
            sMilliFps = Basic.longToFormattedString((Long)this.milliFps);
        }
        return "[" + Methods.RE_SRPC_REQ_READMULTIPLEFRAMES.methodName() + ", Mediatypes=" + sMediatypes + ", Track=[" + sTrack + "], From=[" + sFrom + "], Till=[" + sTill + "], MaxVolume=[" + Basic.longToFormattedString((Long)this.maxVolume) + "], TransactionId=[" + sTransactionId + "], MilliFps=[" + sMilliFps + "]]";
    }
}

