/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.util.List;

public abstract class ContentFrameRequestWrapper
extends RequestWrapper {
    private final ContentFrame[] contentFrames;
    private final String methodName;

    public ContentFrameRequestWrapper(String methodName, ContentFrame[] contentFrames) {
        this.methodName = methodName;
        this.contentFrames = contentFrames;
    }

    protected static ContentFrame[] parseContentFrame(GObject goRequest) {
        GObject goContentFrames = goRequest.getChildAt(0);
        List contentFramesList = goContentFrames.getChildren();
        ContentFrame[] contentFrames = new ContentFrame[contentFramesList.size()];
        for (int i = 0; i < contentFramesList.size(); ++i) {
            GObject goContentFrame = (GObject)contentFramesList.get(i);
            Integer mediaType = goContentFrame.getChildAt(0).getAsInt();
            Integer attributes = goContentFrame.getChildAt(1).getAsInt();
            Long startTimestamp = goContentFrame.getChildAt(2).getAsLong();
            Long endTimestamp = goContentFrame.getChildAt(3).getAsLong();
            byte[] data = goContentFrame.getChildAt(4).getAsArrayOfByte();
            contentFrames[i] = new ContentFrame(mediaType, attributes, startTimestamp, endTimestamp, data);
        }
        return contentFrames;
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        GObject goContentFrames = GObject.createList();
        for (ContentFrame contentFrame : this.contentFrames) {
            GObject goContentFrame = GObject.createList();
            goContentFrame.addChild(Integer.valueOf(contentFrame.getMediatype()));
            goContentFrame.addChild(Integer.valueOf(contentFrame.getAttributes()));
            goContentFrame.addChild(Long.valueOf(contentFrame.getStartTimestamp()));
            goContentFrame.addChild(Long.valueOf(contentFrame.getEndTimestamp()));
            goContentFrame.addChild(contentFrame.getData());
            goContentFrames.addChild(goContentFrame);
        }
        goResponse.addChild(goContentFrames);
        return goResponse;
    }

    public ContentFrame[] getContentFrames() {
        return this.contentFrames;
    }

    public String toString() {
        return "[" + this.methodName + ", [" + Basic.longToFormattedString((long)this.contentFrames.length) + "] content frames]";
    }
}

