/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.net.srpc.general.ReqTriggerAction;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TriggerActionHandler
implements Runnable {
    private static final String CLASS_NAME = "TriggerActionHandler";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Thread thread = null;
    private ReqTriggerAction reqTriggerAction = null;
    private RECore core;

    public TriggerActionHandler(ReqTriggerAction reqTriggerAction, RECore core) throws SeeTecException {
        this.reqTriggerAction = reqTriggerAction;
        if (this.reqTriggerAction == null) {
            throw new SeeTecException(-21001, "Action null");
        }
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-21001, "Core null");
        }
    }

    public void init() {
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
    }

    @Override
    public void run() {
        this.logger.info("Forwarding " + this.reqTriggerAction + " to " + this.core + "...");
        long serviceID = this.reqTriggerAction.getServiceID();
        long actionID = this.reqTriggerAction.getActionID();
        try {
            Entity service = this.core.getEntMgrProxy().getEntityByID(Long.valueOf(serviceID), Boolean.valueOf(false), 30000L);
            Entity action = this.core.getEntMgrProxy().getEntityByID(Long.valueOf(actionID), Boolean.valueOf(false), 30000L);
            if (!Objects.equals(action.getLogicalParent(), service.getEntityID()) && Objects.equals(action.getLogicalParent(), service.getPhysicalParent())) {
                serviceID = service.getPhysicalParent();
            }
        }
        catch (SeeTecException e) {
            this.logger.warn("Error when checking for the correct service, let's try to trigger the action with the configuration we have.", (Throwable)e);
        }
        this.core.delegateTriggerAction(serviceID, actionID, this.reqTriggerAction.getAlarmScriptID(), this.reqTriggerAction.getAlarmInstanceID(), this.reqTriggerAction.getAlarmTimerange(), this.reqTriggerAction.getGenericData(), this.reqTriggerAction.getPTZPriority(), this.reqTriggerAction.getPTZPriorityTimeout());
    }

    public String toString() {
        return "[TriggerActionHandler@" + Integer.toHexString(this.hashCode()) + ", " + this.reqTriggerAction + "]";
    }
}

