/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import de.seetec.v5.shared.util.WorkCenterCalendar;
import de.seetec.v5.shared.util.WorkCenterCalendarRepository;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReWorkCenterCalendarRepositoryImpl
implements WorkCenterCalendarRepository {
    private final EntMgrProxy proxy;
    private final Map<Long, WorkCenterCalendar> map = new HashMap<Long, WorkCenterCalendar>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public ReWorkCenterCalendarRepositoryImpl(EntMgrProxy proxy) throws SeeTecException {
        Entity[] calendars;
        this.proxy = proxy;
        if (this.proxy == null) {
            throw new SeeTecException(-20002, "Parameter null while starting up ReWorkCenterCalendarRepositoryImpl");
        }
        for (Entity calendar : calendars = this.proxy.getEntitiesAsList(Arrays.asList(55L), Boolean.TRUE, TimeUnit.SECONDS.toMillis(30L))) {
            this.storeCalendarEntity(calendar);
        }
    }

    public void store(long id) throws SeeTecException {
        Entity calendar = this.proxy.getEntityByID(Long.valueOf(id), Boolean.TRUE, TimeUnit.SECONDS.toMillis(30L));
        if (calendar.getEntityType() == 55L) {
            this.storeCalendarEntity(calendar);
        }
    }

    public void remove(long id) {
        this.readWriteLock.writeLock().lock();
        try {
            this.map.remove(id);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkCenterCalendar get(long id) {
        this.readWriteLock.readLock().lock();
        try {
            WorkCenterCalendar workCenterCalendar = this.map.get(id);
            return workCenterCalendar;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private void storeCalendarEntity(Entity calendar) throws SeeTecException {
        WorkCenterCalendar workCenterCalendar = new WorkCenterCalendar(calendar.getEntityID().longValue());
        workCenterCalendar.init(calendar.getConfiguration());
        this.readWriteLock.writeLock().lock();
        try {
            this.map.put(calendar.getEntityID(), workCenterCalendar);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

