/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.ExportDirectoryEntry;
import de.seetec.v5.re.shared.ExportNetworkClientProxy;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.networking.srpc.NetworkDispatcherHeader;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NativeExportDownloadHandler
implements Runnable,
SRPCDispatcherListener {
    private static final String CLASS_NAME = "NativeExportDownloadHandler";
    private final Logger logger = LogManager.getLogger((String)"NativeExportDownloadHandler");
    private final RECore core;
    private final long idExportedSequence;
    private final File pathExportedSequence;
    private final int bandwidthLimitation;
    private ExportNetworkClientProxy networkClientProxy = null;
    private ExecutorService scheduler = null;
    private boolean isShutdown = false;

    public NativeExportDownloadHandler(RECore core, long idExportedSequence, File pathExportedSequence, int bandwidthLimitation) throws SeeTecException {
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-20002, "Core is null");
        }
        this.idExportedSequence = idExportedSequence;
        this.pathExportedSequence = pathExportedSequence;
        if (this.pathExportedSequence == null) {
            throw new SeeTecException(-20002, "Path of exported Sequence is null");
        }
        if (!pathExportedSequence.exists()) {
            throw new SeeTecException(-20002, "Can't access path '" + pathExportedSequence + "'");
        }
        this.bandwidthLimitation = bandwidthLimitation;
        this.core.registerToSRPCDispatcher(this, idExportedSequence);
        this.scheduler = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(this.toString()));
    }

    public void startExportDownload() {
        this.logger.info("Starting export download for sequence [" + this.idExportedSequence + "]/[" + this.pathExportedSequence + "]");
        this.scheduler.execute(this);
    }

    @Override
    public void run() {
        try {
            if (!this.waitForClientConnection()) {
                return;
            }
            this.logger.info("Streaming export [" + this.idExportedSequence + "] to " + (Object)((Object)this.networkClientProxy));
            this.streamFilesToClient(this.networkClientProxy, this.pathExportedSequence, this.getDirectoryEntries());
        }
        catch (Throwable ex) {
            this.logger.warn(ex.getMessage());
        }
        long timeoutTimestamp = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
        while (!(timeoutTimestamp <= System.currentTimeMillis() || this.networkClientProxy == null || this.networkClientProxy.isShutdown() || this.isShutdown() || this.core.isShutdown())) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.shutdown();
    }

    private boolean waitForClientConnection() throws InterruptedException {
        long timeoutTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (this.networkClientProxy == null && !this.isShutdown()) {
            if (timeoutTimestamp - System.currentTimeMillis() < 0L) {
                this.logger.error("No NetworkClientProxy connected, so discarding " + this);
                this.shutdown();
                return false;
            }
            Thread.sleep(100L);
        }
        return true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public int shutdown() {
        if (this.isShutdown) {
            return 0;
        }
        this.isShutdown = true;
        this.logger.info("Starting shutdown of " + this + " ...");
        try {
            this.core.deregisterFromSRPCDispatcher(this.idExportedSequence);
        }
        catch (Exception ex) {
            this.logger.warn("Not possible to deregister as srpc listener for " + this);
        }
        this.scheduler.shutdownNow();
        try {
            if (!this.scheduler.awaitTermination(1L, TimeUnit.HOURS)) {
                this.logger.warn("Canceling NativeExportDownloadHandler timed out. Removing left-overs in temp folder on a best-effort base.");
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            FileUtils.deleteDirectory((File)this.pathExportedSequence);
        }
        catch (IOException | NullPointerException ex) {
            this.logger.warn("Removing of " + this.pathExportedSequence + "' failed. Message: " + ex.getMessage());
        }
        if (this.networkClientProxy != null) {
            this.networkClientProxy.shutdown();
        }
        return 0;
    }

    private void streamFilesToClient(ExportNetworkClientProxy networkClientProxy, File directoryToUpload, List<ExportDirectoryEntry> exportDirectoryList) throws SeeTecException {
        block13: for (int i = 0; i < exportDirectoryList.size(); ++i) {
            ExportDirectoryEntry exportDirectoryEntry = exportDirectoryList.get(i);
            String relativeFilePath = exportDirectoryEntry.getRelativeFilePath();
            String fileHash = exportDirectoryEntry.getFileHash();
            Long fileLength = exportDirectoryEntry.getFileLength();
            String fullPath = directoryToUpload.getAbsolutePath() + RECore.FileSeparator + relativeFilePath;
            this.logger.info("Streaming Export (" + (i + 1) + "/" + exportDirectoryList.size() + "): FileLength=[" + Basic.longToFormattedString((Long)fileLength) + "], RelativeFilePath=[" + relativeFilePath + "], FileHash=[" + fileHash + "]");
            try {
                byte[] buffer = this.getBuffer(this.bandwidthLimitation);
                long cycleTime = this.calculateCycleTime(this.bandwidthLimitation, buffer.length);
                try (FileInputStream fis = new FileInputStream(fullPath);){
                    networkClientProxy.writeExportFrameHeader(fileHash, fileLength);
                    while (true) {
                        if (this.isShutdown()) {
                            throw new SeeTecException(-20000, "Shutdown initiated");
                        }
                        int length = fis.read(buffer, 0, buffer.length);
                        if (length <= 0) {
                            continue block13;
                        }
                        networkClientProxy.streamExportFrameDate(buffer, 0, length);
                        if (cycleTime <= 0L) continue;
                        try {
                            Thread.sleep(cycleTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            catch (Throwable t) {
                throw new SeeTecException(-20001, "Streaming file [" + fullPath + "] to [" + (Object)((Object)networkClientProxy) + "] failed. Reason: " + t.getMessage(), t);
            }
        }
        this.logger.info("Completed: [" + exportDirectoryList.size() + "] files streamed!");
    }

    private long calculateCycleTime(Integer bandwidthLimitation, int bufferLength) {
        long cycleTime = bandwidthLimitation >= this.megabitsIntoBits(1024) ? 0L : (long)(1000.0 / ((double)bandwidthLimitation.intValue() / 8.0 / (double)bufferLength));
        return cycleTime;
    }

    private byte[] getBuffer(Integer bandwidthLimitation) {
        byte[] buffer = bandwidthLimitation >= this.megabitsIntoBits(1024) ? new byte[this.kilobitsIntoBit(64)] : (bandwidthLimitation < this.kilobitsIntoBit(256) ? new byte[this.kilobitsIntoBit(1)] : new byte[this.cutToFullKilobit(bandwidthLimitation >> 7)]);
        return buffer;
    }

    private int cutToFullKilobit(int bit) {
        return bit / 1024 * 1024;
    }

    private int kilobitsIntoBit(int kilobit) {
        return kilobit * 1024;
    }

    private int megabitsIntoBits(int megabit) {
        return megabit * 1024 * 1024;
    }

    public List<ExportDirectoryEntry> getDirectoryEntries() throws SeeTecException, NoSuchAlgorithmException, UnsupportedEncodingException {
        ArrayList<ExportDirectoryEntry> exportDirectoryList = new ArrayList<ExportDirectoryEntry>();
        Path entryPoint = this.pathExportedSequence.toPath();
        if (!entryPoint.toFile().isDirectory()) {
            throw new SeeTecException(-20001, "[" + this.pathExportedSequence + "] is not a folder.");
        }
        try {
            Files.walk(entryPoint, new FileVisitOption[0]).filter(path1 -> !Files.isDirectory(path1, new LinkOption[0])).forEach(path1 -> {
                try {
                    exportDirectoryList.add(new ExportDirectoryEntry(path1.toString().substring(this.pathExportedSequence.getAbsolutePath().length() + 1), NativeExportDownloadHandler.stringToHash(path1.toString()), path1.toFile().length()));
                }
                catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
                    LogManager.getLogger((String)CLASS_NAME).error("Exception while creating file hash: " + ex.getMessage());
                }
            });
        }
        catch (IOException ex) {
            throw new SeeTecException(-20001, "[" + this.pathExportedSequence + "] not existing/usable.");
        }
        return exportDirectoryList;
    }

    private static String stringToHash(String sStringToHash) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest hash = MessageDigest.getInstance("MD5");
        hash.reset();
        hash.update(sStringToHash.getBytes("UTF-8"));
        byte[] result = hash.digest();
        StringBuffer hexString = new StringBuffer(32);
        for (int i = 0; i < result.length; ++i) {
            hexString.append(String.format("%02X", result[i]));
        }
        return hexString.toString();
    }

    public String toString() {
        return "[" + "NativeExportDownloadHandler@" + Integer.toHexString(this.hashCode()) + ", IDExportedSequence=[" + this.idExportedSequence + "], PathExporetedSequence=[" + this.pathExportedSequence + "]]";
    }

    public int handleRequest(Socket aSocket) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int handleRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (networkDispatcherHeader.getProtocol() == 2) {
            this.logger.info("Handling ExportStream " + socket + " / " + networkDispatcherHeader);
            try {
                this.networkClientProxy = new ExportNetworkClientProxy(socket, networkDispatcherHeader.getServiceID());
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Creating " + (Object)((Object)this.networkClientProxy) + " failed with error [" + seeTecException.getErrorCode() + "]");
                if (this.networkClientProxy != null) {
                    this.networkClientProxy.shutdown();
                }
                return seeTecException.getErrorCode();
            }
            return 0;
        }
        this.logger.error("Protocol [" + networkDispatcherHeader.getProtocol() + "] not supported");
        this.shutdown();
        return -21005;
    }
}

