/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MediaFrame {
    public static final int MEDIA_FRAME_HEADER_LENGTH = 16;
    static final byte[] MEDIA_FRAME_HEADER_MAGIC = new byte[]{94, -25, -20, 65};
    private int imageWidth = 0;
    private int imageHeight = 0;
    private Codec codec;
    private int bitrate = 0;
    private final List<byte[]> payload = new ArrayList<byte[]>();
    private byte[] data;
    private boolean hasChanged = false;
    private int audioSampleRate = 0;

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        if (imageWidth != this.imageWidth) {
            this.hasChanged = true;
            this.imageWidth = imageWidth;
        }
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        if (imageHeight != this.imageHeight) {
            this.hasChanged = true;
            this.imageHeight = imageHeight;
        }
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(Codec codec) throws IllegalArgumentException {
        if (codec == null) {
            throw new IllegalArgumentException();
        }
        if (this.codec == null || codec.getType() != this.codec.getType()) {
            this.hasChanged = true;
            this.codec = codec;
        }
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        if (bitrate != this.bitrate) {
            this.hasChanged = true;
            this.bitrate = bitrate;
        }
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public void setSampleRate(int sampleRate) {
        if (sampleRate != this.audioSampleRate) {
            this.hasChanged = true;
            this.audioSampleRate = sampleRate;
        }
    }

    public List<byte[]> getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.hasChanged = true;
        this.payload.add(payload);
    }

    private void refreshData() {
        int lengthOfPayload = 0;
        for (int i = 0; i < this.payload.size(); ++i) {
            if (i != 0) {
                lengthOfPayload += 4;
            }
            lengthOfPayload += this.payload.get(i).length;
        }
        this.data = new byte[16 + lengthOfPayload];
        System.arraycopy(MEDIA_FRAME_HEADER_MAGIC, 0, this.data, 0, MEDIA_FRAME_HEADER_MAGIC.length);
        this.data[8] = this.codec != null ? (byte)this.codec.getType() : (byte)0;
        this.data[9] = (byte)this.bitrate;
        this.data[10] = 0;
        this.data[11] = 0;
        if (this.bitrate != 0) {
            System.arraycopy(Basic.int4ToByteArray((int)this.audioSampleRate, (int)4), 0, this.data, 4, 4);
        } else {
            System.arraycopy(Basic.int4ToByteArray((int)this.imageWidth, (int)2), 0, this.data, 4, 2);
            System.arraycopy(Basic.int4ToByteArray((int)this.imageHeight, (int)2), 0, this.data, 6, 2);
        }
        int pointer = 12;
        for (byte[] singlePayload : this.payload) {
            System.arraycopy(Basic.int4ToByteArray((int)singlePayload.length, (int)4), 0, this.data, pointer, 4);
            System.arraycopy(singlePayload, 0, this.data, pointer += 4, singlePayload.length);
            pointer += singlePayload.length;
        }
        this.hasChanged = false;
    }

    public int getLength() {
        if (this.data == null || this.data.length == 0 || this.hasChanged) {
            this.refreshData();
        }
        return this.data == null ? 0 : this.data.length;
    }

    public byte[] getData() {
        if (this.data == null || this.data.length == 0 || this.hasChanged) {
            this.refreshData();
        }
        return this.data == null ? new byte[]{} : this.data;
    }

    public static MediaFrame deserialize(byte[] data) throws SeeTecException {
        if (data == null || data.length < 16) {
            throw new SeeTecException(-20002, "Invalid MediaFrameHeader.");
        }
        if (data[0] != MEDIA_FRAME_HEADER_MAGIC[0] || data[1] != MEDIA_FRAME_HEADER_MAGIC[1] || data[2] != MEDIA_FRAME_HEADER_MAGIC[2] || data[3] != MEDIA_FRAME_HEADER_MAGIC[3]) {
            throw new SeeTecException(-20002, "Invalid MediaFrameHeader magic.");
        }
        MediaFrame mediaFrame = new MediaFrame();
        ByteBuffer dataAsBuffer = ByteBuffer.wrap(data, MEDIA_FRAME_HEADER_MAGIC.length, data.length - MEDIA_FRAME_HEADER_MAGIC.length);
        mediaFrame.setImageWidth(dataAsBuffer.getShort());
        mediaFrame.setImageHeight(dataAsBuffer.getShort());
        mediaFrame.setCodec(Codec.valueOf(dataAsBuffer.get()));
        mediaFrame.setBitrate(dataAsBuffer.get());
        dataAsBuffer.get();
        dataAsBuffer.get();
        byte[] wholePayload = new byte[data.length - dataAsBuffer.position()];
        dataAsBuffer.get(wholePayload, 0, data.length - dataAsBuffer.position());
        ByteBuffer wholePayloadAsBuffer = ByteBuffer.wrap(wholePayload);
        while (wholePayloadAsBuffer.hasRemaining()) {
            int payloadLength = wholePayloadAsBuffer.getInt();
            if (payloadLength == 0) continue;
            byte[] payloadAsByte = new byte[payloadLength];
            wholePayloadAsBuffer.get(payloadAsByte, 0, payloadLength);
            mediaFrame.setPayload(payloadAsByte);
        }
        return mediaFrame;
    }
}

