/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.ServiceTypes;
import de.seetec.v5.shared.configuration.eventing.EventNotificationDetail;
import de.seetec.v5.shared.configuration.eventing.Eventing;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LifeCycleEventEngine {
    private static final Logger LOGGER = LogManager.getLogger((String)LifeCycleEventEngine.class.getName());
    private volatile boolean reStartedEventSent = false;
    private final String message = "%s %s at [%s/%s]";
    private RECore reCore;
    private EventNotificationDetail startNotificationDetails;
    private EventNotificationDetail stopNotificationDetails;
    private long entityID;
    private long entityType;

    public int init(RECore reCore, byte[] eventManagerConfiguration, long entityID, long entityType) {
        this.reCore = reCore;
        if (this.reCore == null || eventManagerConfiguration == null) {
            return -20002;
        }
        try {
            Eventing eventing = (Eventing)Basic.unmarshalXML(Eventing.class, (Object)eventManagerConfiguration, (boolean)true);
            List listOfNotificationDetails = eventing.getEventNotification().getEventNotifications().getEventNotificationDetail();
            for (EventNotificationDetail detail : listOfNotificationDetails) {
                if (detail.getEventType() == EventType.GENERAL_EVENTTYPE_RE_START.getType()) {
                    this.startNotificationDetails = detail;
                    continue;
                }
                if (detail.getEventType() != EventType.GENERAL_EVENTTYPE_RE_STOP.getType()) continue;
                this.stopNotificationDetails = detail;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while reading configuration: " + e.getMessage());
            return -20000;
        }
        this.entityID = entityID;
        this.entityType = entityType;
        return 0;
    }

    public int update(byte[] eventManagerConfiguration) {
        return this.init(this.reCore, eventManagerConfiguration, this.entityID, this.entityType);
    }

    public void sendStartupEvent(boolean sendLegacyEvent) {
        if (!this.reStartedEventSent) {
            try {
                if (sendLegacyEvent) {
                    LOGGER.info("Sending legacy STARTUP event after registering entity");
                    if (this.reCore.sendEvent(EventType.CM_EVENTTYPE_RE_STARTED_LEGACY, this.entityID, -1L, null) == 0) {
                        this.reStartedEventSent = true;
                    }
                }
                if (this.startNotificationDetails != null && this.startNotificationDetails.getAffectedEntityTypes() != null && this.startNotificationDetails.getAffectedEntityTypes().getLong() != null && this.startNotificationDetails.getAffectedEntityTypes().getLong().contains(this.entityType)) {
                    LOGGER.info("Sending STARTUP event.");
                    if (this.reCore.sendEvent(EventType.GENERAL_EVENTTYPE_RE_START, this.entityID, -1L, null) == 0) {
                        this.reCore.sendLoggingEvent(EventType.GENERAL_EVENTTYPE_RE_START, this.entityID, 0, String.format("%s %s at [%s/%s]", new Object[]{ServiceTypes.valueOf((long)this.entityType).NAME(), MessageType.STARTED, Basic.getLocalHostName(), Basic.getLocalHostAddress()}), String.format("%s %s at [%s/%s]", new Object[]{ServiceTypes.valueOf((long)this.entityType).NAME(), MessageType.STARTED, Basic.getLocalHostName(), Basic.getLocalHostAddress()}), Level.OFF);
                        this.reStartedEventSent = true;
                    }
                } else {
                    LOGGER.warn("No notification settings found for start-up events OR explicitly disabled.");
                }
            }
            catch (Throwable ex) {
                LOGGER.warn("Cannot send STARTUP event.");
                this.reStartedEventSent = false;
            }
        }
    }

    public void sendStopEvent() {
        try {
            if (this.stopNotificationDetails != null && this.stopNotificationDetails.getAffectedEntityTypes() != null && this.stopNotificationDetails.getAffectedEntityTypes().getLong() != null && this.stopNotificationDetails.getAffectedEntityTypes().getLong().contains(this.entityType)) {
                LOGGER.info("Sending STOP event.");
                if (this.reCore.sendEvent(EventType.GENERAL_EVENTTYPE_RE_STOP, this.entityID, -1L, null) == 0) {
                    this.reCore.sendLoggingEvent(EventType.GENERAL_EVENTTYPE_RE_STOP, this.entityID, 0, String.format("%s %s at [%s/%s]", new Object[]{ServiceTypes.valueOf((long)this.entityType).NAME(), MessageType.STOPPED, Basic.getLocalHostName(), Basic.getLocalHostAddress()}), String.format("%s %s at [%s/%s]", new Object[]{ServiceTypes.valueOf((long)this.entityType).NAME(), MessageType.STOPPED, Basic.getLocalHostName(), Basic.getLocalHostAddress()}), Level.OFF);
                }
            } else {
                LOGGER.warn("No notification settings found for stop events OR explicitly disabled.");
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("Cannot send STOP event.");
        }
    }

    private static enum MessageType {
        STARTED,
        STOPPED;

    }
}

