/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FramerateChecker {
    private static final String CLASS_NAME = "de.seetec.v5.re.shared.FramerateChecker";
    private final Logger logger;
    private long milliFPS = 0L;
    private final long[] timestamps = new long[128];
    private int lastTimestamp = -1;

    public FramerateChecker() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(long milliFPS) {
        this.milliFPS = milliFPS;
        if (this.milliFPS < 0L) {
            return -21001;
        }
        return 0;
    }

    public void setFramerate(long milliFPS) {
        if (this.milliFPS != milliFPS) {
            this.lastTimestamp = -1;
        }
        this.milliFPS = milliFPS;
    }

    public boolean checkForFramerate(long timestamp) {
        long actualFramerate;
        long distance;
        long actualMilliFPS;
        if (this.lastTimestamp < 0) {
            this.timestamps[++this.lastTimestamp] = timestamp;
            return true;
        }
        if (this.milliFPS > 0L && this.lastTimestamp > this.timestamps.length && (actualMilliFPS = 1000000L / (distance = 1L + timestamp - this.timestamps[this.lastTimestamp % this.timestamps.length])) * 10L < this.milliFPS) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Big jitter, so discarding history of " + this + " ...");
            }
            this.lastTimestamp = -1;
            return false;
        }
        if (this.lastTimestamp >= 0 && (actualFramerate = 1000000L / (distance = 1L + timestamp - this.timestamps[this.lastTimestamp % this.timestamps.length])) > this.milliFPS * 2L) {
            return false;
        }
        long actualFramerate2 = this.lastTimestamp < this.timestamps.length ? (long)this.lastTimestamp * 1000000L / (1L + timestamp - this.timestamps[0]) : (long)this.timestamps.length * 1000000L / (1L + timestamp - this.timestamps[(this.lastTimestamp + 1) % this.timestamps.length]);
        if (actualFramerate2 > this.milliFPS * 11L / 10L) {
            return false;
        }
        this.timestamps[++this.lastTimestamp % this.timestamps.length] = timestamp;
        return true;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.shared.FramerateChecker@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", MilliFPS=[" + this.milliFPS + "]]";
    }
}

