/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.FramePart;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.JpegUtility;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Iterator;

class FramePartIterator
implements Iterator<FramePart> {
    private int positionInPart = -1;
    private byte[] fixedData = null;
    private long lastTimestamp = -1L;
    private final ContentFrame contentFrame;

    FramePartIterator(ContentFrame contentFrame) {
        this.contentFrame = contentFrame;
        this.fixedData = contentFrame.getData();
        this.positionInPart = 0;
    }

    @Override
    public boolean hasNext() {
        return this.positionInPart < this.fixedData.length || this.positionInPart == 0 && this.fixedData.length == 0;
    }

    @Override
    public FramePart next() {
        try {
            if (!this.hasNext()) {
                return null;
            }
            if (!this.contentFrame.isPacked()) {
                this.validateMediaFrameHeader();
                this.positionInPart = this.fixedData.length + 1;
                return new FramePart(this.contentFrame, 0L, this.fixedData);
            }
            long timestamp = Basic.byteArrayToInt8((byte[])this.fixedData, (int)this.positionInPart, (int)3);
            this.positionInPart += 3;
            int partSize = Basic.byteArrayToInt4((byte[])this.fixedData, (int)this.positionInPart, (int)3);
            this.positionInPart += 3;
            byte[] part = new byte[partSize];
            if (this.lastTimestamp < timestamp) {
                this.lastTimestamp = timestamp;
            } else {
                ++this.lastTimestamp;
                timestamp = this.lastTimestamp;
            }
            this.validateMediaFrameHeader();
            System.arraycopy(this.fixedData, this.positionInPart, part, 0, partSize);
            this.positionInPart += partSize;
            return new FramePart(this.contentFrame, timestamp, part);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private void validateMediaFrameHeader() throws SeeTecException {
        int mediaFrameHeader;
        if (this.contentFrame.isVideoFrame() && (mediaFrameHeader = Basic.byteArrayToInt4((byte[])this.fixedData, (int)this.positionInPart, (int)4)) != Basic.byteArrayToInt4((byte[])MediaFrame.MEDIA_FRAME_HEADER_MAGIC)) {
            if (this.IsOldSeetec5JpegFrame()) {
                return;
            }
            throw new SeeTecException(-21050, "Expected frame to start with MediaFrame.MEDIA_FRAME_HEADER_MAGIC: " + Basic.byteArrayToInt4((byte[])MediaFrame.MEDIA_FRAME_HEADER_MAGIC) + " but found " + mediaFrameHeader + " instead. Frame corrupt!" + this.contentFrame.toString());
        }
    }

    private boolean IsOldSeetec5JpegFrame() {
        byte[] jpegStartOfImage = JpegUtility.SOI;
        return this.fixedData[this.positionInPart] == jpegStartOfImage[0] && this.fixedData[this.positionInPart + 1] == jpegStartOfImage[1];
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported for " + this + " !");
    }
}

