/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import java.util.Date;

class FramePart {
    private final long timestamp;
    private final byte[] data;
    private final ContentFrame contentFrame;

    FramePart(ContentFrame contentFrame, long timestamp, byte[] data) {
        if (contentFrame == null) {
            throw new IllegalArgumentException("contentFrame is null");
        }
        this.contentFrame = contentFrame;
        this.timestamp = timestamp;
        this.data = data;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getAbsoluteTimestamp() {
        return this.contentFrame.getStartTimestamp() + this.timestamp;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return this.contentFrame.toString() + "[FramePart, Timestamp=[" + new Date(this.getAbsoluteTimestamp()) + "], FramePartSize=[" + Basic.longToFormattedString((long)this.data.length) + " b]]";
    }
}

