/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import java.util.Calendar;

class DayRange {
    private long[][] ranges = null;

    DayRange(long[][] nRanges) {
        this.ranges = nRanges;
    }

    public long[][] getRanges() {
        if (this.ranges == null || this.ranges.length <= 0) {
            return new long[0][0];
        }
        return this.ranges;
    }

    public long getExpirationTime(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        long millisecondsOfDay = (long)calendar.get(11) * 3600000L + (long)calendar.get(12) * 60000L + (long)calendar.get(13) * 1000L + (long)calendar.get(14);
        long expirationTime = millisecondsOfDay - 86400000L;
        for (long[] range : this.ranges) {
            long gap;
            long tsStart = range[0];
            long tsEnd = range[1];
            if (millisecondsOfDay >= tsStart && millisecondsOfDay < tsEnd) {
                expirationTime = tsEnd - millisecondsOfDay;
                break;
            }
            if (millisecondsOfDay >= tsEnd || (gap = -(tsStart - millisecondsOfDay)) <= expirationTime) continue;
            expirationTime = gap;
        }
        return expirationTime;
    }
}

