/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.TriggerActionHandler;
import de.seetec.v5.re.shared.srpc.AbstractSrpcHandler;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.net.srpc.general.ReqTriggerAction;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.util.SeeTecException;

public abstract class AbstractRuntimeEnvironmentSrpcHandler
extends AbstractSrpcHandler {
    protected abstract RECore getCore();

    protected final void execGetStatus(SrpcMessage req, RequestHandlerCallback callback) {
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(this.getCore().getRuntimeEnvironmentStatus().getStatus());
        callback.onRequestHandled(req, rsp);
    }

    protected final void execStartDevice(SrpcMessage req, RequestHandlerCallback callback) {
        int errorCode;
        GObject params = req.getPayload();
        long entityID = params.getChildAt(0).getAsLong();
        String entityName = params.getChildAt(1).getAsString();
        long entityType = params.getChildAt(2).getAsLong();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Starting device [" + entityID + "] ...");
        }
        if ((errorCode = this.getCore().startDevice(entityID, entityName, entityType)) != 0) {
            this.logger.warn("Starting device with id [" + entityID + "] failed with error [" + errorCode + "]");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    protected final void execStopDevice(SrpcMessage req, RequestHandlerCallback callback) {
        long entityID = req.getPayload().getAsLong();
        this.logger.info("Stopping device [" + entityID + "] ...");
        int errorCode = this.getCore().stopDevice(entityID);
        if (errorCode != 0) {
            this.logger.warn(String.format("Stopping device with id [%,d] failed with error [%s]", entityID, errorCode));
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    protected final void execNotify(SrpcMessage req, RequestHandlerCallback callback) {
        ReqNotify request = (ReqNotify)ReqNotify.parseGObject((GObject)req.getPayload());
        int errorCode = this.getCore().notify(request);
        if (errorCode != 0) {
            this.logger.warn("Notifying failed with error [" + errorCode + "]");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    protected final void execTriggerAction(SrpcMessage req, RequestHandlerCallback callback) {
        int errorCode = 0;
        ReqTriggerAction request = ReqTriggerAction.parseGObject((GObject)req.getPayload());
        try {
            TriggerActionHandler triggerActionHandler = new TriggerActionHandler(request, this.getCore());
            triggerActionHandler.init();
        }
        catch (SeeTecException seeTecException) {
            this.logger.warn("Problems initializing TriggerActionHandler for " + this, (Throwable)seeTecException);
            errorCode = seeTecException.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.warn("Problems initializing TriggerActionHandler for " + this, ex);
            errorCode = -20001;
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        callback.onRequestHandled(req, rsp);
    }

    @Override
    public void onError(int srpcErrorCode) {
        this.logger.error("SRPC error [" + srpcErrorCode + "] occured. Shutting down proxy ...");
        this.shutdown();
    }
}

