/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.util;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.configuration.workcentercalendar.WorkCenterCalendarConfiguration;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Calendar;
import java.util.Date;

public class WorkCenterCalendar {
    private final long id;
    private Date[][] holidays = null;

    public WorkCenterCalendar(long id) {
        this.id = id;
    }

    public void init(byte[] configuration) throws SeeTecException {
        this.processConfiguration(configuration);
    }

    private void processConfiguration(byte[] data) throws SeeTecException {
        if (data == null) {
            throw new SeeTecException(-20002, "Input is null.");
        }
        try {
            WorkCenterCalendarConfiguration configuration = Basic.unmarshalXML(WorkCenterCalendarConfiguration.class, data, true);
            if (configuration.getHolidays().isEmpty()) {
                this.holidays = new Date[0][0];
            } else {
                this.holidays = new Date[configuration.getHolidays().size()][2];
                for (int i = 0; i < configuration.getHolidays().size(); ++i) {
                    Integer nDaysSince1970 = configuration.getHolidays().get(i);
                    if (nDaysSince1970 == null) continue;
                    Calendar startOfRange = Calendar.getInstance();
                    startOfRange.set(1970, 0, nDaysSince1970, 24, 0, 0);
                    Calendar endOfRange = Calendar.getInstance();
                    endOfRange.set(1970, 0, nDaysSince1970, 48, 0, 0);
                    this.holidays[i][0] = startOfRange.getTime();
                    this.holidays[i][1] = endOfRange.getTime();
                }
            }
        }
        catch (Exception e) {
            throw new SeeTecException(-20000, "Error while reading configuration: " + e.getMessage());
        }
    }

    public boolean isHoliday(long timestamp) {
        Date date = new Date(timestamp);
        for (Date[] holiday : this.holidays) {
            if (!holiday[0].before(date) || !holiday[1].after(date)) continue;
            return true;
        }
        return false;
    }

    public long getId() {
        return this.id;
    }
}

