/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.util;

import de.seetec.v5.shared.SystemTimeProvider;
import org.apache.logging.log4j.Level;

public class AccumulatingLoggerContainer {
    private final SystemTimeProvider systemTimeProvider;
    private final long deadtime;
    private final Level logLevel;
    private long time;
    private long occurence;

    public AccumulatingLoggerContainer(SystemTimeProvider systemTimeProvider, Level logLevel, long deadtime) {
        this.systemTimeProvider = systemTimeProvider;
        this.logLevel = logLevel;
        this.deadtime = deadtime;
        this.time = Long.MIN_VALUE;
        this.occurence = 0L;
    }

    public long getTime() {
        return this.time;
    }

    public long getOccurence() {
        return this.occurence;
    }

    public void addOccurence() {
        ++this.occurence;
    }

    public void resetTimeAndOccurence() {
        this.time = this.systemTimeProvider.currentTimeMillis();
        this.occurence = 0L;
    }

    public boolean isDeadtimeOver() {
        return this.systemTimeProvider.currentTimeMillis() - this.getTime() > this.deadtime;
    }

    protected Level getLogLevel() {
        return this.logLevel;
    }
}

