/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.util;

import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.util.AccumulatingLoggerContainer;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class AccumulatingLogger {
    private static final int MAX_SESSIONS = 250;
    private final Map<String, AccumulatingLoggerContainer> logMessages;
    private final Logger logger;
    private final SystemTimeProvider systemTimeProvider;

    public AccumulatingLogger(Logger logger) {
        this(logger, new DefaultSystemTimeProvider());
    }

    protected AccumulatingLogger(Logger logger, SystemTimeProvider systemTimeProvider) {
        if (logger == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.logger = logger;
        this.systemTimeProvider = systemTimeProvider;
        this.logMessages = new LinkedHashMap<String, AccumulatingLoggerContainer>(){
            private static final long serialVersionUID = 8300976593414373625L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, AccumulatingLoggerContainer> eldest) {
                return this.size() > 250;
            }
        };
    }

    public void startSession(Level logLevel, long deadtimeInMs, String accumulationSpecifier) {
        if (logLevel == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (accumulationSpecifier == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.logMessages.put(accumulationSpecifier, new AccumulatingLoggerContainer(this.systemTimeProvider, logLevel, deadtimeInMs));
    }

    public void log(String accumulationSpecifier, String uniqueMessage) throws SeeTecException {
        this.log(accumulationSpecifier, uniqueMessage, null);
    }

    public void log(String accumulationSpecifier, String uniqueMessage, Exception exception) throws SeeTecException {
        if (accumulationSpecifier == null || uniqueMessage == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        if (!this.alreadyLogged(accumulationSpecifier)) {
            AccumulatingLoggerContainer accumulatingLoggerContainer = this.logMessages.get(accumulationSpecifier);
            if (exception != null) {
                this.logger.log(accumulatingLoggerContainer.getLogLevel(), this.buildLogMessage(new StringBuilder(uniqueMessage), accumulatingLoggerContainer), (Throwable)exception);
            } else {
                this.logger.log(accumulatingLoggerContainer.getLogLevel(), this.buildLogMessage(new StringBuilder(uniqueMessage), accumulatingLoggerContainer));
            }
            accumulatingLoggerContainer.resetTimeAndOccurence();
        }
    }

    private boolean alreadyLogged(String uniqueMessage) throws SeeTecException {
        boolean alreadyLogged;
        AccumulatingLoggerContainer accumulatingLoggerContainer = this.logMessages.get(uniqueMessage);
        if (accumulatingLoggerContainer == null) {
            throw new SeeTecException(-20000, "Session not started");
        }
        if (accumulatingLoggerContainer.getTime() == Long.MIN_VALUE) {
            accumulatingLoggerContainer.resetTimeAndOccurence();
            alreadyLogged = false;
        } else if (accumulatingLoggerContainer.isDeadtimeOver()) {
            alreadyLogged = false;
        } else {
            accumulatingLoggerContainer.addOccurence();
            alreadyLogged = true;
        }
        return alreadyLogged;
    }

    private String buildLogMessage(StringBuilder builder, AccumulatingLoggerContainer accumulatingLoggerContainer) {
        builder.append(" [");
        builder.append(accumulatingLoggerContainer.getOccurence());
        builder.append(" similar occurencies since ");
        builder.append(new Date(accumulatingLoggerContainer.getTime()));
        builder.append("]");
        return builder.toString();
    }
}

