/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.proxy.general;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.ProxyDefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.proxy.general.GeneralSRPCProxy;
import de.seetec.v5.shared.proxy.general.TriggerIntf;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneralProxy
extends Basic {
    private static final String CLASS_NAME = "de.seetec.v5.shared.proxy.general.GeneralProxy";
    private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private TriggerIntf srpcProxy = null;
    private final Object REQ_SEMAPHORE = new Object();
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public int init(String host, int port, long entityId) {
        long deadline = System.currentTimeMillis() + TIMEOUT;
        while (true) {
            if (System.currentTimeMillis() > deadline) {
                this.logger.error("Creating new connector failed :-(");
                return -20005;
            }
            try {
                this.srpcProxy = new GeneralSRPCProxy();
                if (this.srpcProxy.init(new ProxyDefaultRequestHandlerFactoryImpl(), host, port, entityId) == 0) {
                    break;
                }
            }
            catch (Exception ex) {
                this.logger.debug(ex.getMessage());
            }
            this.srpcProxy.shutdown();
            this.srpcProxy = null;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                this.logger.debug("Error while sleeping.");
            }
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.srpcProxy != null) {
            int errorCode = this.srpcProxy.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + this.srpcProxy + "] failed with error [" + errorCode + "] :-(");
            }
            this.srpcProxy = null;
        }
        return 0;
    }

    public void triggerAction(Long serviceId, Long entityId, Long alarmScriptId, Long eventId, Long alarmTimerange, byte[] genericData, long nTimeout) throws SeeTecException {
        this.triggerAction(serviceId, entityId, alarmScriptId, eventId, alarmTimerange, genericData, Long.MIN_VALUE, Long.MIN_VALUE, nTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerAction(Long serviceId, Long entityId, Long alarmScriptId, Long eventId, Long alarmTimerange, byte[] genericData, Long ptzPriority, Long ptzPriorityTimeout, long nTimeout) throws SeeTecException {
        Object object = this.REQ_SEMAPHORE;
        synchronized (object) {
            this.srpcProxy.TriggerAction(serviceId, entityId, alarmScriptId, eventId, alarmTimerange, genericData, ptzPriority, ptzPriorityTimeout);
        }
    }
}

