/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.proxy.ent;

import de.seetec.v5.shared.SmtpEncryptionMethod;
import de.seetec.v5.shared.TreeTypes;
import de.seetec.v5.shared.configuration.restrictedentity.RestrictedEntity;
import de.seetec.v5.shared.interaction.AuthorizedDataObject;
import de.seetec.v5.shared.interaction.DataObject;
import de.seetec.v5.shared.interaction.EntityDataObject;
import de.seetec.v5.shared.interaction.EventDataObject;
import de.seetec.v5.shared.interaction.GetAccessEntityDataObject;
import de.seetec.v5.shared.interaction.LicenseDataObject;
import de.seetec.v5.shared.interaction.ReTriggerDataObject;
import de.seetec.v5.shared.interaction.SecondIDDataObject;
import de.seetec.v5.shared.interaction.SyncBlobDataObject;
import de.seetec.v5.shared.interaction.SyncEntityDataObject;
import de.seetec.v5.shared.interaction.SyncLprAssociatedCamsDataObject;
import de.seetec.v5.shared.interaction.SyncLprEventDataObject;
import de.seetec.v5.shared.interaction.SyncLprHeaderDataObject;
import de.seetec.v5.shared.interaction.SyncLprMasterDataObject;
import de.seetec.v5.shared.interaction.SyncPasswordDataObject;
import de.seetec.v5.shared.interaction.SyncStatusDataObject;
import de.seetec.v5.shared.interaction.SyncStatusListConverter;
import de.seetec.v5.shared.interaction.ValueDataObject;
import de.seetec.v5.shared.interaction.VersionDataObject;
import de.seetec.v5.shared.net.srpc.ReqCoreAnnounce;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.net.srpc.ent.PingMethodWrapper;
import de.seetec.v5.shared.net.srpc.ent.RspDeliverTriggeredScenario;
import de.seetec.v5.shared.net.srpc.ent.RspGetEntitiesAsList;
import de.seetec.v5.shared.net.srpc.ent.RspGetEntitiesAsTree;
import de.seetec.v5.shared.net.srpc.ent.RspGetEvents;
import de.seetec.v5.shared.net.srpc.ent.RspGetOPCDataPoints;
import de.seetec.v5.shared.net.srpc.ent.RspGetTicket;
import de.seetec.v5.shared.net.srpc.ent.RspLocateEntitiesByType;
import de.seetec.v5.shared.net.srpc.ent.RspLocateEntityByID;
import de.seetec.v5.shared.net.srpc.ent.RspSyncBlob;
import de.seetec.v5.shared.net.srpc.ent.RspSyncPassword;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcDataType;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.ent.EntProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.proxy.ent.Ticket;
import de.seetec.v5.shared.proxy.shared.SRPCProxy;
import de.seetec.v5.shared.tree.Tree;
import de.seetec.v5.shared.util.SeeTecException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;

public class EntMgrSRPCProxy
extends SRPCProxy
implements EntProxy {
    private static final String CLASS_NAME = "de.seetec.v5.shared.proxy.ent.EntMgrSRPCProxy";

    public EntMgrSRPCProxy() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public boolean isReady() {
        if (this.isShutdown(CLASS_NAME)) {
            return false;
        }
        return super.isReady();
    }

    @Override
    public void SendTestTrap(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage response = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SEND_TEST_TRAP, null), timeout);
        if (null != response) {
            this.checkNonNullResponseForError(response);
        }
    }

    @Override
    public Entity Ping(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage response = this.sendRequest(PingMethodWrapper.createRequest(), timeout);
        return PingMethodWrapper.parseResponse(response.getPayload());
    }

    @Override
    public void Register(Long nEntityID, Long nEntityType, String sHost, Integer nPort, Long sessionID, Boolean directRegister, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject parameters = GObject.createList();
        parameters.addChild(nEntityID);
        parameters.addChild(nEntityType);
        parameters.addChild(sHost);
        parameters.addChild(nPort);
        parameters.addChild(sessionID);
        parameters.addChild(directRegister);
        SrpcMessage response = null;
        try {
            response = this.newSrpc.send(SrpcMessage.createRequest(Methods.ENT_FUNCTION_REGISTER, parameters), timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, "The Operation timed out.");
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != response) {
            this.checkNonNullResponseForError(response);
        }
    }

    @Override
    public void Deregister(Long nEntityID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage resp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_DEREGISTER, GObject.create(nEntityID)), timeout);
        if (null != resp) {
            this.checkNonNullResponseForError(resp);
        }
    }

    @Override
    public Location LocateEntityByID(Long nEntityID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_LOCATE_ENTITY_BY_ID, GObject.create(nEntityID));
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.fatal((Object)ex, (Throwable)ex);
        }
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        GObject resObj = rsp.getPayload();
        return RspLocateEntityByID.createResponseWrapper(resObj);
    }

    @Override
    public List<Location> LocateEntitiesByType(Long nEntityType, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_LOCATE_ENTITIES_BY_TYPE, GObject.create(nEntityType));
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
            return RspLocateEntitiesByType.createResponseWrapper(rsp.getPayload());
        }
        return null;
    }

    @Override
    public Ticket GetTicket(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_TICKET, null);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspGetTicket.createResponseWrapper(rsp.getPayload());
    }

    @Override
    public int GetIDOffset(long timeout) throws SeeTecException {
        return this.getIntValue(Methods.ENT_FUNCTION_GET_ID_OFFSET, timeout);
    }

    @Override
    public int GetUsedCameraLicenses(long timeout) throws SeeTecException {
        return this.getIntValue(Methods.ENT_FUNCTION_GET_USED_CAMERA_LICENSES, timeout);
    }

    @Override
    public LicenseDataObject GetLicense(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_LICENSE, null), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return LicenseDataObject.parseResponse(rsp.getPayload());
    }

    @Override
    public void SetLicense(byte[] license, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage response = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SET_LICENSE, GObject.create(license)), timeout);
        if (null != response) {
            this.checkNonNullResponseForError(response);
        }
    }

    @Override
    public String GetMachineID(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage response = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_MACHINE_ID, null), timeout);
        this.checkResponseForNull(response);
        this.checkNonNullResponseForError(response);
        return response.getPayload().getAsString();
    }

    @Override
    public void SetStatus(Long nEntityID, Integer nStatus, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(nEntityID);
        params.addChild(nStatus);
        SrpcMessage response = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SET_STATUS, params), timeout);
        this.checkResponseForNull(response);
        this.checkNonNullResponseForError(response);
    }

    @Override
    public void SetEntity(long nEntityID, String sEntityName, long nEntityType, Long nMID, boolean bActive, byte[] configuration, String description, Long physParent, Long physOrder, Long logParent, Long logOrder, String token, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        EntityDataObject entityToSet = new EntityDataObject(nEntityID, sEntityName, nEntityType, nMID == null ? Long.MIN_VALUE : nMID, bActive, configuration, description, null, physParent == null ? Long.MIN_VALUE : physParent, physOrder == null ? Long.MIN_VALUE : physOrder, logParent == null ? Long.MIN_VALUE : logParent, logOrder == null ? Long.MIN_VALUE : logOrder);
        SrpcMessage response = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SET_ENTITY, entityToSet.createGObjectWithoutStatusInformation(), token), timeout);
        this.checkResponseForNull(response);
        this.checkNonNullResponseForError(response);
    }

    @Override
    public Entity GetEntityByID(Long nEntityID, Boolean bExtend, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(nEntityID);
        params.addChild(bExtend);
        SrpcMessage response = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_ENTITY_BY_ID, params), timeout);
        this.checkResponseForNull(response);
        this.checkNonNullResponseForError(response);
        return Entity.parseGObject(response.getPayload());
    }

    @Override
    public Entity[] GetEntitiesAsList(List<Long> vEntityTypes, Boolean bExtent, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(GObject.fromListLong(vEntityTypes));
        params.addChild(bExtent);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_ENTITIES_AS_LIST, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspGetEntitiesAsList.createResponseWrapper(rsp.getPayload());
    }

    @Override
    public Tree<Entity> GetEntitiesAsTree(Long nEntityID, List<Long> vEntityTypes, Boolean bExtent, Integer nTreeType, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(nEntityID);
        if (null == vEntityTypes) {
            params.addChild(GObject.createNull(SrpcDataType.INT8_ARRAY));
        } else {
            params.addChild(GObject.fromListLong(vEntityTypes));
        }
        params.addChild(bExtent);
        params.addChild(nTreeType);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_ENTITIES_AS_TREE, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspGetEntitiesAsTree.createResponseWrapper(rsp.getPayload());
    }

    @Override
    public void DeleteEntity(Long nEntityID, long timeout, String token) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_DELETE_ENTITY, GObject.create(nEntityID), token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public void SetBlob(Long multimediaID, Long multimediaType, List<byte[]> vBlobData, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(multimediaID);
        params.addChild(multimediaType);
        GObject blobs = GObject.createList();
        vBlobData.stream().forEach(blob -> blobs.addChild((byte[])blob));
        params.addChild(blobs);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SET_BLOB, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public void DeleteBlob(Long nMID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_DELETE_BLOB, GObject.create(nMID)), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public void StartBackup(String pathForBackup, String nameForBackup, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(pathForBackup);
        params.addChild(nameForBackup);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_START_BACKUP, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public VersionDataObject GetVersion(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_VERSION, null), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return VersionDataObject.parseResponse(rsp.getPayload());
    }

    @Override
    public void SendTestMail(String smtpHost, Integer smtpPort, SmtpEncryptionMethod encryptionMethod, String user, String password, String sender, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(smtpHost);
        params.addChild(smtpPort);
        params.addChild(encryptionMethod.value());
        params.addChild(user);
        params.addChild(password);
        params.addChild(sender);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SEND_TEST_MAIL, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public List<ReTriggerDataObject> DeliverTriggeredScenario(Long profile, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_DELIVER_TRIGGERED_SCENARIO, GObject.create(profile)), timeout);
        this.checkResponseForNull(rsp);
        return RspDeliverTriggeredScenario.createResponseWrapper(rsp.getPayload());
    }

    @Override
    public String GetSalt(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_SALT, null), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return rsp.getPayload().getAsString();
    }

    @Override
    public void SyncLprEvent(List<SyncLprEventDataObject> events, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        if (null != events) {
            events.stream().forEach(evt -> params.addChild(evt.toGObject()));
        }
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_LPR_EVENT, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public List<SyncBlobDataObject> SyncBlob(Long ETYID, Long syncID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(ETYID);
        params.addChild(syncID);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_BLOB, params);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
            return RspSyncBlob.createResponseWrapper(rsp.getPayload());
        }
        return null;
    }

    @Override
    public List<SyncEntityDataObject> SyncEntity(Long ETYID, Long syncID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(ETYID);
        params.addChild(syncID);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_ENTITY, params);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
            return SyncEntityDataObject.parseGObject(rsp.getPayload());
        }
        return null;
    }

    @Override
    public List<SyncPasswordDataObject> SyncPassword(Long ETYID, Long syncID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(ETYID);
        params.addChild(syncID);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_PASSWORD, params);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
            return RspSyncPassword.createResponseWrapper(rsp.getPayload());
        }
        return null;
    }

    @Override
    public void SyncEvent(List<EventDataObject> eventList, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        if (eventList != null) {
            for (EventDataObject event : eventList) {
                GObject singleEvent = GObject.createList();
                singleEvent.addChild(event.getEID());
                singleEvent.addChild(event.getETID());
                singleEvent.addChild(event.getSID());
                singleEvent.addChild(event.getCID());
                singleEvent.addChild(event.getTime());
                singleEvent.addChild(event.getData());
                params.addChild(singleEvent);
            }
        }
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_EVENT, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public List<SyncLprHeaderDataObject> SyncLprHeaderData(Long ETYID, Long syncID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        ArrayList<SyncLprHeaderDataObject> result = null;
        GObject params = GObject.createList();
        params.addChild(ETYID);
        params.addChild(syncID);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_LPR_HEADER_DATA, params);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
            result = new ArrayList<SyncLprHeaderDataObject>();
            Iterator<GObject> itr = rsp.getPayload().getChildren().iterator();
            while (itr.hasNext()) {
                SyncLprHeaderDataObject element = SyncLprHeaderDataObject.fromGObject(itr.next());
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public List<SyncLprMasterDataObject> SyncLprMasterData(Long ETYID, Long syncID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        ArrayList<SyncLprMasterDataObject> result = null;
        GObject params = GObject.createList();
        params.addChild(ETYID);
        params.addChild(syncID);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_LPR_MASTER_DATA, params);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
            result = new ArrayList<SyncLprMasterDataObject>();
            Iterator<GObject> itr = rsp.getPayload().getChildren().iterator();
            while (itr.hasNext()) {
                SyncLprMasterDataObject element = SyncLprMasterDataObject.fromGObject(itr.next());
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public List<SyncLprAssociatedCamsDataObject> SyncLprAssociatedCamsData(Long ETYID, Long syncID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        ArrayList<SyncLprAssociatedCamsDataObject> result = null;
        GObject params = GObject.createList();
        params.addChild(ETYID);
        params.addChild(syncID);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_LPR_ASSOCIATED_CAMS, params);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
            result = new ArrayList<SyncLprAssociatedCamsDataObject>();
            Iterator<GObject> itr = rsp.getPayload().getChildren().iterator();
            while (itr.hasNext()) {
                SyncLprAssociatedCamsDataObject element = SyncLprAssociatedCamsDataObject.fromGObject(itr.next());
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public List<SyncStatusDataObject> SyncStatus(List<SyncStatusDataObject> syncStatusDataObject, boolean newlyStarted, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(SyncStatusListConverter.toGObject(syncStatusDataObject));
        params.addChild(newlyStarted);
        SrpcMessage req = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SYNC_STATUS, params);
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, timeout);
        }
        catch (TimeoutException tex) {
            throw new SeeTecException(-20203, tex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        if (rsp != null) {
            this.checkNonNullResponseForError(rsp);
            return SyncStatusListConverter.fromGObject(rsp.getPayload());
        }
        return null;
    }

    @Override
    public long IsAuthorized(String user, String password, String password2, String adIP, long timeout) throws SeeTecException {
        return this._IsAuthorized(user, password, password2, adIP, timeout).getID();
    }

    @Override
    public AuthorizedDataObject IsAuthorized(String user, String password, String password2, long timeout) throws SeeTecException {
        return this._IsAuthorized(user, password, password2, null, timeout);
    }

    public AuthorizedDataObject _IsAuthorized(String user, String password, String password2, String adIP, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(user);
        params.addChild(password);
        params.addChild(password2);
        params.addChild(adIP);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_IS_AUTHORIZED, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        if (rsp.getPayload().getChildren() == null) {
            return new AuthorizedDataObject(rsp.getPayload().getAsLong());
        }
        AuthorizedDataObject authorizedDataObject = new AuthorizedDataObject(rsp.getPayload().getChildAt(0).getAsLong());
        authorizedDataObject.setToken(rsp.getPayload().getChildAt(1).getAsString());
        return authorizedDataObject;
    }

    @Override
    public void SetPassword(Long USRID, String password, String password2, String token, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(GObject.createNull(SrpcDataType.STRING));
        params.addChild(USRID);
        params.addChild(password);
        params.addChild(password2);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SET_PASSWORD, params, token), timeout);
        if (null != rsp) {
            this.checkNonNullResponseForError(rsp);
        }
    }

    public byte[] GetDefinitions(String fingerprint, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.create(fingerprint);
        SrpcMessage response = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_DEFINITIONS, params), timeout);
        this.checkResponseForNull(response);
        this.checkNonNullResponseForError(response);
        return response.getPayload().tryGetAsArrayOfByte();
    }

    @Override
    public int Subscribe(Long ETYID, Long profile, Integer clientLicenceType, List<Long> vEventTypes, Boolean isAnywhereClient, String user, List<Long> branchIds) throws SeeTecException {
        this.ensureSrpc(30000L);
        GObject goRequest = GObject.createList();
        goRequest.addChild(ETYID);
        goRequest.addChild(profile);
        goRequest.addChild(clientLicenceType);
        goRequest.addChild(GObject.fromListLong(vEventTypes));
        goRequest.addChild(isAnywhereClient);
        goRequest.addChild(user);
        goRequest.addChild(GObject.fromListLong(branchIds));
        SrpcMessage request = SrpcMessage.createRequest(Methods.ENT_FUNCTION_SUBSCRIBE, goRequest);
        SrpcMessage response = null;
        try {
            response = this.newSrpc.send(request);
        }
        catch (InterruptedException | ExecutionException ex) {
            this.logger.error("Cannot execute [" + request.getMethodName() + "]!", (Throwable)ex);
            return -20000;
        }
        return response.getError();
    }

    @Override
    public void Announce(Long EID, Long ETID, Long SID, Long CID, Long time, byte[] data) throws SeeTecException {
        this.ensureSrpc(30000L);
        SrpcMessage request = SrpcMessage.createRequest(Methods.ENT_FUNCTION_ANNOUNCE, new ReqNotify(EID, ETID, SID, CID, time, data).createGObject());
        this.newSrpc.sendFireAndForget(request);
    }

    @Override
    public void CoreAnnounce(Long EID, Long ETID, Long SID, Long CID, Long time, Long forwardedBy, byte[] data) throws SeeTecException {
        this.ensureSrpc(30000L);
        SrpcMessage request = SrpcMessage.createRequest(Methods.ENT_FUNCTION_CORE_ANNOUNCE, new ReqCoreAnnounce(EID, ETID, SID, CID, time, forwardedBy, data).createGObject());
        this.newSrpc.sendFireAndForget(request);
    }

    @Override
    public void DeleteEvents(Long olderThan, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(GObject.createNull(SrpcDataType.INT8));
        params.addChild(olderThan);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_DELETE_EVENTS, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public List<EventDataObject> GetEvents(List<Long> vEID, List<Long> vETID, List<Long> vSID, List<Long> vCID, List<Long> classifications, Long start, Long stop, Integer limit, String pattern, long timeout) throws SeeTecException {
        return this.GetEventBuilder(vEID, vETID, vSID, vCID, classifications, start, stop, limit, pattern, timeout, Methods.ENT_FUNCTION_GET_EVENTS);
    }

    @Override
    public List<EventDataObject> GetEventSlices(List<Long> vEID, List<Long> vETID, List<Long> vSID, List<Long> vCID, List<Long> classifications, Long start, Long stop, Integer limit, String pattern, long timeout) throws SeeTecException {
        return this.GetEventBuilder(vEID, vETID, vSID, vCID, classifications, start, stop, limit, pattern, timeout, Methods.ENT_FUNCTION_GET_EVENT_SLICES);
    }

    private List<EventDataObject> GetEventBuilder(List<Long> vEID, List<Long> vETID, List<Long> vSID, List<Long> vCID, List<Long> classifications, Long start, Long stop, Integer limit, String pattern, long timeout, Methods methodToUse) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(GObject.fromListLong(vEID));
        params.addChild(GObject.fromListLong(vETID));
        params.addChild(GObject.fromListLong(vSID));
        params.addChild(GObject.fromListLong(vCID));
        params.addChild(GObject.fromListLong(classifications));
        params.addChild(start);
        params.addChild(stop);
        params.addChild(limit);
        params.addChild(pattern);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(methodToUse, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspGetEvents.createResponseWrapper(rsp.getPayload());
    }

    @Override
    public DataObject handleLprUpdate(String sql, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_LPR_EXECUTE_UPDATE, GObject.create(sql)), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return new ValueDataObject<GObject>(rsp.getPayload());
    }

    @Override
    public DataObject handleLprQuery(String query, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_LPR_EXECUTE_QUERY, GObject.create(query)), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return new ValueDataObject<GObject>(rsp.getPayload());
    }

    @Override
    public int deleteSingleEvent(long eventID, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.DELETE_SINGLE_EVENT, GObject.create(eventID)), timeout);
        this.checkResponseForNull(rsp);
        return rsp.getError();
    }

    @Override
    public List<EventDataObject> GetOPCDataPoints(long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_OPC_DATAPOINTS, null), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspGetOPCDataPoints.createResponseWrapper(rsp.getPayload());
    }

    @Override
    public List<DataObject> BulkSetEntity(List<EntityDataObject> entitiesToSet, long timeout, String token) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        if (entitiesToSet != null) {
            entitiesToSet.stream().forEach(singleEntity -> params.addChild(singleEntity.createGObjectWithoutStatusInformation()));
        }
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_BULK_SET_ENTITY, params, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return this.getErrorCodeList(rsp.getPayload().getChildren());
    }

    private List<DataObject> getErrorCodeList(List<GObject> errorCodes) {
        ArrayList<DataObject> result = new ArrayList<DataObject>();
        if (null != errorCodes) {
            for (GObject go : errorCodes) {
                if (null == go) continue;
                DataObject entity = new DataObject();
                entity.setErrorCode(go.getAsInt());
                result.add(entity);
            }
        }
        return result;
    }

    @Override
    public void RearrangeChildren(List<Long> IDs, TreeTypes treeType, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        params.addChild(GObject.fromListLong(IDs));
        params.addChild(treeType.getType());
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_REARRANGE_CHILDREN, params), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public List<SecondIDDataObject> CreateSharedEntities(List<Long> entitiesToShare, List<Long> receivers, long startAt, long stopAt, String token, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject children = GObject.createList();
        children.addChild(GObject.fromListLong(entitiesToShare));
        children.addChild(GObject.fromListLong(receivers));
        children.addChild(startAt);
        children.addChild(stopAt);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_CREATE_SHARED_ENTITIES, children, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return this.getErrorInformationList(rsp.getPayload().getChildren());
    }

    @Override
    public List<SecondIDDataObject> CreateRestrictedEntities(List<Long> entitiesToRestrict, List<Long> receivers, long startRestrictionAt, long stopRestrictionAt, String token, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject children = GObject.createList();
        children.addChild(GObject.fromListLong(entitiesToRestrict));
        children.addChild(GObject.fromListLong(receivers));
        children.addChild(startRestrictionAt);
        children.addChild(stopRestrictionAt);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_CREATE_RESTRICTED_ENTITIES, children, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return this.getErrorInformationList(rsp.getPayload().getChildren());
    }

    @Override
    public void SetPersonalLayer(EntityDataObject entityDataObject, long timeout, String token) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = entityDataObject.createGObjectWithoutStatusInformation();
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_SET_PERSONAL_LAYER, params, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public void DeletePersonalLayer(Long entityId, long timeout, String token) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_DELETE_PERSONAL_LAYER, GObject.create(entityId), token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public List<GetAccessEntityDataObject<RestrictedEntity>> GetRestrictedEntities(long timeout, String token) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_GET_RESTRICTED_ENTITIES, null, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return this.getRestrictedEntitiesList(rsp.getPayload().getChildren());
    }

    private List<SecondIDDataObject> getErrorInformationList(List<GObject> errorCodes) {
        ArrayList<SecondIDDataObject> result = new ArrayList<SecondIDDataObject>();
        if (null != errorCodes) {
            for (GObject go : errorCodes) {
                if (null == go) continue;
                SecondIDDataObject entity = new SecondIDDataObject();
                entity.setErrorCode(go.getChildAt(0).getAsInt());
                entity.setID(go.getChildAt(1).getAsLong());
                entity.setSecondID(go.getChildAt(2).getAsLong());
                result.add(entity);
            }
        }
        return result;
    }

    private List<GetAccessEntityDataObject<RestrictedEntity>> getRestrictedEntitiesList(List<GObject> restrictedEntitiesGObject) {
        ArrayList<GetAccessEntityDataObject<RestrictedEntity>> result = new ArrayList<GetAccessEntityDataObject<RestrictedEntity>>();
        if (restrictedEntitiesGObject == null) {
            return result;
        }
        for (GObject getRestrictedEntityDataObjectGobject : restrictedEntitiesGObject) {
            if (getRestrictedEntityDataObjectGobject == null) continue;
            ArrayList<RestrictedEntity> restrictedEntities = new ArrayList<RestrictedEntity>();
            long entityId = Long.MIN_VALUE;
            List<GObject> rangesGObject = getRestrictedEntityDataObjectGobject.getChildAt(1).getChildren();
            for (GObject range : rangesGObject) {
                RestrictedEntity restrictedEntity = new RestrictedEntity();
                restrictedEntity.setEntityId(getRestrictedEntityDataObjectGobject.getChildAt(0).getAsLong());
                restrictedEntity.setStart(range.getChildAt(0).getAsLong());
                restrictedEntity.setStop(range.getChildAt(1).getAsLong());
                entityId = restrictedEntity.getEntityId();
                restrictedEntities.add(restrictedEntity);
            }
            GetAccessEntityDataObject getRestrictedEntityDataObject = new GetAccessEntityDataObject(entityId, restrictedEntities);
            result.add(getRestrictedEntityDataObject);
        }
        return result;
    }

    @Override
    public void EditSharedEntity(long sharedFor, long sharingId, long start, long stop, String token, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject children = GObject.createList();
        children.addChild(sharedFor);
        children.addChild(sharingId);
        children.addChild(start);
        children.addChild(stop);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_EDIT_SHARED_ENTITY, children, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    @Override
    public void EditRestrictedEntity(long restricedFor, long restrictionId, long start, long stop, String token, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject children = GObject.createList();
        children.addChild(restricedFor);
        children.addChild(restrictionId);
        children.addChild(start);
        children.addChild(stop);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_EDIT_RESTRICTED_ENTITY, children, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
    }

    public String refreshToken(String token, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        GObject params = GObject.createList();
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(Methods.ENT_FUNCTION_REFRESH_TOKEN, params, token), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        if (rsp.getPayload().getChildren() == null) {
            byte[] tokenData = rsp.getPayload().getAsArrayOfByte();
            return new String(tokenData, StandardCharsets.UTF_8);
        }
        byte[] tokenData = rsp.getPayload().getChildAt(0).getAsArrayOfByte();
        return new String(tokenData, StandardCharsets.UTF_8);
    }

    private int getIntValue(Methods method, long timeout) throws SeeTecException {
        this.ensureSrpc(timeout);
        SrpcMessage rsp = this.sendRequest(SrpcMessage.createRequest(method, null), timeout);
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return rsp.getPayload().getAsInt();
    }
}

