/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.proxy.ent;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.ClientType;
import de.seetec.v5.shared.SmtpEncryptionMethod;
import de.seetec.v5.shared.TreeTypes;
import de.seetec.v5.shared.configuration.restrictedentity.RestrictedEntity;
import de.seetec.v5.shared.interaction.AuthorizedDataObject;
import de.seetec.v5.shared.interaction.DataObject;
import de.seetec.v5.shared.interaction.EntityDataObject;
import de.seetec.v5.shared.interaction.EventDataObject;
import de.seetec.v5.shared.interaction.GetAccessEntityDataObject;
import de.seetec.v5.shared.interaction.LicenseDataObject;
import de.seetec.v5.shared.interaction.ReTriggerDataObject;
import de.seetec.v5.shared.interaction.SecondIDDataObject;
import de.seetec.v5.shared.interaction.StringDataObject;
import de.seetec.v5.shared.interaction.SyncBlobDataObject;
import de.seetec.v5.shared.interaction.SyncEntityDataObject;
import de.seetec.v5.shared.interaction.SyncLprAssociatedCamsDataObject;
import de.seetec.v5.shared.interaction.SyncLprEventDataObject;
import de.seetec.v5.shared.interaction.SyncLprHeaderDataObject;
import de.seetec.v5.shared.interaction.SyncLprMasterDataObject;
import de.seetec.v5.shared.interaction.SyncPasswordDataObject;
import de.seetec.v5.shared.interaction.SyncStatusDataObject;
import de.seetec.v5.shared.interaction.VersionDataObject;
import de.seetec.v5.shared.networking.srpc.ProxyDefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.proxy.ent.EntMgrSRPCProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.proxy.ent.Ticket;
import de.seetec.v5.shared.tree.Tree;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntMgrProxy
extends Basic {
    public static final int ERR_EMP_INITIALIZING_FAILED = -20410;
    private static final String CLASS_NAME = "de.seetec.v5.shared.proxy.ent.EntMgrProxy";
    private EntMgrSRPCProxy srpcProxy = null;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public int init(String host, int port, long timeout) {
        return this.init(host, port, 2L, timeout);
    }

    public int init(String host, int port, long id, long timeout) {
        int errorCode = 0;
        if (host == null || host.trim().length() <= 0 || port < 0 || port > 65535) {
            this.logger.error("Network parameter [" + host + ":" + port + "] not valid!");
            return -20002;
        }
        if (timeout < 0L) {
            timeout = 120000L;
        }
        long deadtime = System.currentTimeMillis() + timeout;
        while (true) {
            block11: {
                if (System.currentTimeMillis() > deadtime) {
                    this.logger.error("Creating new connector at [" + host + ":" + port + "] failed");
                    return -20410;
                }
                try {
                    this.srpcProxy = new EntMgrSRPCProxy();
                    errorCode = this.srpcProxy.init(new ProxyDefaultRequestHandlerFactoryImpl(), host, port, id);
                    if (errorCode == 0) {
                        this.ping(2000L);
                        break;
                    }
                }
                catch (SeeTecException srpcex) {
                    if (srpcex.getErrorCode() == -20231 || srpcex.getErrorCode() == -20232) {
                        this.logger.warn("Key not valid anymore.");
                        return srpcex.getErrorCode();
                    }
                    errorCode = srpcex.getErrorCode();
                }
                catch (Exception ex) {
                    if (!this.logger.isDebugEnabled()) break block11;
                    this.logger.info(ex.getMessage());
                }
            }
            this.srpcProxy.shutdown();
            this.srpcProxy = null;
            this.logger.warn("Creating [EntMgrSRPCProxy] at [" + host + ":" + port + "] failed for " + this + ". ErrorCode: " + errorCode);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.srpcProxy != null) {
            int errorCode = this.srpcProxy.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + this.srpcProxy + "] failed with error [" + errorCode + "]");
            }
            this.srpcProxy = null;
        }
        return 0;
    }

    public boolean isReady() {
        return this.isShutdown() ? false : this.srpcProxy.isReady();
    }

    public Entity ping(long timeout) throws SeeTecException {
        return this.srpcProxy.Ping(timeout);
    }

    public void registerEntity(Long entityId, Long entityType, String host, Integer port, Long sessionID, long timeout) throws SeeTecException {
        this.registerEntity(entityId, entityType, host, port, sessionID, true, timeout);
    }

    public void registerEntity(Long entityID, Long entityType, String host, Integer port, Long sessionID, boolean directRegister, long timeout) throws SeeTecException {
        this.srpcProxy.Register(entityID, entityType, host, port, sessionID, directRegister, timeout);
    }

    public void deregisterEntity(Long entityID, long timeout) throws SeeTecException {
        this.srpcProxy.Deregister(entityID, timeout);
    }

    public Location locateEntityByID(Long entityID, long timeout) throws SeeTecException {
        return this.srpcProxy.LocateEntityByID(entityID, timeout);
    }

    public List<Location> locateEntitiesByType(Long entityID, long timeout) throws SeeTecException {
        return this.srpcProxy.LocateEntitiesByType(entityID, timeout);
    }

    public Ticket getTicket(long timeout) throws SeeTecException {
        return this.srpcProxy.GetTicket(timeout);
    }

    public Integer getIDOffset(long timeout) throws SeeTecException {
        return this.srpcProxy.GetIDOffset(timeout);
    }

    public Integer getUsedCameraLicenses(long timeout) throws SeeTecException {
        return this.srpcProxy.GetUsedCameraLicenses(timeout);
    }

    public LicenseDataObject getLicense(long timeout) throws SeeTecException {
        return this.srpcProxy.GetLicense(timeout);
    }

    public String getMachineID(long timeout) throws SeeTecException {
        return this.srpcProxy.GetMachineID(timeout);
    }

    public void setStatus(Long entityID, Integer status, long timeout) throws SeeTecException {
        this.srpcProxy.SetStatus(entityID, status, timeout);
    }

    public int setEntity(Long entityID, String entityName, Long entityType, Long mId, Boolean active, byte[] configuration, String description, Long physParent, Long physOrder, Long logParent, Long logOrder, String token, long timeout) {
        try {
            this.srpcProxy.SetEntity(entityID, entityName, entityType, mId, active, configuration, description, physParent, physOrder, logParent, logOrder, token, timeout);
        }
        catch (SeeTecException stex) {
            this.logger.error((Object)stex, (Throwable)stex);
            return stex.getErrorCode();
        }
        return 0;
    }

    public int setEntity(Entity entity, String tokem, long timeout) {
        return this.setEntity(entity.getEntityID(), entity.getEntityName(), entity.getEntityType(), entity.getMID(), entity.isEnabled(), entity.getConfiguration(), entity.getDescription(), entity.getPhysicalParent(), entity.getPhysicalOrder(), entity.getLogicalParent(), entity.getLogicalOrder(), tokem, timeout);
    }

    public Entity getEntityByID(Long entityID, Boolean extend, long timeout) throws SeeTecException {
        return this.srpcProxy.GetEntityByID(entityID, extend, timeout);
    }

    public Entity[] getEntitiesAsList(List<Long> entityTypes, Boolean extent, long timeout) throws SeeTecException {
        return this.srpcProxy.GetEntitiesAsList(entityTypes, extent, timeout);
    }

    public Tree<Entity> getEntitiesAsTree(Long entryID, List<Long> entityTypes, Boolean extent, Integer treeType, long timeout) throws SeeTecException {
        return this.srpcProxy.GetEntitiesAsTree(entryID, entityTypes, extent, treeType, timeout);
    }

    public String refreshToken(String token, long timeout) throws SeeTecException {
        return this.srpcProxy.refreshToken(token, timeout);
    }

    public int deleteEntity(Long entityID, long timeout, String token) {
        try {
            this.srpcProxy.DeleteEntity(entityID, timeout, token);
        }
        catch (SeeTecException stex) {
            this.logger.error((Object)stex, (Throwable)stex);
            return stex.getErrorCode();
        }
        return 0;
    }

    public void setBlob(Long mid, Long type, List<byte[]> blobs, long timeout) throws SeeTecException {
        this.srpcProxy.SetBlob(mid, type, blobs, timeout);
    }

    public void deleteBlob(Long mid, long timeout) throws SeeTecException {
        this.srpcProxy.DeleteBlob(mid, timeout);
    }

    public void startBackup(String path, String name, long timeout) throws SeeTecException {
        this.srpcProxy.StartBackup(path, name, timeout);
    }

    public void setLicense(byte[] license, long timeout) throws SeeTecException {
        this.srpcProxy.SetLicense(license, timeout);
    }

    public void sendTestMail(String smtp, Integer smtpPort, SmtpEncryptionMethod encryptionMethod, String user, String pwd, String sender, long timeout) throws SeeTecException {
        this.srpcProxy.SendTestMail(smtp, smtpPort, encryptionMethod, user, pwd, sender, timeout);
    }

    public void sendTestTrap(long timeout) throws SeeTecException {
        this.srpcProxy.SendTestTrap(timeout);
    }

    public List<ReTriggerDataObject> deliverTriggeredScenario(Long profile, long timeout) throws SeeTecException {
        return this.srpcProxy.DeliverTriggeredScenario(profile, timeout);
    }

    public VersionDataObject GetVersion(long timeout) throws SeeTecException {
        return this.srpcProxy.GetVersion(timeout);
    }

    public String getSalt(long timeout) throws SeeTecException {
        return this.srpcProxy.GetSalt(timeout);
    }

    public Long isAuthorized(String user, String password, String password2, String adIP, long timeout) throws SeeTecException {
        return this.srpcProxy.IsAuthorized(user, password, password2, adIP, timeout);
    }

    public AuthorizedDataObject isAuthorized(String user, String password, String password2, long timeout) throws SeeTecException {
        return this.srpcProxy.IsAuthorized(user, password, password2, timeout);
    }

    public void setPassword(Long userId, String password, String password2, String token, long timeout) throws SeeTecException {
        this.srpcProxy.SetPassword(userId, password, password2, token, timeout);
    }

    public byte[] getDefinitions(String fingerprint, long timeout) throws SeeTecException {
        return this.srpcProxy.GetDefinitions(fingerprint, timeout);
    }

    public List<SyncBlobDataObject> syncBlob(long etyid, long syncID, long timeout) throws SeeTecException {
        return this.srpcProxy.SyncBlob(etyid, syncID, timeout);
    }

    public List<SyncEntityDataObject> syncEntity(long etyid, long syncID, long timeout) throws SeeTecException {
        return this.srpcProxy.SyncEntity(etyid, syncID, timeout);
    }

    public List<SyncPasswordDataObject> syncPassword(long etyid, long syncID, long timeout) throws SeeTecException {
        return this.srpcProxy.SyncPassword(etyid, syncID, timeout);
    }

    public void syncEvent(List<EventDataObject> eventList, long timeout) throws SeeTecException {
        this.srpcProxy.SyncEvent(eventList, timeout);
    }

    public int syncLprEvent(List<SyncLprEventDataObject> eventList, long timeout) throws SeeTecException {
        int result = 0;
        try {
            this.srpcProxy.SyncLprEvent(eventList, timeout);
        }
        catch (SeeTecException stex) {
            result = stex.getErrorCode();
        }
        return result;
    }

    public List<SyncLprHeaderDataObject> syncLprHeaderData(long etyid, long syncID, long timeout) throws SeeTecException {
        return this.srpcProxy.SyncLprHeaderData(etyid, syncID, timeout);
    }

    public List<SyncLprMasterDataObject> syncLprMasterData(long etyid, long syncID, long timeout) throws SeeTecException {
        return this.srpcProxy.SyncLprMasterData(etyid, syncID, timeout);
    }

    public List<SyncLprAssociatedCamsDataObject> syncLprAssociatedCamsData(long etyid, long syncID, long timeout) throws SeeTecException {
        return this.srpcProxy.SyncLprAssociatedCamsData(etyid, syncID, timeout);
    }

    public List<SyncStatusDataObject> syncStatus(List<SyncStatusDataObject> statusList, boolean newlyStarted, long timeout) throws SeeTecException {
        return this.srpcProxy.SyncStatus(statusList, newlyStarted, timeout);
    }

    public int subscribe(Long etyId, List<Long> eventTypes, List<Long> branchIds, long timeout) throws SeeTecException {
        return this.subscribe(etyId, null, eventTypes, branchIds, timeout);
    }

    public int subscribe(Long etyId, ClientType clientType, List<Long> eventTypes, List<Long> branchIds, long timeout) throws SeeTecException {
        return this.srpcProxy.Subscribe(etyId, null, clientType != null ? Integer.valueOf(clientType.getType()) : null, eventTypes, false, null, branchIds);
    }

    public void announce(Long EID, Long ETID, Long SID, Long CID, Long time, byte[] data, long timeout) throws SeeTecException {
        this.srpcProxy.Announce(EID, ETID, SID, CID, time, data);
    }

    public void coreAnnounce(Long EID, Long ETID, Long SID, Long CID, Long time, Long forwardedBy, byte[] data, long timeout) throws SeeTecException {
        this.srpcProxy.CoreAnnounce(EID, ETID, SID, CID, time, forwardedBy, data);
    }

    public List<EventDataObject> getEvents(List<Long> eIds, List<Long> etIds, List<Long> sIds, List<Long> cIds, List<Long> classifications, Long start, Long stop, Integer limit, String pattern, long timeout) throws SeeTecException {
        return this.srpcProxy.GetEvents(eIds, etIds, sIds, cIds, classifications, start, stop, limit, pattern, timeout);
    }

    public List<EventDataObject> getEventSlices(List<Long> eIds, List<Long> etIds, List<Long> sIds, List<Long> cIds, List<Long> classifications, Long start, Long stop, Integer limit, String pattern, long timeout) throws SeeTecException {
        return this.srpcProxy.GetEventSlices(eIds, etIds, sIds, cIds, classifications, start, stop, limit, pattern, timeout);
    }

    public void deleteEvents(Long olderThan, long timeout) throws SeeTecException {
        this.srpcProxy.DeleteEvents(olderThan, timeout);
    }

    public DataObject handleLprUpdate(String sql, long timeout) {
        try {
            return this.srpcProxy.handleLprUpdate(sql, timeout);
        }
        catch (SeeTecException stex) {
            return new DataObject(stex.getErrorCode());
        }
    }

    public DataObject handleLprQuery(StringDataObject req, long timeout) {
        try {
            return this.srpcProxy.handleLprQuery(req.getString(), timeout);
        }
        catch (SeeTecException stex) {
            return new DataObject(stex.getErrorCode());
        }
    }

    public void deleteSingleEvent(long eventID, long timeout) throws SeeTecException {
        this.srpcProxy.deleteSingleEvent(eventID, timeout);
    }

    public List<EventDataObject> getOPCDataPoints(long timeout) throws SeeTecException {
        return this.srpcProxy.GetOPCDataPoints(timeout);
    }

    public List<DataObject> bulkSetEntity(List<EntityDataObject> entitiesToSet, long timeout, String token) throws SeeTecException {
        return this.srpcProxy.BulkSetEntity(entitiesToSet, timeout, token);
    }

    public void rearrangeChildren(List<Long> ids, TreeTypes treeType, long timeout) throws SeeTecException {
        this.srpcProxy.RearrangeChildren(ids, treeType, timeout);
    }

    public List<SecondIDDataObject> createSharedEntities(List<Long> entitiesToShare, List<Long> receivers, long startAt, long stopAt, String token, long timeout) throws SeeTecException {
        return this.srpcProxy.CreateSharedEntities(entitiesToShare, receivers, startAt, stopAt, token, timeout);
    }

    public void editSharedEntity(long sharedFor, long sharingId, long start, long stop, String token, long timeout) throws SeeTecException {
        this.srpcProxy.EditSharedEntity(sharedFor, sharingId, start, stop, token, timeout);
    }

    public List<SecondIDDataObject> createRestrictedEntities(List<Long> idsToRestrict, List<Long> receivers, long startRestrictionAt, long stopRestrictionAt, String token, long timeout) throws SeeTecException {
        return this.srpcProxy.CreateRestrictedEntities(idsToRestrict, receivers, startRestrictionAt, stopRestrictionAt, token, timeout);
    }

    public void editRestrictedEntity(long restrictedFor, long restrictionId, long start, long stop, String token, long timeout) throws SeeTecException {
        this.srpcProxy.EditRestrictedEntity(restrictedFor, restrictionId, start, stop, token, timeout);
    }

    public void setPersonalLayer(EntityDataObject entityDataObject, long timeout, String token) throws SeeTecException {
        this.srpcProxy.SetPersonalLayer(entityDataObject, timeout, token);
    }

    public void deletePersonalLayer(Long entityId, long timeout, String token) throws SeeTecException {
        this.srpcProxy.DeletePersonalLayer(entityId, timeout, token);
    }

    public List<GetAccessEntityDataObject<RestrictedEntity>> getRestrictedEntities(long timeout, String token) throws SeeTecException {
        return this.srpcProxy.GetRestrictedEntities(timeout, token);
    }

    public String toString() {
        String result = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + result.substring(result.lastIndexOf(46) + 1) + ", srpcProxy=" + this.srpcProxy + "]";
    }
}

