/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.NamedThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SrpcStatistics {
    protected static final String SRPCTCP_STATISTIC_HEADER = "SRPCTCP statistic:\r\n";
    protected static final String AVG_BANDWIDTH_KBITS_MB_SINCE_START = "Avg bandwidth=[%7s KBit/s]. [%s MB] since connection start.";
    private static boolean bActivated = false;
    private static Map<String, long[]> htOverallIncomingStatistic = new ConcurrentHashMap<String, long[]>();
    private static Map<String, long[]> htOverallOutgoingStatistic = new ConcurrentHashMap<String, long[]>();
    private static Map<String, ConcurrentHashMap<String, long[]>> htIncomingStatistic = new ConcurrentHashMap<String, ConcurrentHashMap<String, long[]>>();
    private static Map<String, ConcurrentHashMap<String, long[]>> htOutgoingStatistic = new ConcurrentHashMap<String, ConcurrentHashMap<String, long[]>>();
    private static Map<String, Long> lastConnectionIncomingSummation = new ConcurrentHashMap<String, Long>();
    private static Map<String, Long> lastConnectionOutgoingSummation = new ConcurrentHashMap<String, Long>();
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("SrpcStatistics"));
    private static long lastTotalIncomingSummation = 0L;
    private static long lastTotalOutgoingSummation = 0L;
    private static long lastSrpcStatistics = System.currentTimeMillis();

    public static void reset(boolean bActivated) {
        SrpcStatistics.bActivated = bActivated;
        htIncomingStatistic = new ConcurrentHashMap<String, ConcurrentHashMap<String, long[]>>();
        htOutgoingStatistic = new ConcurrentHashMap<String, ConcurrentHashMap<String, long[]>>();
        htOverallIncomingStatistic = new ConcurrentHashMap<String, long[]>();
        htOverallOutgoingStatistic = new ConcurrentHashMap<String, long[]>();
        lastConnectionIncomingSummation = new ConcurrentHashMap<String, Long>();
        lastConnectionOutgoingSummation = new ConcurrentHashMap<String, Long>();
        lastTotalIncomingSummation = 0L;
        lastTotalOutgoingSummation = 0L;
    }

    public static boolean isActivated() {
        return bActivated;
    }

    static void addOutgoingMessage(final String sConnectionIdentifier, final String sOutgoingMessage, final long nVolume) {
        if (bActivated) {
            if (SrpcStatistics.isArgumentNull(sConnectionIdentifier, sOutgoingMessage)) {
                return;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    long[] nValues;
                    Thread.currentThread().setName("STATISTIC_WRITER_OUT");
                    ConcurrentHashMap<String, long[]> htConnectionStatistic = (ConcurrentHashMap<String, long[]>)htOutgoingStatistic.get(sConnectionIdentifier);
                    if (htConnectionStatistic == null) {
                        htConnectionStatistic = new ConcurrentHashMap<String, long[]>();
                        htOutgoingStatistic.put(sConnectionIdentifier, htConnectionStatistic);
                    }
                    if ((nValues = (long[])htConnectionStatistic.get(sOutgoingMessage)) == null) {
                        htConnectionStatistic.put(sOutgoingMessage, new long[]{1L, nVolume});
                    } else {
                        nValues[0] = nValues[0] + 1L;
                        nValues[1] = nValues[1] + nVolume;
                    }
                    long[] nValues2 = (long[])htOverallOutgoingStatistic.get(sOutgoingMessage);
                    if (nValues2 == null) {
                        htOverallOutgoingStatistic.put(sOutgoingMessage, new long[]{1L, nVolume});
                    } else {
                        nValues2[0] = nValues2[0] + 1L;
                        nValues2[1] = nValues2[1] + nVolume;
                    }
                }
            });
        }
    }

    private static boolean isArgumentNull(String sConnectionIdentifier, String message) {
        return sConnectionIdentifier == null || message == null;
    }

    protected static Map<String, ConcurrentHashMap<String, long[]>> getOutgoingStatistic() {
        return htOutgoingStatistic;
    }

    protected static Map<String, long[]> getOverallOutgoingStatistic() {
        return htOverallOutgoingStatistic;
    }

    static void addIncomingMessage(final String sConnectionIdentifier, final String sIncomingMessage, final long nVolume) {
        if (bActivated) {
            if (SrpcStatistics.isArgumentNull(sConnectionIdentifier, sIncomingMessage)) {
                return;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    long[] nValues;
                    Thread.currentThread().setName("STATISTIC_WRITER_IN");
                    ConcurrentHashMap<String, long[]> htConnectionStatistic = (ConcurrentHashMap<String, long[]>)htIncomingStatistic.get(sConnectionIdentifier);
                    if (htConnectionStatistic == null) {
                        htConnectionStatistic = new ConcurrentHashMap<String, long[]>();
                        htIncomingStatistic.put(sConnectionIdentifier, htConnectionStatistic);
                    }
                    if ((nValues = (long[])htConnectionStatistic.get(sIncomingMessage)) == null) {
                        htConnectionStatistic.put(sIncomingMessage, new long[]{1L, nVolume});
                    } else {
                        nValues[0] = nValues[0] + 1L;
                        nValues[1] = nValues[1] + nVolume;
                    }
                    long[] nValues2 = (long[])htOverallIncomingStatistic.get(sIncomingMessage);
                    if (nValues2 == null) {
                        htOverallIncomingStatistic.put(sIncomingMessage, new long[]{1L, nVolume});
                    } else {
                        nValues2[0] = nValues2[0] + 1L;
                        nValues2[1] = nValues2[1] + nVolume;
                    }
                }
            });
        }
    }

    protected static Map<String, ConcurrentHashMap<String, long[]>> getIncomingStatistic() {
        return htIncomingStatistic;
    }

    protected static Map<String, long[]> getOverallIncomingStatistic() {
        return htOverallIncomingStatistic;
    }

    public static String createReport(final VERBOSITY_LEVEL verbose, final String indent) throws InterruptedException, ExecutionException {
        return executor.submit(new Callable<String>(){

            @Override
            public String call() {
                Thread.currentThread().setName("STATISTIC_WRITER_REPORT");
                try {
                    String adaptedIndent = indent == null ? "   " : indent;
                    StringBuilder sb = new StringBuilder(SrpcStatistics.SRPCTCP_STATISTIC_HEADER);
                    long totalIncomingSummation = 0L;
                    long totalOutgoingSummation = 0L;
                    HashMap<String, String> connectionList = new HashMap<String, String>();
                    ConcurrentHashMap<String, ConcurrentHashMap<String, long[]>> allMessages = new ConcurrentHashMap<String, ConcurrentHashMap<String, long[]>>();
                    this.fillMaps(SrpcStatistics.getIncomingStatistic(), connectionList, allMessages, ":Incoming");
                    this.fillMaps(SrpcStatistics.getOutgoingStatistic(), connectionList, allMessages, ":Outgoing");
                    long duration = System.currentTimeMillis() - lastSrpcStatistics + 1L;
                    for (String sConnection : connectionList.keySet()) {
                        ConcurrentHashMap htOutgoingMessages;
                        ConcurrentHashMap htIncomingMessages;
                        long incomingSummation = 0L;
                        long outgoingSummation = 0L;
                        if (verbose == VERBOSITY_LEVEL.REQUEST_STAT || verbose == VERBOSITY_LEVEL.CONNECTION_STAT) {
                            sb.append(adaptedIndent);
                            sb.append("Connection=[");
                            sb.append(sConnection);
                            sb.append("\r\n");
                            sb.append(adaptedIndent);
                            sb.append(adaptedIndent);
                            sb.append("Incoming: ");
                        }
                        if ((htIncomingMessages = (ConcurrentHashMap)allMessages.get(sConnection + ":Incoming")) != null) {
                            StringBuilder verboseOutput = new StringBuilder();
                            for (Map.Entry entry : htIncomingMessages.entrySet()) {
                                long[] nValues = (long[])entry.getValue();
                                verboseOutput.append(adaptedIndent);
                                verboseOutput.append(adaptedIndent);
                                verboseOutput.append(adaptedIndent);
                                verboseOutput.append(String.format("[%-25s], Counter=[%7s], Volume=[%7s KB]%n", entry.getKey(), Basic.longToFormattedString(nValues[0]), Basic.longToFormattedString(nValues[1] >> 10)));
                                incomingSummation += nValues[1];
                                totalIncomingSummation += nValues[1];
                            }
                            Long lastTemp = (Long)lastConnectionIncomingSummation.get(sConnection);
                            long incomingBandwidth = (incomingSummation - (lastTemp == null ? 0L : lastTemp)) * 8L * 1000L / duration;
                            if (verbose == VERBOSITY_LEVEL.REQUEST_STAT || verbose == VERBOSITY_LEVEL.CONNECTION_STAT) {
                                sb.append(String.format(SrpcStatistics.AVG_BANDWIDTH_KBITS_MB_SINCE_START, Basic.longToFormattedString(incomingBandwidth >> 10), Basic.longToFormattedString(incomingSummation >> 20)));
                            }
                            if (verbose == VERBOSITY_LEVEL.REQUEST_STAT) {
                                sb.append("\r\n");
                                sb.append((CharSequence)verboseOutput);
                            }
                        }
                        if (verbose == VERBOSITY_LEVEL.REQUEST_STAT || verbose == VERBOSITY_LEVEL.CONNECTION_STAT) {
                            sb.append("\r\n");
                            sb.append(adaptedIndent);
                            sb.append(adaptedIndent);
                            sb.append("Outgoing: ");
                        }
                        if ((htOutgoingMessages = (ConcurrentHashMap)allMessages.get(sConnection + ":Outgoing")) != null) {
                            StringBuilder verboseOutput = new StringBuilder();
                            for (Map.Entry entry : htOutgoingMessages.entrySet()) {
                                long[] nValues = (long[])entry.getValue();
                                verboseOutput.append(adaptedIndent);
                                verboseOutput.append(adaptedIndent);
                                verboseOutput.append(adaptedIndent);
                                verboseOutput.append(String.format("[%-25s], Counter=[%7s], Volume=[%7s KB]%n", entry.getKey(), Basic.longToFormattedString(nValues[0]), Basic.longToFormattedString(nValues[1] >> 10)));
                                outgoingSummation += nValues[1];
                                totalOutgoingSummation += nValues[1];
                            }
                            Long lastTemp = (Long)lastConnectionOutgoingSummation.get(sConnection);
                            long outgoingBandwidth = (outgoingSummation - (lastTemp == null ? 0L : lastTemp)) * 8L * 1000L / duration;
                            if (verbose == VERBOSITY_LEVEL.REQUEST_STAT || verbose == VERBOSITY_LEVEL.CONNECTION_STAT) {
                                sb.append(String.format(SrpcStatistics.AVG_BANDWIDTH_KBITS_MB_SINCE_START, Basic.longToFormattedString(outgoingBandwidth >> 10), Basic.longToFormattedString(outgoingSummation >> 20)));
                            }
                            if (verbose == VERBOSITY_LEVEL.REQUEST_STAT) {
                                sb.append("\r\n");
                                sb.append((CharSequence)verboseOutput);
                            }
                        }
                        if (verbose == VERBOSITY_LEVEL.REQUEST_STAT || verbose == VERBOSITY_LEVEL.CONNECTION_STAT) {
                            sb.append("\r\n");
                        }
                        lastConnectionIncomingSummation.put(sConnection, incomingSummation);
                        lastConnectionOutgoingSummation.put(sConnection, outgoingSummation);
                    }
                    long totalIncomingBandwidth = (totalIncomingSummation - lastTotalIncomingSummation) * 8L * 1000L / duration;
                    long totalOutgoingBandwidth = (totalOutgoingSummation - lastTotalOutgoingSummation) * 8L * 1000L / duration;
                    sb.append(adaptedIndent);
                    sb.append(String.format("Avg total incoming bandwidth=[%7s KBit/s]%n", Basic.longToFormattedString(totalIncomingBandwidth >> 10)));
                    sb.append(adaptedIndent);
                    sb.append(String.format("Avg total outgoing bandwidth=[%7s KBit/s]", Basic.longToFormattedString(totalOutgoingBandwidth >> 10)));
                    lastTotalIncomingSummation = totalIncomingSummation;
                    lastTotalOutgoingSummation = totalOutgoingSummation;
                    lastSrpcStatistics = System.currentTimeMillis();
                    return sb.toString();
                }
                catch (Throwable ex) {
                    return ex.getMessage();
                }
            }

            private void fillMaps(Map<String, ConcurrentHashMap<String, long[]>> oneDirectionMap, Map<String, String> connectionList, Map<String, ConcurrentHashMap<String, long[]>> allMessages, String postfix) {
                for (Map.Entry<String, ConcurrentHashMap<String, long[]>> entry : oneDirectionMap.entrySet()) {
                    connectionList.put(entry.getKey(), entry.getKey());
                    allMessages.put(entry.getKey() + postfix, entry.getValue());
                }
            }
        }).get();
    }

    public static String createReport() throws InterruptedException, ExecutionException {
        return SrpcStatistics.createReport(VERBOSITY_LEVEL.REQUEST_STAT, null);
    }

    public static enum VERBOSITY_LEVEL {
        TOTAL_STAT,
        CONNECTION_STAT,
        REQUEST_STAT;

    }
}

