/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcMessageFilter;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverflowSrpcMessageFilter
implements SrpcMessageFilter {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final int maxSize;

    public OverflowSrpcMessageFilter(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean filter(Methods method, SrpcMessage sm, RequestHandlerCallback callback, Collection<SrpcMessage> currentQueue) {
        if (currentQueue.size() >= this.maxSize) {
            this.logger.error("Max queue size [" + this.maxSize + "] reached for " + this);
            this.logger.error("   Queue: " + currentQueue);
            this.sendQueueOverflowResponce(sm, callback);
            return true;
        }
        return false;
    }

    private void sendQueueOverflowResponce(SrpcMessage sm, RequestHandlerCallback callback) {
        SrpcMessage rsp = SrpcMessage.createResponse(sm, null);
        rsp.setError(-20038);
        callback.onRequestHandled(sm, rsp);
    }
}

