/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum Methods {
    UNKNOWN("Unknown"),
    PING("Ping"),
    NOTIFY("Notify"),
    ENT_FUNCTION_REGISTER("Register"),
    ENT_FUNCTION_DEREGISTER("Deregister"),
    ENT_FUNCTION_START_DEVICE("StartDevice"),
    ENT_FUNCTION_STOP_DEVICE("StopDevice"),
    ENT_FUNCTION_GET_STATUS("GetStatus"),
    ENT_FUNCTION_GET_USED_CAMERA_LICENSES("GetUsedCameraLicenses"),
    ENT_FUNCTION_LOCATE_ENTITY_BY_ID("LocateEntityByID"),
    ENT_FUNCTION_LOCATE_ENTITIES_BY_TYPE("LocateEntitiesByType"),
    ENT_FUNCTION_GET_TICKET("GetTicket"),
    ENT_FUNCTION_GET_ID_OFFSET("GetIDOffset"),
    ENT_FUNCTION_GET_LICENSE("GetLicense"),
    ENT_FUNCTION_SET_LICENSE("SetLicense"),
    ENT_FUNCTION_GET_MACHINE_ID("GetMachineID"),
    ENT_FUNCTION_GET_INSTALLATION_INFO("GetInstallationInfo"),
    ENT_FUNCTION_GET_TYPE_TREE("GetTypeTree"),
    ENT_FUNCTION_SET_ENTITY("SetEntity"),
    ENT_FUNCTION_SET_STATUS("SetStatus"),
    ENT_FUNCTION_GET_ENTITY_BY_ID("GetEntityByID"),
    ENT_FUNCTION_GET_DELETED_ENTITY_BY_ID("GetDeletedEntityByID"),
    ENT_FUNCTION_GET_ENTITIES_BY_ID_LIST("GetEntitiesByIDList"),
    ENT_FUNCTION_GET_ENTITIES_AS_LIST("GetEntitiesAsList"),
    ENT_FUNCTION_GET_ENTITIES_AS_TREE("GetEntitiesAsTree"),
    ENT_FUNCTION_DELETE_ENTITY("DeleteEntity"),
    ENT_FUNCTION_SET_BLOB("SetBlob"),
    ENT_FUNCTION_DELETE_BLOB("DeleteBlob"),
    ENT_FUNCTION_GET_BLOB_BY_ID("GetBlobByID"),
    ENT_FUNCTION_GET_BLOBS_BY_TYPE("GetBlobsByType"),
    ENT_FUNCTION_GET_BLOBS_BY_ID_LIST("GetBlobsByIDList"),
    ENT_FUNCTION_SEND_TEST_MAIL("SendTestMail"),
    ENT_FUNCTION_GET_DB_ESTIMATION("GetDBEstimation"),
    ENT_FUNCTION_SEND_TEST_TRAP("SendTestTrap"),
    ENT_FUNCTION_GET_VERSION("GetVersion"),
    ENT_FUNCTION_IS_AUTHORIZED("IsAuthorized"),
    ENT_FUNCTION_SET_PASSWORD("SetPassword"),
    ENT_FUNCTION_SUBSCRIBE("Subscribe"),
    ENT_FUNCTION_UNSUBSCRIBE("UnSubscribe"),
    ENT_FUNCTION_ANNOUNCE("Announce"),
    ENT_FUNCTION_CORE_ANNOUNCE("CoreAnnounce"),
    ENT_FUNCTION_GET_EVENTS("GetEvents"),
    ENT_FUNCTION_GET_EVENT_SLICES("GetEventSlices"),
    ENT_FUNCTION_DELETE_EVENTS("DeleteEvents"),
    ENT_FUNCTION_GET_CLIENT_LIST("GetClientList"),
    ENT_FUNCTION_DELIVER_TRIGGERED_SCENARIO("DeliverTriggeredScenario"),
    ENT_FUNCTION_TEST_SCENARIO("TestScenario"),
    ENT_FUNCTION_TRIGGER_ACTION("TriggerAction"),
    ENT_FUNCTION_GET_SALT("GetSalt"),
    ENT_FUNCTION_START_BACKUP("StartBackup"),
    ENT_FUNCTION_GET_DEFINITIONS("GetDefinitions"),
    ENT_FUNCTION_SYNC_BLOB("SyncBlob"),
    ENT_FUNCTION_SYNC_ENTITY("SyncEntity"),
    ENT_FUNCTION_SYNC_PASSWORD("SyncPassword"),
    ENT_FUNCTION_SYNC_STATUS("SyncStatus"),
    ENT_FUNCTION_SYNC_EVENT("SyncEvent"),
    ENT_FUNCTION_SYNC_LPR_EVENT("SyncLprEvent"),
    ENT_FUNCTION_SYNC_LPR_HEADER_DATA("SyncLprHeaderData"),
    ENT_FUNCTION_SYNC_LPR_MASTER_DATA("SyncLprMasterData"),
    ENT_FUNCTION_SYNC_LPR_ASSOCIATED_CAMS("SyncLprAssociatedCams"),
    ENT_FUNCTION_BULK_SET_ENTITY("BulkSetEntity"),
    ENT_FUNCTION_REARRANGE_CHILDREN("RearrangeChildren"),
    ENT_FUNCTION_START_MANUAL_SUMMARY_LOG("StartManualSummaryLog"),
    ENT_FUNCTION_GET_OPC_DATAPOINTS("GetOPCDataPoints"),
    ENT_FUNCTION_REFRESH_TOKEN("RefreshToken"),
    ENT_FUNCTION_GET_TOKEN_FOR_USER("GetTokenForUser"),
    ENT_FUNCTION_LPR_EXECUTE_QUERY("LPRExecuteQuery"),
    ENT_FUNCTION_LPR_EXECUTE_UPDATE("LPRExecuteUpdate"),
    ENT_FUNCTION_CREATE_SHARED_ENTITIES("CreateSharedEntities"),
    ENT_FUNCTION_EDIT_SHARED_ENTITY("EditSharedEntity"),
    ENT_FUNCTION_GET_SHARED_ENTITIES("GetSharedEntities"),
    ENT_FUNCTION_GET_SHARED_ENTITIES_BY("GetSharedEntitiesBy"),
    ENT_FUNCTION_CREATE_RESTRICTED_ENTITIES("CreateRestrictedEntities"),
    ENT_FUNCTION_EDIT_RESTRICTED_ENTITY("EditRestrictedEntity"),
    ENT_FUNCTION_GET_RESTRICTED_ENTITIES("GetRestrictedEntities"),
    ENT_FUNCTION_GET_RESTRICTED_ENTITIES_BY("GetRestrictedEntitiesBy"),
    ENT_FUNCTION_GET_PERSONAL_LAYERS("GetPersonalLayers"),
    ENT_FUNCTION_SET_PERSONAL_LAYER("SetPersonalLayer"),
    ENT_FUNCTION_DELETE_PERSONAL_LAYER("DeletePersonalLayer"),
    ENT_FUNCTION_VALIDATE_TOKEN("ValidateToken"),
    SSL_FUNCTION_GET_ENCRYPTION_KEY("GetEncryptionKey"),
    SSL_SRPC_REQ_STATUSCONTENT("StatusContent"),
    IS_SINGLE_SIGN_ON_AUTHORIZED("IsSingleSignOnAuthorized"),
    MD_REQ_LOGIN("Login"),
    MD_REQ_OPENCONTENT("OpenContent"),
    MD_REQ_CHECKTEMPORARYDIRECTORY("CheckTemporaryDirectory"),
    MD_REQ_WRITEFRAME("WriteFrame"),
    MD_REQ_WRITEMULTIPLEFRAMES("WriteMultipleFrames"),
    MD_REQ_WRITELOCALSTORAGEFRAMES("WriteLocalStorageFrames"),
    MD_REQ_SETUPLOCALSTORAGERECORDING("SetupLocalStorageRecording"),
    MD_REQ_FINALIZELOCALSTORAGERECORDING("FinalizeLocalStorageRecording"),
    MD_REQ_FINALIZECURRENTSEQUENCE("FinalizeCurrentSequence"),
    MD_REQ_CHANGERECORDINGMODE("ChangeRecordingMode"),
    MD_REQ_GETIMPORTINFO("GetImportInfo"),
    MD_REQ_GETIMPORTPATHS("GetImportPaths"),
    MD_REQ_GETFAILEDBACKUPS("GetFailedBackups"),
    MD_REQ_RETRYBACKUP("RetryBackup"),
    MD_REQ_DISCARDFAILEDBACKUP("DiscardFailedBackup"),
    MD_REQ_STARTEXPORT("StartExport"),
    MD_REQ_STARTEXPORTDOWNLOAD("StartExportDownload"),
    MD_REQ_CANCELEXPORTDOWNLOAD("CancelExportDownload"),
    MD_REQ_CANCELEXPORT("CancelExport"),
    MD_REQ_GETSTATUSEXPORT("GetStatusExport"),
    MD_REQ_STARTMANUALEXPORT("StartManualExport"),
    CM_SRPC_REQ_LOCKCONTROL("LockControl"),
    CM_SRPC_REQ_UNLOCKCONTROL("UnlockControl"),
    CM_SRPC_REQ_READRTSPINFORMATION("ReadRTSPInformation"),
    CM_SRPC_REQ_REMOVERTSPINFORMATION("RemoveRTSPInformation"),
    CM_SRPC_REQ_STORERTSPINFORMATION("StoreRTSPInformation"),
    CM_SRPC_REQ_GETCONTENTFRAMESTATISTIC("GetContentFrameStatistic"),
    CM_SRPC_REQ_GETJPEGSNAPSHOT("GetJpegSnapshot"),
    CM_SRPC_REQ_SETCENTERPT("SetCenterPT"),
    CM_SRPC_REQ_SETZOOMAREA("SetZoomArea"),
    CM_SRPC_REQ_STOPALLCONTROLCOMMANDS("StopAllControlCommands"),
    CM_SRPC_REQ_SETABSOLUTEPTZ("SetAbsolutePTZ"),
    CM_SRPC_REQ_SETABSOLUTEPT("SetAbsolutePT"),
    CM_SRPC_REQ_SETABSOLUTEZ("SetAbsoluteZ"),
    CM_SRPC_REQ_SETCONTINUOUSPTZ("SetContinuousPTZ"),
    CM_SRPC_REQ_SETABSOLUTEIRIS("SetAbsoluteIris"),
    CM_SRPC_REQ_SETCONTINUOUSIRIS("SetContinuousIris"),
    CM_SRPC_REQ_SETAUTOIRIS("SetAutoIris"),
    CM_SRPC_REQ_SETABSOLUTEFOCUS("SetAbsoluteFocus"),
    CM_SRPC_REQ_SETCONTINUOUSFOCUS("SetContinuousFocus"),
    CM_SRPC_REQ_SETAUTOFOCUS("SetAutoFocus"),
    CM_SRPC_REQ_SETZEROLUX("SetZeroLux"),
    CM_SRPC_REQ_SETAUTOZEROLUX("SetAutoZeroLux"),
    CM_SRPC_REQ_SETHOMEPOSITION("SetHomePosition"),
    CM_SRPC_REQ_SETPRESETPOSITION("SetPresetPosition"),
    CM_SRPC_REQ_OPENCONTENTSTREAM("OpenContentStream"),
    CM_SRPC_REQ_SETSTREAMPARAMETER("SetStreamParameter"),
    CM_SRPC_REQ_SET_TRANSCODING_STREAM_PARAMETER("SetTranscodingStreamParameterClientRequest"),
    CM_SRPC_REQ_SETBANDWIDTHLIMITATION("SetBandwidthLimitation"),
    CM_SRPC_REQ_STARTLIVESTREAMING("StartLiveStreaming"),
    CM_SRPC_REQ_STOPSTREAMING("StopStreaming"),
    CM_SRPC_REQ_STARTALARMRECORDING("StartAlarmRecording"),
    CM_SRPC_REQ_ADDPRESETPOSITION("AddPresetPosition"),
    CM_SRPC_REQ_REMOVEPRESETPOSITION("RemovePresetPosition"),
    CM_SRPC_REQ_GETCAMERAPRESETS("GetAllPresetsFromCamera"),
    CM_SRPC_REQ_ADDCAMERAPRESETS("AddCameraPresets"),
    CM_SRPC_REQ_MOTION_DETECTED("MotionDetected"),
    CM_SRPC_REQ_MOTION_END("MotionEnd"),
    DM_SRPC_REQ_SYNCHRONIZE_EDGE_STORAGE("SynchronizeEdgeStorage"),
    CM_SRPC_REQ_STATUSABSOLUTEPTZ("StatusAbsolutePTZ"),
    CM_SRPC_REQ_STATUSSERVICE("StatusService"),
    CM_SRPC_REQ_STATUSCONTROLLOCK("StatusControlLock"),
    CM_SRPC_REQ_STATUSCONTROLPRIORITY("StatusControlPriority"),
    CM_SRPC_REQ_STATUSPTZUSER("StatusPTZUser"),
    CM_SRPC_REQ_SETSTATE("SetState"),
    CM_SRPC_REQ_RESTOREALLALERTS("RestoreAllAlerts"),
    CM_SRPC_REQ_START_TALKING("StartTalking"),
    CM_SRPC_REQ_STOP_TALKING("StopTalking"),
    CM_SRPC_REQ_CHANGE_DEVICE_PASSWORD("ChangeDevicePassword"),
    CM_SRPC_REQ_CHANGE_DEVICE_IP("ChangeDeviceIP"),
    CM_SRPC_REQ_IS_FIRMWARE_AVAILABLE("IsFirmwareAvailable"),
    CM_SRPC_REQ_IS_DELETE_FIRMWARE("DeleteFirmware"),
    CM_SRPC_REQ_IS_SEND_FIRMWARE("SendFirmware"),
    CM_SRPC_REQ_UPGRADE_DEVICE_FIRMWARE("UpgradeDeviceFirmware"),
    CM_SRPC_REQ_UPDATE_GENERIC_EVENT_TRIGGER("UpdateGenericEventTrigger"),
    RE_SRPC_REQ_READPREVIOUSFRAME("ReadPreviousFrame"),
    RE_SRPC_REQ_READNEXTFRAME("ReadNextFrame"),
    RE_SRPC_REQ_READMULTIPLEFRAMES("ReadMultipleFrames"),
    RE_SRPC_REQ_READGOP("ReadGOP"),
    RE_SRPC_REQ_GETALARMTIMERANGE("GetAlarmTimerange"),
    RE_SRPC_REQ_GETRECORDINGINFOS("GetRecordingInfos"),
    RE_SRPC_REQ_GETALARMSCENARIOOCCURRENCIES("GetAlarmScenarioOccurrencies"),
    RE_SRPC_REQ_GETALARMINSTANCES("GetAlarmInstances"),
    RE_SRPC_REQ_WRITEALARMINSTANCES("WriteAlarmInstances"),
    RE_SRPC_REQ_GETALARMINSTANCE("GetAlarmInstance"),
    RE_SRPC_REQ_MARKASALARMRECORDING("MarkAsAlarmRecording"),
    RE_SRPC_REQ_COUNTLOGGINGOFCAMERALIVEUSAGE("CountLoggingOfCameraLiveUsage"),
    RE_SRPC_REQ_GETLOGGINGOFCAMERALIVEUSAGE("GetLoggingOfCameraLiveUsage"),
    RE_SRPC_REQ_CHECKDEVICEINFOS("CheckDeviceInfos"),
    RE_SRPC_REQ_SETWRITEPROTECTION("SetWriteProtection"),
    RE_SRPC_REQ_REMOVEWRITEPROTECTION("RemoveWriteProtection"),
    RE_SRPC_REQ_GETWRITEPROTECTIONS("GetWriteProtections"),
    GET_MOBILE_CLIENT_LIST("GetMobileClientList"),
    RE_SRPC_REQ_REMOVERECORDING("MDSRemoveRecording"),
    RE_SRPC_TRANSCODING_ALLOCATE_TRANSCODING_CHANNEL("AllocateTranscodingChannel"),
    RE_SRPC_TRANSCODING_SET_TRANSCODING_STREAM_PARAMETER("SetTranscodingStreamParameter"),
    RE_SRPC_TRANSCODING_TRANSCODE_FRAMES("TranscodeFrames"),
    RE_SRPC_TRANSCODING_CLOSE_TRANSCODING_CHANNEL("CloseTranscodingChannel"),
    RE_SRPC_GET_CAMERA_RECORDING_STATISTICS("GetCameraRecordingStatistics"),
    DELETE_SINGLE_EVENT("DeleteSingleEvent");

    private final String name;
    private final int hashCode;
    private final int hashCodeMd5;

    private Methods(String name) {
        this.name = name;
        this.hashCode = this.getHash(name);
        this.hashCodeMd5 = this.getHashMd5(name);
    }

    public String methodName() {
        return this.name;
    }

    public int methodHash() {
        return this.hashCode;
    }

    public int methodHashMd5() {
        return this.hashCodeMd5;
    }

    public static Methods valueOf(int hash) {
        for (Methods m : Methods.values()) {
            if (m.hashCode != hash && m.hashCodeMd5 != hash) continue;
            return m;
        }
        return UNKNOWN;
    }

    private int getHash(String name) {
        byte[] digest;
        try {
            digest = MessageDigest.getInstance("SHA-512").digest(name.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            return 0;
        }
        return ByteBuffer.wrap(digest).getInt();
    }

    private int getHashMd5(String name) {
        byte[] digest;
        try {
            digest = MessageDigest.getInstance("MD5").digest(name.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            return 0;
        }
        return ByteBuffer.wrap(digest).getInt();
    }
}

