/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.CipherSuitesFilter;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.net.SSLProtocol;
import de.seetec.v5.shared.net.SeeTecX509TrustManager;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHelper {
    static final String CONTENTLENGTH = "content-length: ";
    private static int nonceCounter = 1;
    private static final Logger LOGGER = LogManager.getLogger((String)NetworkHelper.class.getName());
    static final TrustManager[] trustAllCerts = new TrustManager[]{new SeeTecX509TrustManager()};
    protected final byte[] Boundary = "boundary=".getBytes();

    public static Socket createNetworkConnection(String host, int port, boolean SSL) throws Exception {
        if (SSL) {
            return NetworkHelper.createSSLconnection(host, port, false, SSLProtocol.TLS12, null);
        }
        return new Socket(host, port);
    }

    public static final Socket createNetworkConnection(String host, int port, boolean ssl, int timeout) throws Exception {
        if (ssl) {
            return NetworkHelper.createSSLconnection(host, port, false, SSLProtocol.TLS12, null);
        }
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(host, port), timeout);
        return socket;
    }

    public static final Socket createSSLconnection(String host, int port, boolean filterCipherSuites, SSLProtocol protocolToUse, HandshakeCompletedListener handshakeCompletedListener) throws Exception {
        SSLContext sslContext = SSLContext.getInstance(protocolToUse.getProtocolString());
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket(host, port);
        if (filterCipherSuites) {
            socket.setEnabledCipherSuites(new CipherSuitesFilter().filter(socket.getEnabledCipherSuites()));
        }
        if (handshakeCompletedListener != null) {
            socket.addHandshakeCompletedListener(handshakeCompletedListener);
        }
        socket.startHandshake();
        return socket;
    }

    public static final void checkNetworkConnection(NetworkParameter networkParameter, int timeout) throws SeeTecException {
        String host = networkParameter.getHost();
        int port = networkParameter.useHTTPS() ? networkParameter.getSSLport() : networkParameter.getHTTPport();
        try {
            NetworkHelper.createNetworkConnection(host, port, false, timeout).close();
        }
        catch (Exception ex) {
            throw new SeeTecException(-20100, "Error opening connection to " + host + " on port " + port + ": " + ex.getMessage());
        }
    }

    public static Socket establishServerPushStream(NetworkParameter networkParameter, String[] userPWD, String url) throws Exception {
        String realm = networkParameter.getRealm();
        String nonce = networkParameter.getNonce();
        String qop = networkParameter.getQop();
        String authorization = realm != null && nonce != null ? NetworkHelper.createDigestAuthorization(networkParameter, realm, nonce, "GET", url, qop) : NetworkHelper.createBasicAuthorization(userPWD);
        String additionalData = networkParameter.getAdditionalData() != null ? networkParameter.getAdditionalData() : "";
        String request = "GET " + url + " " + networkParameter.getHttpVersion().toString() + "\r\n" + additionalData + authorization + "User-Agent: Java/1.7.0\r\nHost: " + networkParameter.getHost() + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\nConnection: keep-alive\r\n\r\n";
        Socket socket = networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection(networkParameter.getHost(), networkParameter.getSSLport(), true) : NetworkHelper.createNetworkConnection(networkParameter.getHost(), networkParameter.getHTTPport(), false);
        socket.setSoTimeout(networkParameter.getSoTimeout());
        socket.setReceiveBufferSize(262144);
        socket.setSendBufferSize(262144);
        OutputStream os = socket.getOutputStream();
        os.write(request.getBytes());
        os.flush();
        return socket;
    }

    public static void readGetRequest(String host, int httpPort, String[] userPWD, String url) throws SeeTecException {
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter(host, httpPort, userPWD);
        int nWantedLength = -1;
        NetworkHelper.readGetRequest(networkParameter, url, nWantedLength, null);
    }

    public static void readGetRequest(NetworkParameter networkParameter, String url) throws SeeTecException {
        NetworkHelper.readGetRequest(networkParameter, url, -1, null);
    }

    public static byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength) throws SeeTecException {
        return NetworkHelper.readGetRequest(networkParameter, url, wantedLength, false, null, null);
    }

    public static byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, List<Integer> ignoreHttpStatusCode) throws SeeTecException {
        return NetworkHelper.readGetRequest(networkParameter, url, wantedLength, false, null, ignoreHttpStatusCode);
    }

    public static byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, boolean useContentLength) throws SeeTecException {
        return NetworkHelper.readGetRequest(networkParameter, url, wantedLength, useContentLength, null, null);
    }

    public static byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, boolean useContentLength, String returnAt) throws SeeTecException {
        return NetworkHelper.readGetRequest(networkParameter, url, wantedLength, useContentLength, returnAt, false, null);
    }

    public static byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, boolean useContentLength, String returnAt, List<Integer> ignoreHttpStatusCode) throws SeeTecException {
        return NetworkHelper.readGetRequest(networkParameter, url, wantedLength, useContentLength, returnAt, false, ignoreHttpStatusCode);
    }

    public static byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, boolean useContentLength, String returnAt, boolean headerOnly) throws SeeTecException {
        return NetworkHelper.readHTTPRequest(networkParameter, url, null, wantedLength, false, useContentLength, returnAt, "GET", null, headerOnly, false, null);
    }

    public static byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, boolean useContentLength, String returnAt, boolean headerOnly, List<Integer> ignoreHttpStatusCode) throws SeeTecException {
        return NetworkHelper.readHTTPRequest(networkParameter, url, null, wantedLength, false, useContentLength, returnAt, "GET", null, headerOnly, false, ignoreHttpStatusCode);
    }

    public static final String createBasicAuthorization(String[] userPWD) {
        if (userPWD == null || userPWD.length != 2 || userPWD[0] == null || userPWD[1] == null) {
            return "";
        }
        StringBuilder auth = new StringBuilder("Authorization: Basic ");
        auth.append(Base64.getEncoder().encodeToString((userPWD[0] + ":" + userPWD[1]).getBytes()));
        auth.append("\r\n");
        return auth.toString();
    }

    public static String createBasicAuthorization(NetworkParameter networkParameter) throws Exception {
        if (networkParameter == null) {
            throw new Exception("Needed parameter is null.");
        }
        if (networkParameter.getUserPWD() == null) {
            return null;
        }
        if (networkParameter.getUserPWD().length != 2) {
            throw new Exception("UserPWD has not expected format");
        }
        if (networkParameter.getUserPWD()[0] == null || networkParameter.getUserPWD()[1] == null) {
            throw new Exception("UserPWD not null but one of it parts.");
        }
        return NetworkHelper.createBasicAuthorization(networkParameter.getUserPWD());
    }

    public static String createDigestAuthorization(NetworkParameter networkParameter, String realm, String nonce, String cmd, String URI2) throws Exception {
        return NetworkHelper.createDigestAuthorization(networkParameter, realm, nonce, cmd, URI2, null);
    }

    public static String createDigestAuthorization(NetworkParameter networkParameter, String realm, String nonce, String cmd, String URI2, String qop) throws Exception {
        String internalUser = null;
        String internalPass = null;
        if (networkParameter == null) {
            throw new Exception("Needed parameter is null.");
        }
        if (networkParameter.getUserPWD() == null) {
            internalUser = "";
            internalPass = "";
        } else {
            if (networkParameter.getUserPWD().length != 2) {
                throw new Exception("UserPWD has not expected format");
            }
            if (networkParameter.getUserPWD()[0] == null || networkParameter.getUserPWD()[1] == null) {
                throw new Exception("UserPWD not null but one of it parts.");
            }
            internalUser = networkParameter.getUserPWD()[0];
            internalPass = networkParameter.getUserPWD()[1];
        }
        if (realm == null || nonce == null || cmd == null || URI2 == null) {
            return null;
        }
        String DELIMITER = ":";
        String cmdUpperCase = cmd.toUpperCase();
        String hash1plain = internalUser + ":" + realm + ":" + internalPass;
        String hash2plain = cmdUpperCase + ":" + URI2;
        try {
            String authorizationString;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] hash1 = messageDigest.digest(hash1plain.getBytes());
            byte[] hash2 = messageDigest.digest(hash2plain.getBytes());
            if (qop != null && qop.equalsIgnoreCase("auth")) {
                byte[] cnonce = new byte[16];
                SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
                ((Random)rand).nextBytes(cnonce);
                byte[] nc = Basic.int4ToByteArray(nonceCounter++);
                String completeHashplain = Basic.byteArrayToHexString(hash1).toLowerCase() + ":" + nonce + ":" + Basic.byteArrayToHexString(nc).toLowerCase() + ":" + Basic.byteArrayToHexString(cnonce).toLowerCase() + ":" + "auth" + ":" + Basic.byteArrayToHexString(hash2).toLowerCase();
                byte[] completeHash = messageDigest.digest(completeHashplain.getBytes());
                authorizationString = "Authorization: Digest username=\"" + internalUser + "\", realm=\"" + realm + "\", qop=auth, algorithm=\"MD5\", nonce=\"" + nonce + "\", nc=" + Basic.byteArrayToHexString(nc).toLowerCase() + ", cnonce=\"" + Basic.byteArrayToHexString(cnonce).toLowerCase() + "\", uri=\"" + URI2 + "\", response=\"" + Basic.byteArrayToHexString(completeHash).toLowerCase() + "\"";
            } else {
                String completeHashplain = Basic.byteArrayToHexString(hash1).toLowerCase() + ":" + nonce + ":" + Basic.byteArrayToHexString(hash2).toLowerCase();
                byte[] completeHash = messageDigest.digest(completeHashplain.getBytes());
                authorizationString = "Authorization: Digest username=\"" + internalUser + "\", realm=\"" + realm + "\", algorithm=\"MD5\", nonce=\"" + nonce + "\", uri=\"" + URI2 + "\", response=\"" + Basic.byteArrayToHexString(completeHash).toLowerCase() + "\"";
            }
            return authorizationString + "\r\n";
        }
        catch (Exception nsae) {
            return null;
        }
    }

    public static String getAuthenticationData(String name, String response) {
        String[] divideAtName;
        String ret = null;
        if (name != null && response != null && (divideAtName = response.split(name + "=\"")).length > 1) {
            String divideAfterValue = divideAtName[1].split("\"")[0];
            int index = divideAfterValue.indexOf(",");
            ret = index >= 0 ? divideAfterValue.substring(0, index) : divideAfterValue;
        }
        return ret;
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, String body) throws SeeTecException {
        return NetworkHelper.readPostRequest(networkParameter, url, body.getBytes(), Integer.MIN_VALUE, false, (List<Integer>)null);
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, String body, boolean noAnswer) throws SeeTecException {
        return NetworkHelper.readHTTPRequest(networkParameter, url, body.getBytes(), Integer.MIN_VALUE, false, false, null, "POST", "text/plain", false, noAnswer, null);
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, byte[] body) throws SeeTecException {
        return NetworkHelper.readPostRequest(networkParameter, url, body, Integer.MIN_VALUE, false, (List<Integer>)null);
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, byte[] body, boolean noAnswer) throws SeeTecException {
        return NetworkHelper.readHTTPRequest(networkParameter, url, body, Integer.MIN_VALUE, false, false, null, "POST", "text/plain", false, noAnswer, null);
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, String body, int wantedLength, boolean useContentLength) throws SeeTecException {
        return NetworkHelper.readPostRequest(networkParameter, url, body.getBytes(), wantedLength, useContentLength, (List<Integer>)null);
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, byte[] body, int wantedLength, boolean useContentLength) throws SeeTecException {
        return NetworkHelper.readPostRequest(networkParameter, url, body, wantedLength, useContentLength, "text/plain", null);
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, byte[] body, int wantedLength, boolean useContentLength, List<Integer> ignoreHttpStatusCode) throws SeeTecException {
        return NetworkHelper.readPostRequest(networkParameter, url, body, wantedLength, useContentLength, "text/plain", ignoreHttpStatusCode);
    }

    public static byte[] readPostRequest(NetworkParameter networkParameter, String url, String body, int wantedLength, boolean useContentLength, String contentType) throws SeeTecException {
        return NetworkHelper.readPostRequest(networkParameter, url, body.getBytes(), wantedLength, useContentLength, contentType, null);
    }

    static byte[] readPostRequest(NetworkParameter networkParameter, String url, byte[] body, int wantedLength, boolean useContentLength, String contentType, List<Integer> ignoreHttpStatusCode) throws SeeTecException {
        return NetworkHelper.readHTTPRequest(networkParameter, url, body, wantedLength, useContentLength, false, null, "POST", contentType, false, false, ignoreHttpStatusCode);
    }

    public static HTTPStatusCode getStatusCode(NetworkParameter networkParameter, String response) {
        String firstHeaderLine;
        String[] headerValues;
        int endIndex;
        HTTPStatusCode statusCode = HTTPStatusCode.HTTP_OK;
        int startIndex = response.indexOf("HTTP");
        if (startIndex != -1 && (endIndex = response.indexOf(new String(networkParameter.getHttpSingleLineDelimitter()), startIndex)) != -1 && (headerValues = (firstHeaderLine = response.substring(startIndex, endIndex)).split(" ")).length >= 2) {
            statusCode = HTTPStatusCode.valueOf(Integer.parseInt(headerValues[1]));
        }
        return statusCode;
    }

    private static byte[] readHTTPRequest(NetworkParameter networkParameter, String url, byte[] body, int wantedLength, boolean isRecursive, boolean readContentLength, String returnAt, String command, String contentType, boolean headerOnly, boolean noAnswer, List<Integer> ignoreHttpStatusCode) throws SeeTecException {
        byte[] byArray;
        Socket socket = null;
        int bytesOfContentRead = 0;
        int contentLength = 0;
        String host = networkParameter.getHost();
        String DOUBLE_CRLF = new String(networkParameter.getHttpDoubleLineDelimitter());
        String SINGLE_CRLF = new String(networkParameter.getHttpSingleLineDelimitter());
        try {
            int len;
            String authentication = networkParameter.getRealm() != null && networkParameter.getNonce() != null ? NetworkHelper.createDigestAuthorization(networkParameter, networkParameter.getRealm(), networkParameter.getNonce(), command, url, networkParameter.getQop()) : NetworkHelper.createBasicAuthorization(networkParameter.getUserPWD());
            String additionalData = networkParameter.getAdditionalData() != null ? networkParameter.getAdditionalData() : "";
            String request = "";
            if (command.equals("POST") || command.equals("PUT")) {
                request = command + " " + url + " HTTP/1.1" + "\r\n" + authentication + additionalData + "User-Agent: Java/1.7.0" + "\r\n" + "Host: " + host + "\r\n" + "Accept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" + "\r\n";
                if (contentType != null) {
                    request = request + "Content-Type: " + contentType + "\r\n";
                }
                request = request + "Connection: keep-alive\r\nCache-Control: no-cache\r\nContent-Length: " + (body == null ? "0" : Integer.valueOf(body.length)) + new String(SSLConstantsIntf.DOUBLE_CRLF_BYTE);
            } else if (command.equals("GET") || command.equals("DELETE")) {
                request = command + " " + url + " HTTP/1.1\r\n" + additionalData + authentication + "User-Agent: Java/1.7.0\r\nHost: " + host + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\nConnection: keep-alive\r\n\r\n";
            }
            socket = networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection(host, networkParameter.getSSLport(), true, networkParameter.getSoTimeout()) : NetworkHelper.createNetworkConnection(host, networkParameter.getHTTPport(), false, networkParameter.getSoTimeout());
            socket.setSoTimeout(networkParameter.getSoTimeout());
            OutputStream os = socket.getOutputStream();
            os.write(request.getBytes());
            if (body != null && body.length > 0) {
                os.write(body);
            }
            os.flush();
            InputStream is = socket.getInputStream();
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
            int startPos = -1;
            boolean useContentLength = false;
            boolean headerAlreadyRead = false;
            while (!noAnswer && (len = is.read(buffer, 0, buffer.length)) > 0) {
                int endPos;
                int index;
                bytesOfContentRead += len;
                baos.write(buffer, 0, len);
                String tmp = baos.toString();
                HTTPStatusCode statusCode = NetworkHelper.getStatusCode(networkParameter, tmp);
                if (ignoreHttpStatusCode == null || !ignoreHttpStatusCode.contains(statusCode.getStatusCode())) {
                    if (statusCode == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                        if (tmp.toLowerCase().contains("digest") && !isRecursive) {
                            networkParameter.setRealm(NetworkHelper.getAuthenticationData("realm", tmp));
                            networkParameter.setNonce(NetworkHelper.getAuthenticationData("nonce", tmp));
                            networkParameter.setQop(NetworkHelper.getAuthenticationData("qop", tmp));
                            byte[] byArray2 = NetworkHelper.readHTTPRequest(networkParameter, url, body, wantedLength, true, readContentLength, returnAt, command, contentType, headerOnly, noAnswer, ignoreHttpStatusCode);
                            return byArray2;
                        }
                        throw new SeeTecException(-21657, "Unauthorized access", statusCode);
                    }
                    if (statusCode == HTTPStatusCode.HTTP_NO_CONTENT || headerOnly) break;
                    if (statusCode == HTTPStatusCode.HTTP_ACCOUNT_BLOCKED) {
                        throw new SeeTecException(-21657, "Error while sending HTTP request. HTTP statuscode = " + (Object)((Object)statusCode), statusCode);
                    }
                    if (statusCode.getStatusCode() >= 400) {
                        throw new SeeTecException(-20100, "Error while sending HTTP request. HTTP statuscode = " + (Object)((Object)statusCode), statusCode);
                    }
                }
                if (wantedLength <= 0 || wantedLength <= baos.size()) break;
                if (tmp.toLowerCase().contains("transfer-encoding: chunked\r\n")) {
                    NetworkHelper.readChunkedStream(is, baos, returnAt);
                    break;
                }
                int headerLength = tmp.indexOf(DOUBLE_CRLF) + DOUBLE_CRLF.length();
                if (!headerAlreadyRead && tmp.toLowerCase().contains(CONTENTLENGTH)) {
                    startPos = tmp.toLowerCase().indexOf(CONTENTLENGTH) + CONTENTLENGTH.length();
                    contentLength = Integer.parseInt(tmp.substring(startPos, tmp.indexOf(SINGLE_CRLF, startPos)).trim());
                    useContentLength = true;
                }
                if (tmp.contains(DOUBLE_CRLF)) {
                    headerAlreadyRead = true;
                }
                if (useContentLength && ((index = tmp.indexOf(DOUBLE_CRLF)) >= 0 && tmp.length() > index && (index = tmp.indexOf(DOUBLE_CRLF, index + 1)) >= 0 || startPos != -1 && bytesOfContentRead - headerLength >= contentLength) || returnAt != null && tmp.contains(returnAt) || (endPos = tmp.indexOf(DOUBLE_CRLF, (startPos = tmp.indexOf(DOUBLE_CRLF)) + 1)) != -1) break;
                buffer = new byte[2048];
            }
            byArray = wantedLength > 0 ? baos.toByteArray() : new byte[]{};
        }
        catch (SeeTecException ex) {
            throw ex;
        }
        catch (NumberFormatException nfe) {
            throw new SeeTecException(-20001, "Can't convert content-length into number: " + nfe.getMessage());
        }
        catch (SocketException | UnknownHostException ex) {
            throw new SeeTecException(-20100, ex.getMessage() + ", " + networkParameter);
        }
        catch (Throwable ex) {
            LOGGER.error("Error [" + ex.getMessage() + "] sending HTTP Request [" + url + "] for " + networkParameter);
            throw new SeeTecException(-20001, ex.getMessage() + ", " + networkParameter);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    private static void readChunkedStream(InputStream is, ByteArrayOutputStream baos, String returnAt) throws IOException {
        byte[] endOfChunked = new byte[]{13, 10, 48, 13, 10, 13, 10};
        while (Basic.indexOfByteArray(baos.toByteArray(), endOfChunked, 0) < 0) {
            byte[] buffer = new byte[1024];
            int readLength = is.read(buffer);
            if (readLength > 0) {
                baos.write(buffer, 0, readLength);
            }
            if (readLength > 0) continue;
        }
        byte[] httpResponse = baos.toByteArray();
        baos.reset();
        NetworkHelper.cleanChunkResponse(httpResponse, baos, returnAt);
    }

    protected static void cleanChunkResponse(byte[] httpResponse, ByteArrayOutputStream baos, String returnAt) {
        int chunkLength;
        int crlfPointer = Basic.indexOfByteArray(httpResponse, SSLConstantsIntf.DOUBLE_CRLF_BYTE, 0);
        baos.write(httpResponse, 0, crlfPointer);
        if (returnAt != null && baos.toString().contains(returnAt)) {
            return;
        }
        int startPointer = baos.size();
        do {
            crlfPointer = Basic.indexOfByteArray(httpResponse, SSLConstantsIntf.CRLF_BYTE, startPointer);
            byte[] chunkSize = Arrays.copyOfRange(httpResponse, startPointer, crlfPointer);
            String chunkSizeString = new String(chunkSize);
            chunkSizeString = chunkSizeString.replace("\r", "").replace("\n", "").replace(" ", "");
            while (chunkSizeString.length() < 8) {
                chunkSizeString = "0" + chunkSizeString;
            }
            chunkLength = Basic.byteArrayToInt4(Basic.hexStringToByteArray(chunkSizeString));
            baos.write(httpResponse, crlfPointer, chunkLength);
            if (returnAt != null && baos.toString().contains(returnAt)) {
                return;
            }
            startPointer = startPointer + chunkLength + SSLConstantsIntf.CRLF_BYTE.length + chunkSize.length;
        } while (chunkLength > 0);
        baos.write(SSLConstantsIntf.DOUBLE_CRLF_BYTE, 0, SSLConstantsIntf.DOUBLE_CRLF_BYTE.length);
    }
}

