/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.HttpVersion;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;

public class HttpHandlerImpl
extends Basic
implements HttpHandler {
    private static final String CLASS_NAME = "de.seetec.v5.shared.net.HttpHandlerImpl";
    private String boundary = "";
    private boolean readServerPushHeaderOnly = false;
    private final CloseableHttpClient httpclient;
    private final HttpClientContext context;
    private final RequestConfig config;
    private final NetworkParameter networkParameter;
    private HttpHandlerIntf listener;
    private String url;
    private volatile boolean shutdown;
    private final ReentrantLock lock = new ReentrantLock();

    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    public void setServerPushHeaderOnly(boolean readServerPushHeaderOnly) {
        this.readServerPushHeaderOnly = readServerPushHeaderOnly;
    }

    public static String getBoundary(StringBuilder header) {
        String[] headerLines = header.toString().split("\r\n");
        if (headerLines.length > 0) {
            String boundary = headerLines[0].trim();
            if (!boundary.contains("--")) {
                boundary = "--" + boundary;
            }
            return boundary;
        }
        return "";
    }

    private static boolean getHeader(ByteArrayOutputStream byteArrayOutputStream, StringBuilder header) {
        byte[] input = byteArrayOutputStream.toByteArray();
        int index = Basic.indexOfByteArray(input, DOUBLE_CRLF_BYTE, 0);
        if (index > 0) {
            byte[] headerBytes = new byte[index];
            System.arraycopy(input, 0, headerBytes, 0, index);
            header.append(new String(headerBytes));
            byteArrayOutputStream.reset();
            byteArrayOutputStream.write(input, index, input.length - index);
            return true;
        }
        return false;
    }

    private static int getContentLength(StringBuilder header) {
        String[] headerLines;
        String headerString = header.toString();
        if (!headerString.toLowerCase().contains("content-length")) {
            return -1;
        }
        for (String headerLine : headerLines = headerString.split("\r\n")) {
            if (!headerLine.toLowerCase().contains("content-length")) continue;
            String length = headerLine.toLowerCase().replace("content-length:", "");
            try {
                return Integer.parseInt(length.trim());
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }

    protected static byte[] getServerPushSegment(ByteArrayOutputStream byteArrayOutputStream, String boundary, int contentLength) {
        if (byteArrayOutputStream == null || boundary == null || byteArrayOutputStream.size() == 0) {
            return null;
        }
        byte[] input = byteArrayOutputStream.toByteArray();
        if (contentLength == -1) {
            contentLength = Basic.indexOfByteArray(input, boundary.getBytes(), 0);
        }
        if (contentLength > 0 && byteArrayOutputStream.size() >= contentLength) {
            byte[] content = new byte[contentLength];
            System.arraycopy(input, 0, content, 0, contentLength);
            byteArrayOutputStream.reset();
            byteArrayOutputStream.write(input, contentLength, input.length - contentLength);
            return content;
        }
        return null;
    }

    public HttpHandlerImpl(NetworkParameter networkParameter) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        this(networkParameter, false);
    }

    public HttpHandlerImpl(NetworkParameter networkParameter, boolean disableRedirection) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        PoolingHttpClientConnectionManager connectionManager;
        this.networkParameter = networkParameter;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(networkParameter.getUserPWD()[0], networkParameter.getUserPWD()[1].toCharArray());
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(null, null, -1, null, null);
        provider.setCredentials(authScope, (Credentials)credentials);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        basicAuth.initPreemptive((Credentials)credentials);
        HttpHost httpHost = new HttpHost(networkParameter.useHTTPS() ? "https" : "http", networkParameter.getHost(), networkParameter.useHTTPS() ? networkParameter.getSSLport() : networkParameter.getHTTPport());
        authCache.put(httpHost, (AuthScheme)basicAuth);
        this.context = new HttpClientContext();
        this.context.setCredentialsProvider((CredentialsProvider)provider);
        if (!this.networkParameter.isStartWithoutAuthentication()) {
            this.context.setAuthCache((AuthCache)authCache);
        }
        this.config = RequestConfig.custom().setConnectTimeout((long)networkParameter.getSoTimeout(), TimeUnit.MILLISECONDS).setConnectionRequestTimeout((long)networkParameter.getSoTimeout(), TimeUnit.MILLISECONDS).build();
        if (this.networkParameter.useHTTPS()) {
            TrustAllStrategy trustAllStrategy = new TrustAllStrategy();
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)trustAllStrategy).build();
            NoopHostnameVerifier hostnameVerifier = new NoopHostnameVerifier();
            SSLConnectionSocketFactory sslConnectionSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContext).setHostnameVerifier((HostnameVerifier)hostnameVerifier).setTlsVersions(new TLS[]{TLS.V_1_2, TLS.V_1_0}).build();
            connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        } else {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(200);
        if (disableRedirection) {
            RedirectStrategy noRedirectStrategy = new RedirectStrategy(){

                public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) {
                    return false;
                }

                public URI getLocationURI(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException {
                    return null;
                }
            };
            this.httpclient = HttpClients.custom().setRedirectStrategy(noRedirectStrategy).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        } else {
            this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    @Override
    public String readPutRequest(String url, String body) throws SeeTecException {
        return this.readPutRequest(url, body, false);
    }

    @Override
    public String readPutRequest(String url, byte[] body) throws SeeTecException {
        try {
            HttpPut httpPut = new HttpPut(this.getCompleteUri(url));
            ByteArrayEntity entity = new ByteArrayEntity(body, ContentType.APPLICATION_OCTET_STREAM, false);
            httpPut.setEntity((HttpEntity)entity);
            HttpEntity responseEntity = this.readHttpRequest(this.httpclient, (BasicClassicHttpRequest)httpPut, this.context, this.config);
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (IOException | InterruptedException | URISyntaxException | ParseException ex) {
            throw new SeeTecException(-20100, ex.getMessage());
        }
    }

    @Override
    public String readPutRequest(String url, String body, boolean closeConnection) throws SeeTecException {
        try {
            HttpPut httpPut = new HttpPut(this.getCompleteUri(url));
            if (closeConnection) {
                httpPut.addHeader("Connection", (Object)"close");
            }
            if (body == null) {
                body = "";
            }
            StringEntity entity = new StringEntity(body, Charset.forName("UTF-8"));
            httpPut.setEntity((HttpEntity)entity);
            HttpEntity responseEntity = this.readHttpRequest(this.httpclient, (BasicClassicHttpRequest)httpPut, this.context, this.config);
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (IOException | InterruptedException | URISyntaxException | ParseException ex) {
            throw new SeeTecException(-20100, ex.getMessage());
        }
    }

    @Override
    public String readPostRequest(String url, String body) throws SeeTecException {
        return this.readPostRequest(url, body, false);
    }

    @Override
    public String readPostRequest(String url, String body, boolean closeConnection) throws SeeTecException {
        return this.readPostRequest(url, body, closeConnection, null);
    }

    @Override
    public String readPostRequest(String url, String body, boolean closeConnection, String contentType) throws SeeTecException {
        try {
            HttpPost httpPost = new HttpPost(this.getCompleteUri(url));
            if (closeConnection) {
                httpPost.addHeader("Connection", (Object)"close");
            }
            if (contentType != null) {
                httpPost.addHeader("Content-Type", (Object)contentType);
            }
            if (body == null) {
                body = "";
            }
            StringEntity entity = new StringEntity(body, Charset.forName("UTF-8"));
            httpPost.setEntity((HttpEntity)entity);
            HttpEntity responseEntity = this.readHttpRequest(this.httpclient, (BasicClassicHttpRequest)httpPost, this.context, this.config);
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (IOException | InterruptedException | URISyntaxException | ParseException ex) {
            throw new SeeTecException(-20100, ex.getMessage());
        }
    }

    @Override
    public String readPostRequestMultipart(String url, String name, byte[] payload, ContentType contentType, String filename) throws SeeTecException {
        if (url == null || name == null || payload == null || contentType == null || filename == null) {
            throw new SeeTecException(-20002, "Input parameter is null");
        }
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody(name, payload, contentType, filename);
            HttpEntity multipartEntity = builder.build();
            HttpPost httpPost = new HttpPost(this.getCompleteUri(url));
            httpPost.setEntity(multipartEntity);
            HttpEntity responseEntity = this.readHttpRequest(this.httpclient, (BasicClassicHttpRequest)httpPost, this.context, this.config);
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (IOException | InterruptedException | URISyntaxException | ParseException ex) {
            throw new SeeTecException(-20100, ex.getMessage());
        }
    }

    @Override
    public String readDeleteRequest(String url) throws SeeTecException {
        try {
            HttpDelete httpDelete = new HttpDelete(this.getCompleteUri(url));
            HttpEntity responseEntity = this.readHttpRequest(this.httpclient, (BasicClassicHttpRequest)httpDelete, this.context, this.config);
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (IOException | InterruptedException | URISyntaxException | ParseException ex) {
            throw new SeeTecException(-20100, ex.getMessage());
        }
    }

    @Override
    public String readGetRequest(String url) throws SeeTecException {
        return this.readGetRequest(url, false);
    }

    @Override
    public String readGetRequest(String url, boolean closeConnection) throws SeeTecException {
        try {
            HttpGet httpGet = new HttpGet(this.getCompleteUri(url));
            if (closeConnection) {
                httpGet.addHeader("Connection", (Object)"close");
            }
            HttpEntity responseEntity = this.readHttpRequest(this.httpclient, (BasicClassicHttpRequest)httpGet, this.context, this.config);
            return EntityUtils.toString((HttpEntity)responseEntity);
        }
        catch (SeeTecException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new SeeTecException(-20100, ex.getMessage());
        }
    }

    @Override
    public byte[] readGetRequestAsByteArray(String url) throws SeeTecException {
        return this.readGetRequestAsByteArray(url, false);
    }

    @Override
    public byte[] readGetRequestAsByteArray(String url, boolean closeConnection) throws SeeTecException {
        try {
            HttpGet httpGet = new HttpGet(this.getCompleteUri(url));
            if (closeConnection) {
                httpGet.addHeader("Connection", (Object)"close");
            }
            HttpEntity responseEntity = this.readHttpRequest(this.httpclient, (BasicClassicHttpRequest)httpGet, this.context, this.config);
            return EntityUtils.toByteArray((HttpEntity)responseEntity);
        }
        catch (SeeTecException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new SeeTecException(-20100, ex.getMessage());
        }
    }

    private HttpEntity readHttpRequest(CloseableHttpClient httpClient, BasicClassicHttpRequest httpRequestBase, HttpClientContext httpClientContext, RequestConfig requestConfig) throws SeeTecException, InterruptedException {
        if (this.lock.tryLock(this.networkParameter.getSoTimeout() * 3, TimeUnit.MILLISECONDS)) {
            CloseableHttpResponse response = null;
            try {
                BufferedHttpEntity responseEntity;
                httpClientContext.setRequestConfig(requestConfig);
                response = httpClient.execute((ClassicHttpRequest)httpRequestBase, (HttpContext)httpClientContext);
                int statusCode = response.getCode();
                if (statusCode == HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) {
                    throw new SeeTecException(-21657, "Unauthorized Access", HTTPStatusCode.HTTP_UNAUTHORIZED);
                }
                if (statusCode >= 400) {
                    throw new SeeTecException(-20100, "HTTP Error. URL: " + httpRequestBase.getMethod() + " " + httpRequestBase.getRequestUri(), HTTPStatusCode.valueOf(statusCode));
                }
                if (statusCode == HTTPStatusCode.HTTP_NO_CONTENT.getStatusCode()) {
                    StringEntity stringEntity = new StringEntity(new String());
                    return stringEntity;
                }
                BufferedHttpEntity bufferedHttpEntity = responseEntity = new BufferedHttpEntity(response.getEntity());
                return bufferedHttpEntity;
            }
            catch (SeeTecException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new SeeTecException(-20100, "Device not reachable. URL: " + httpRequestBase.getRequestUri() + "Error: " + ex.getMessage());
            }
            finally {
                try {
                    if (response != null && response.getEntity() != null) {
                        response.close();
                    }
                }
                catch (Throwable throwable) {}
                this.lock.unlock();
            }
        }
        throw new SeeTecException(-20100, "Device not reachable. URL: " + httpRequestBase.getRequestUri() + "Error: Cannot aquire lock for HTTP handler");
    }

    @Override
    public void readServerPushRequest(String url, HttpHandlerIntf listener) throws SeeTecException {
        this.readServerPushRequest(url, listener, HttpVersion.HTTP_1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readServerPushRequest(String url, HttpHandlerIntf listener, HttpVersion httpVersion) throws SeeTecException {
        block22: {
            this.listener = listener;
            this.url = url;
            this.shutdown = false;
            CloseableHttpResponse response = null;
            try {
                int statusCode;
                HttpGet httpGet = new HttpGet(this.getCompleteUri(this.url));
                httpGet.setConfig(this.config);
                if (httpVersion == HttpVersion.HTTP_1_0) {
                    httpGet.setVersion((ProtocolVersion)org.apache.hc.core5.http.HttpVersion.HTTP_1_0);
                }
                if ((statusCode = (response = this.httpclient.execute((ClassicHttpRequest)httpGet, (HttpContext)this.context)).getCode()) >= 400) {
                    if (statusCode == HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) {
                        this.listener.sendStatusService(-21657);
                    } else {
                        this.listener.sendStatusService(-20100);
                    }
                    break block22;
                }
                this.listener.sendStatusService(0);
                byte[] buffer = new byte[4096];
                HttpEntity responseEntity = response.getEntity();
                InputStream inputStream = responseEntity.getContent();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int contentLength = -1;
                StringBuilder header = new StringBuilder();
                int read = -1;
                block11: while (!this.shutdown) {
                    read = inputStream.read(buffer);
                    if (read == -1) {
                        break;
                    }
                    byteArrayOutputStream.write(buffer, 0, read);
                    while (true) {
                        int length;
                        if (header.length() == 0 && HttpHandlerImpl.getHeader(byteArrayOutputStream, header) && (length = HttpHandlerImpl.getContentLength(header)) != -1) {
                            contentLength = length;
                        }
                        if (header.length() <= 0) continue block11;
                        if (this.boundary.isEmpty()) {
                            this.boundary = HttpHandlerImpl.getBoundary(header);
                        }
                        if (this.readServerPushHeaderOnly) {
                            this.listener.deliverContent(header.toString().getBytes());
                            header = new StringBuilder();
                            continue;
                        }
                        byte[] body = HttpHandlerImpl.getServerPushSegment(byteArrayOutputStream, this.boundary, contentLength);
                        if (body == null) continue block11;
                        listener.deliverContent(body);
                        header = new StringBuilder();
                        contentLength = -1;
                    }
                }
            }
            catch (Exception ex) {
                this.listener.sendStatusService(-20100);
            }
            finally {
                try {
                    if (response != null && response.getEntity() != null) {
                        response.close();
                    }
                }
                catch (Exception exception) {}
                this.shutdown();
            }
        }
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.shutdown = true;
        try {
            if (this.httpclient != null) {
                this.httpclient.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private URI getCompleteUri(String url) throws URISyntaxException {
        String[] urlLines = HttpHandlerImpl.getURLAndQuery(url);
        URI uri = new URIBuilder().setScheme(this.networkParameter.useHTTPS() ? "https" : "http").setHost(this.networkParameter.getHost()).setPath(urlLines[0]).setCustomQuery(urlLines.length > 1 && urlLines[1] != null ? urlLines[1] : null).setPort(this.networkParameter.useHTTPS() ? this.networkParameter.getSSLport() : this.networkParameter.getHTTPport()).build();
        return uri;
    }

    private static String[] getURLAndQuery(String url) {
        int index = url.indexOf("?");
        String[] result = index == -1 ? new String[]{url} : new String[]{url.substring(0, index), url.substring(index + 1)};
        return result;
    }
}

