/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.interaction;

import de.seetec.v5.shared.interaction.DataObject;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncLprAssociatedCamsDataObject
extends DataObject {
    public static final SyncLprAssociatedCamsDataObject MAGIC = SyncLprAssociatedCamsDataObject.createInstance(-1L, -1L, -1L, null, null, null, null, null, null);
    public static final String INSERT_STMT = "INSERT INTO LPR_ASSOCIATEDCAMS (changeTime, ETYID, cam1, cam2, cam3, layer1, layer2, layer3, SYNCID) VALUES(?,?,?,?,?,?,?,?,?)";
    private static final Logger LOGGER = LogManager.getLogger(SyncLprAssociatedCamsDataObject.class);
    private static final long serialVersionUID = 2358671037744699634L;
    private long changetime;
    private long etyid;
    private long syncid;
    private List<Long> cams = new ArrayList<Long>(3);
    private List<Long> layers = new ArrayList<Long>(3);

    private static SyncLprAssociatedCamsDataObject createInstance(long changeTime, long entityId, long syncID, Long c1, Long c2, Long c3, Long l1, Long l2, Long l3) {
        SyncLprAssociatedCamsDataObject result = new SyncLprAssociatedCamsDataObject();
        result.changetime = changeTime;
        result.etyid = entityId;
        result.syncid = syncID;
        result.cams = new ArrayList<Long>(3);
        if (c1 != null) {
            result.cams.add(c1);
        }
        if (c2 != null) {
            result.cams.add(c2);
        }
        if (c3 != null) {
            result.cams.add(c3);
        }
        result.layers = new ArrayList<Long>(3);
        if (l1 != null) {
            result.layers.add(l1);
        }
        if (l2 != null) {
            result.layers.add(l2);
        }
        if (l3 != null) {
            result.layers.add(l3);
        }
        return result;
    }

    public static SyncLprAssociatedCamsDataObject fromGObject(GObject go) {
        SyncLprAssociatedCamsDataObject result = null;
        try {
            Long c1 = null;
            Long c2 = null;
            Long c3 = null;
            Long l1 = null;
            Long l2 = null;
            Long l3 = null;
            long[] values = go.getChildAt(0).tryGetAsArrayOfLong();
            long time = values[0];
            long ety = values[1];
            long sync = values[2];
            values = go.getChildAt(1).tryGetAsArrayOfLong();
            if (values.length > 0) {
                c1 = values[0];
            }
            if (values.length > 1) {
                c2 = values[1];
            }
            if (values.length > 2) {
                c3 = values[2];
            }
            if ((values = go.getChildAt(2).tryGetAsArrayOfLong()).length > 0) {
                l1 = values[0];
            }
            if (values.length > 1) {
                l2 = values[1];
            }
            if (values.length > 2) {
                l3 = values[2];
            }
            result = SyncLprAssociatedCamsDataObject.createInstance(time, ety, sync, c1, c2, c3, l1, l2, l3);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex, (Throwable)ex);
        }
        return result;
    }

    public static SyncLprAssociatedCamsDataObject fromResultSet(ResultSet rs) throws SQLException {
        long time = rs.getLong("CHANGETIME");
        long ety = rs.getLong("ETYID");
        long sync = rs.getLong("SYNCID");
        if (rs.wasNull()) {
            sync = 0L;
        }
        Long c1 = rs.getLong("CAM1");
        if (rs.wasNull()) {
            c1 = null;
        }
        Long c2 = rs.getLong("CAM2");
        if (rs.wasNull()) {
            c2 = null;
        }
        Long c3 = rs.getLong("CAM3");
        if (rs.wasNull()) {
            c3 = null;
        }
        Long l1 = rs.getLong("LAYER1");
        if (rs.wasNull()) {
            l1 = null;
        }
        Long l2 = rs.getLong("LAYER2");
        if (rs.wasNull()) {
            l2 = null;
        }
        Long l3 = rs.getLong("LAYER3");
        if (rs.wasNull()) {
            l3 = null;
        }
        return SyncLprAssociatedCamsDataObject.createInstance(time, ety, sync, c1, c2, c3, l1, l2, l3);
    }

    public boolean isMagic() {
        return this.changetime == -1L && this.etyid == -1L && this.syncid == -1L;
    }

    public long getSyncID() {
        return this.syncid;
    }

    public void fillInsertStatement(PreparedStatement stmt) throws SQLException {
        stmt.setLong(1, this.changetime);
        stmt.setLong(2, this.etyid);
        if (this.cams.size() > 0) {
            stmt.setLong(3, this.cams.get(0));
        } else {
            stmt.setNull(3, -5);
        }
        if (this.cams.size() > 1) {
            stmt.setLong(4, this.cams.get(1));
        } else {
            stmt.setNull(4, -5);
        }
        if (this.cams.size() > 2) {
            stmt.setLong(5, this.cams.get(2));
        } else {
            stmt.setNull(5, -5);
        }
        if (this.layers.size() > 0) {
            stmt.setLong(6, this.layers.get(0));
        } else {
            stmt.setNull(6, -5);
        }
        if (this.layers.size() > 1) {
            stmt.setLong(7, this.layers.get(1));
        } else {
            stmt.setNull(7, -5);
        }
        if (this.layers.size() > 2) {
            stmt.setLong(8, this.layers.get(2));
        } else {
            stmt.setNull(8, -5);
        }
        stmt.setLong(9, this.syncid);
    }

    public GObject toGObject() {
        GObject result = GObject.createList();
        long[] values = new long[]{this.changetime, this.etyid, this.syncid};
        result.addChild(GObject.create(values));
        long[] aCams = new long[this.cams.size()];
        for (int i = 0; i < this.cams.size(); ++i) {
            aCams[i] = this.cams.get(i);
        }
        result.addChild(GObject.create(aCams));
        long[] aLayers = new long[this.layers.size()];
        for (int i = 0; i < this.layers.size(); ++i) {
            aLayers[i] = this.layers.get(i);
        }
        result.addChild(GObject.create(aLayers));
        return result;
    }
}

