/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.util.SeeTecException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class VMParameter {
    public static String getVMParameters() {
        String vmParameters;
        try {
            RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
            StringBuilder vmTMP = new StringBuilder();
            runtimemxBean.getInputArguments().stream().filter(parameter -> parameter.startsWith("-")).forEach(parameter -> vmTMP.append((String)parameter).append(" "));
            vmParameters = vmTMP.toString();
        }
        catch (Throwable t) {
            vmParameters = "";
        }
        return vmParameters;
    }

    public static long getMaxMemory(String vmParameters) throws SeeTecException {
        String xmxParameter = "-xmx";
        if (vmParameters == null) {
            throw new SeeTecException(-20002, "Input value null");
        }
        int startOfMarker = (vmParameters = vmParameters.toLowerCase()).indexOf("-xmx");
        if (startOfMarker >= 0) {
            long xmxValue;
            int startOfValue;
            int endOfValue = startOfValue = startOfMarker + "-xmx".length();
            while (true) {
                try {
                    char c = vmParameters.charAt(endOfValue);
                    if (!Character.isDigit(c)) {
                        long value = Long.parseLong(vmParameters.substring(startOfValue, endOfValue));
                        switch (c) {
                            case 'm': {
                                xmxValue = value << 20;
                                break;
                            }
                            case 'g': {
                                xmxValue = value << 30;
                                break;
                            }
                            default: {
                                throw new SeeTecException(-20036, "Cannot parse xmx parameter!");
                            }
                        }
                        break;
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException indexOutOfBoundsException) {
                    throw new SeeTecException(-20036, "Cannot parse xmx parameter!");
                }
                ++endOfValue;
            }
            return xmxValue;
        }
        throw new SeeTecException(-20036, "Maximum memory value not set for VM.");
    }
}

