/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Date;

public class OpenProblemWrapper {
    private final long sourceId;
    private final EventType eventType;
    private final int errorCode;
    private final long timestamp;

    public OpenProblemWrapper(long sourceId, EventType eventType, int errorCode, long timestamp) throws SeeTecException {
        this.sourceId = sourceId;
        this.eventType = eventType;
        if (this.eventType == null) {
            throw new SeeTecException(-20002, "Mandatory parameter null.)");
        }
        this.errorCode = errorCode;
        this.timestamp = timestamp;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenProblemWrapper other = (OpenProblemWrapper)obj;
        if (this.sourceId != other.sourceId) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return this.eventType.getType() == other.eventType.getType();
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("SourceId: ");
        output.append(this.sourceId);
        output.append(", EventType: ");
        output.append((Object)this.eventType);
        output.append(", ErrorCode: ");
        output.append(this.errorCode);
        output.append(", Time: ");
        output.append(new Date(this.timestamp));
        return output.toString();
    }
}

