/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.pubsub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zmq.Msg;
import zmq.pipe.Pipe;

public class Dist {
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private int matching = 0;
    private int active = 0;
    private int eligible = 0;
    private boolean more = false;

    public void attach(Pipe pipe) {
        if (this.more) {
            this.pipes.add(pipe);
            Collections.swap(this.pipes, this.eligible, this.pipes.size() - 1);
            ++this.eligible;
        } else {
            this.pipes.add(pipe);
            Collections.swap(this.pipes, this.active, this.pipes.size() - 1);
            ++this.active;
            ++this.eligible;
        }
    }

    public void match(Pipe pipe) {
        int idx = this.pipes.indexOf(pipe);
        if (idx < this.matching) {
            return;
        }
        if (idx >= this.eligible) {
            return;
        }
        Collections.swap(this.pipes, idx, this.matching);
        ++this.matching;
    }

    public void unmatch() {
        this.matching = 0;
    }

    public void terminated(Pipe pipe) {
        if (this.pipes.indexOf(pipe) < this.matching) {
            Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.matching - 1);
            --this.matching;
        }
        if (this.pipes.indexOf(pipe) < this.active) {
            Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.active - 1);
            --this.active;
        }
        if (this.pipes.indexOf(pipe) < this.eligible) {
            Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.eligible - 1);
            --this.eligible;
        }
        this.pipes.remove(pipe);
    }

    public void activated(Pipe pipe) {
        if (this.eligible < this.pipes.size()) {
            Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.eligible);
            ++this.eligible;
        }
        if (!this.more && this.active < this.pipes.size()) {
            Collections.swap(this.pipes, this.eligible - 1, this.active);
            ++this.active;
        }
    }

    public boolean sendToAll(Msg msg) {
        this.matching = this.active;
        return this.sendToMatching(msg);
    }

    public boolean sendToMatching(Msg msg) {
        boolean msgMore = msg.hasMore();
        this.distribute(msg);
        if (!msgMore) {
            this.active = this.eligible;
        }
        this.more = msgMore;
        return true;
    }

    private void distribute(Msg msg) {
        if (this.matching == 0) {
            return;
        }
        for (int idx = 0; idx < this.matching; ++idx) {
            if (this.write(this.pipes.get(idx), msg)) continue;
            --idx;
        }
    }

    public boolean hasOut() {
        return true;
    }

    private boolean write(Pipe pipe, Msg msg) {
        if (!pipe.write(msg)) {
            Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.matching - 1);
            --this.matching;
            Collections.swap(this.pipes, this.pipes.indexOf(pipe), this.active - 1);
            --this.active;
            Collections.swap(this.pipes, this.active, this.eligible - 1);
            --this.eligible;
            return false;
        }
        if (!msg.hasMore()) {
            pipe.flush();
        }
        return true;
    }

    public boolean checkHwm() {
        for (int idx = 0; idx < this.matching; ++idx) {
            if (this.pipes.get(idx).checkHwm()) continue;
            return false;
        }
        return true;
    }

    int active() {
        return this.active;
    }

    int eligible() {
        return this.eligible;
    }

    int matching() {
        return this.matching;
    }
}

