/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jdk.net.Sockets;
import zmq.Options;
import zmq.ZError;
import zmq.io.net.Address;

public class TcpUtils {
    public static final boolean WITH_EXTENDED_KEEPALIVE = SocketOptionsProvider.access$000();

    private TcpUtils() {
    }

    public static void tuneTcpSocket(SocketChannel channel) throws IOException {
        TcpUtils.setOption(channel, socket -> socket.setTcpNoDelay(true));
    }

    public static void tuneTcpKeepalives(SocketChannel channel, int tcpKeepAlive, int tcpKeepAliveCnt, int tcpKeepAliveIdle, int tcpKeepAliveIntvl) {
        TcpUtils.setOption(channel, socket -> {
            socket.setKeepAlive(tcpKeepAlive == 1);
            if (WITH_EXTENDED_KEEPALIVE) {
                SocketOptionsProvider.conditionnalSet(socket, SocketOptionsProvider.TCP_KEEPCOUNT, tcpKeepAliveCnt);
                SocketOptionsProvider.conditionnalSet(socket, SocketOptionsProvider.TCP_KEEPIDLE, tcpKeepAliveIdle);
                SocketOptionsProvider.conditionnalSet(socket, SocketOptionsProvider.TCP_KEEPINTERVAL, tcpKeepAliveIntvl);
            }
        });
    }

    public static boolean setTcpReceiveBuffer(Channel channel, int rcvbuf) {
        TcpUtils.setOption(channel, socket -> socket.setReceiveBufferSize(rcvbuf), socket -> socket.setReceiveBufferSize(rcvbuf));
        return true;
    }

    public static boolean setTcpSendBuffer(Channel channel, int sndbuf) {
        TcpUtils.setOption(channel, socket -> socket.setSendBufferSize(sndbuf));
        return true;
    }

    public static boolean setIpTypeOfService(Channel channel, int tos) {
        TcpUtils.setOption(channel, socket -> socket.setTrafficClass(tos));
        return true;
    }

    public static boolean setReuseAddress(Channel channel, boolean reuse) {
        TcpUtils.setOption(channel, socket -> socket.setReuseAddress(reuse), socket -> socket.setReuseAddress(reuse));
        return true;
    }

    private static void setOption(Channel channel, OptionSetter<Socket> setter) {
        TcpUtils.setOption(channel, setter, s -> {});
    }

    private static void setOption(Channel channel, OptionSetter<Socket> setter, OptionSetter<ServerSocket> serverSetter) {
        try {
            if (channel instanceof ServerSocketChannel) {
                serverSetter.setOption(((ServerSocketChannel)channel).socket());
            } else if (channel instanceof SocketChannel) {
                setter.setOption(((SocketChannel)channel).socket());
            }
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    public static void unblockSocket(SelectableChannel ... channels) throws IOException {
        for (SelectableChannel ch : channels) {
            ch.configureBlocking(false);
        }
    }

    public static void enableIpv4Mapping(SelectableChannel channel) {
    }

    public static Address getPeerIpAddress(SocketChannel channel) {
        SocketAddress address = channel.socket().getRemoteSocketAddress();
        return new Address(address);
    }

    private static interface OptionSetter<S> {
        public void setOption(S var1) throws IOException;
    }

    private static final class SocketOptionsProvider {
        private static final SocketOption<Integer> TCP_KEEPCOUNT;
        private static final SocketOption<Integer> TCP_KEEPIDLE;
        private static final SocketOption<Integer> TCP_KEEPINTERVAL;
        private static final boolean WITH_EXTENDED_KEEPALIVE;

        private SocketOptionsProvider() {
        }

        private static void conditionnalSet(Socket socket, SocketOption<Integer> option, int value) throws IOException {
            if (value >= 0) {
                Sockets.setOption(socket, option, Integer.valueOf(value));
            }
        }

        static /* synthetic */ boolean access$000() {
            return WITH_EXTENDED_KEEPALIVE;
        }

        static {
            SocketOption tryCount = null;
            SocketOption tryIdle = null;
            SocketOption tryInterval = null;
            boolean extendedKeepAlive = false;
            try {
                Class<?> eso = Options.class.getClassLoader().loadClass("jdk.net.ExtendedSocketOptions");
                tryCount = (SocketOption)eso.getField("TCP_KEEPCOUNT").get(null);
                tryIdle = (SocketOption)eso.getField("TCP_KEEPIDLE").get(null);
                tryInterval = (SocketOption)eso.getField("TCP_KEEPINTERVAL").get(null);
                extendedKeepAlive = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TCP_KEEPCOUNT = tryCount;
            TCP_KEEPIDLE = tryIdle;
            TCP_KEEPINTERVAL = tryInterval;
            WITH_EXTENDED_KEEPALIVE = extendedKeepAlive;
        }
    }
}

