/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import zmq.io.net.NetProtocol;
import zmq.io.net.ProtocolFamily;

public class Address {
    private final NetProtocol protocol;
    private final String address;
    private IZAddress resolved;

    @Deprecated
    public Address(String protocol, String address) {
        this.protocol = NetProtocol.getProtocol(protocol);
        this.address = address;
        this.resolved = null;
    }

    public Address(NetProtocol protocol, String address) {
        this.protocol = protocol;
        this.address = address;
        this.resolved = null;
    }

    public Address(SocketAddress socketAddress) {
        InetSocketAddress sockAddr = (InetSocketAddress)socketAddress;
        this.address = sockAddr.getAddress().getHostAddress() + ":" + sockAddr.getPort();
        this.protocol = NetProtocol.tcp;
        this.resolved = null;
    }

    public String toString() {
        if (this.isResolved()) {
            return this.resolved.toString();
        }
        if (this.protocol != null && !this.address.isEmpty()) {
            return this.protocol.name() + "://" + this.address;
        }
        return "";
    }

    public NetProtocol protocol() {
        return this.protocol;
    }

    public String address() {
        return this.address;
    }

    public String host() {
        int portDelimiter = this.address.lastIndexOf(58);
        if (portDelimiter > 0) {
            return this.address.substring(0, portDelimiter);
        }
        return this.address;
    }

    public IZAddress resolved() {
        return this.resolved;
    }

    public boolean isResolved() {
        return this.resolved != null;
    }

    public IZAddress resolve(boolean ipv6) {
        this.resolved = this.protocol.zresolve(this.address, ipv6);
        return this.resolved;
    }

    public static interface IZAddress {
        public ProtocolFamily family();

        public String toString(int var1);

        public InetSocketAddress resolve(String var1, boolean var2, boolean var3);

        public SocketAddress address();

        public SocketAddress sourceAddress();
    }
}

